/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.util;

import com.volmit.adapt.Adapt;
import com.volmit.adapt.AdaptConfig;
import com.volmit.adapt.util.J;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.UUID;

public class SQLManager {
    private static final String TABLE_NAME = "ADAPT_DATA";
    private static final String CREATE_TABLE_QUERY = "CREATE TABLE ADAPT_DATA (UUID char(36) NOT NULL UNIQUE, DATA MEDIUMTEXT NOT NULL)";
    private static final String UPDATE_QUERY = "INSERT INTO ADAPT_DATA (UUID, DATA) VALUES('%s', '%s') ON DUPLICATE KEY UPDATE DATA='%s'";
    private static final String FETCH_QUERY = "SELECT DATA FROM ADAPT_DATA WHERE UUID='%s'";
    private static final String DELETE_QUERY = "DELETE FROM ADAPT_DATA WHERE UUID='%s'";
    private Connection connection;

    public void establishConnection() {
        AdaptConfig config = AdaptConfig.get();
        try {
            this.connection = DriverManager.getConnection(this.assembleUrl(config), config.getSql().getUsername(), config.getSql().getPassword());
            if (!this.connection.isValid(30)) {
                Adapt.error("Timeout while trying to establish a connection to the SQL server!");
                this.connection.close();
                this.connection = null;
            } else {
                Adapt.info(String.format("Connected to SQL Database \"%s\" at %s:%d.", config.getSql().getDatabase(), config.getSql().getHost(), config.getSql().getPort()));
                if (!this.connection.getMetaData().getTables(null, null, TABLE_NAME, new String[]{"TABLE"}).next()) {
                    Adapt.info("\tAdapt Table does not exist, creating...");
                    this.connection.createStatement().executeUpdate(CREATE_TABLE_QUERY);
                    Adapt.info("\tCreated Table \"ADAPT_DATA\" on database " + config.getSql().getDatabase() + ".");
                }
            }
        }
        catch (SQLException e) {
            Adapt.error("Failed to establish a connection to the SQL server!");
            Adapt.error("\t" + e.getClass().getSimpleName() + (String)(e.getMessage() != null ? ": " + e.getMessage() : ""));
            this.connection = null;
        }
    }

    public void closeConnection() {
        if (this.connection != null) {
            try {
                this.connection.close();
            }
            catch (SQLException e) {
                Adapt.error("Failed to close the connection to the SQL server!");
                Adapt.error("\t" + e.getClass().getSimpleName() + (String)(e.getMessage() != null ? ": " + e.getMessage() : ""));
            }
        }
    }

    public void updateData(UUID uuid, String data) {
        J.a(() -> {
            try {
                this.connection.createStatement().executeUpdate(String.format(UPDATE_QUERY, uuid.toString(), data, data));
            }
            catch (SQLException e) {
                Adapt.error("Failed to write data to the SQL server!");
                Adapt.error("\t" + e.getClass().getSimpleName() + (String)(e.getMessage() != null ? ": " + e.getMessage() : ""));
            }
        });
    }

    public void delete(UUID uuid) {
        J.a(() -> {
            try {
                this.connection.createStatement().executeUpdate(String.format(DELETE_QUERY, uuid.toString()));
            }
            catch (SQLException e) {
                Adapt.error("Failed to delete data from the SQL server!");
                Adapt.error("\t" + e.getClass().getSimpleName() + (String)(e.getMessage() != null ? ": " + e.getMessage() : ""));
            }
        });
    }

    public String fetchData(UUID uuid) {
        try {
            ResultSet set = this.connection.prepareStatement(String.format(FETCH_QUERY, uuid.toString())).executeQuery();
            if (!set.next()) {
                return null;
            }
            return set.getString("DATA");
        }
        catch (SQLException e) {
            Adapt.error("Failed to read data from the SQL server!");
            Adapt.error("\t" + e.getClass().getSimpleName() + (String)(e.getMessage() != null ? ": " + e.getMessage() : ""));
            return null;
        }
    }

    public boolean useSql() {
        return AdaptConfig.get().isUseSql() && this.connection != null;
    }

    private String assembleUrl(AdaptConfig config) {
        return String.format("jdbc:mysql://%s:%d/%s", config.getSql().getHost(), config.getSql().getPort(), config.getSql().getDatabase());
    }

    static {
        IBootstrap.dasBoot();
    }
}

