/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.util;

import com.volmit.adapt.Adapt;
import com.volmit.adapt.util.J;
import com.volmit.adapt.util.M;
import com.volmit.adapt.util.NastyRunnable;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinWorkerThread;

public class TaskExecutor {
    private final ExecutorService service;
    private int xc = 1;

    public TaskExecutor(int threadLimit, final int priority, final String name) {
        if (threadLimit == 1) {
            this.service = Executors.newSingleThreadExecutor(r -> {
                Thread t = new Thread(r);
                t.setName(name);
                t.setPriority(priority);
                return t;
            });
        } else if (threadLimit > 1) {
            ForkJoinPool.ForkJoinWorkerThreadFactory factory = new ForkJoinPool.ForkJoinWorkerThreadFactory(){

                @Override
                public ForkJoinWorkerThread newThread(ForkJoinPool pool) {
                    ForkJoinWorkerThread worker = ForkJoinPool.defaultForkJoinWorkerThreadFactory.newThread(pool);
                    worker.setName(name + " " + TaskExecutor.this.xc++);
                    worker.setPriority(priority);
                    return worker;
                }
            };
            this.service = new ForkJoinPool(threadLimit, factory, null, false);
        } else {
            this.service = Executors.newCachedThreadPool(r -> {
                Thread t = new Thread(r);
                t.setName(name + " " + this.xc++);
                t.setPriority(priority);
                return t;
            });
        }
    }

    public TaskGroup startWork() {
        return new TaskGroup(this);
    }

    public void close() {
        J.a(() -> {
            J.sleep(10000L);
            this.service.shutdown();
        });
    }

    public void closeNow() {
        this.service.shutdown();
    }

    static {
        IBootstrap.dasBoot();
    }

    public static class TaskGroup {
        private final List<AssignedTask> tasks = new ArrayList<AssignedTask>();
        private final TaskExecutor e;

        public TaskGroup(TaskExecutor e) {
            this.e = e;
        }

        public TaskGroup queue(NastyRunnable ... r) {
            for (NastyRunnable i : r) {
                this.tasks.add(new AssignedTask(i));
            }
            return this;
        }

        public TaskGroup queue(List<NastyRunnable> r) {
            for (NastyRunnable i : r) {
                this.tasks.add(new AssignedTask(i));
            }
            return this;
        }

        public TaskResult execute() {
            double timeElapsed = 0.0;
            int tasksExecuted = 0;
            int tasksFailed = 0;
            int tasksCompleted = 0;
            this.tasks.forEach(t -> t.go(this.e));
            long msv = M.ns();
            block2: while (true) {
                try {
                    Thread.sleep(0L);
                }
                catch (InterruptedException e1) {
                    Adapt.verbose("Interrupted while waiting for tasks to complete");
                }
                for (AssignedTask i : this.tasks) {
                    if (!i.state.equals((Object)TaskState.QUEUED) && !i.state.equals((Object)TaskState.RUNNING)) continue;
                    continue block2;
                }
                break;
            }
            timeElapsed = (double)(M.ns() - msv) / 1000000.0;
            for (AssignedTask i : this.tasks) {
                if (i.state.equals((Object)TaskState.COMPLETED)) {
                    ++tasksCompleted;
                } else {
                    ++tasksFailed;
                }
                ++tasksExecuted;
            }
            return new TaskResult(timeElapsed, tasksExecuted, tasksFailed, tasksCompleted);
        }

        static {
            IBootstrap.dasBoot();
        }
    }

    public static class AssignedTask {
        private final NastyRunnable task;
        private TaskState state;

        public AssignedTask(NastyRunnable task) {
            this.task = task;
            this.state = TaskState.QUEUED;
        }

        public void go(TaskExecutor e) {
            e.service.execute(() -> {
                this.state = TaskState.RUNNING;
                try {
                    this.task.run();
                    this.state = TaskState.COMPLETED;
                }
                catch (Throwable ex) {
                    ex.printStackTrace();
                    this.state = TaskState.FAILED;
                }
            });
        }

        public NastyRunnable getTask() {
            return this.task;
        }

        public TaskState getState() {
            return this.state;
        }

        public void setState(TaskState state) {
            this.state = state;
        }

        static {
            IBootstrap.dasBoot();
        }
    }

    public static class TaskResult {
        public final double timeElapsed;
        public final int tasksExecuted;
        public final int tasksFailed;
        public final int tasksCompleted;

        public TaskResult(double timeElapsed, int tasksExecuted, int tasksFailed, int tasksCompleted) {
            this.timeElapsed = timeElapsed;
            this.tasksExecuted = tasksExecuted;
            this.tasksFailed = tasksFailed;
            this.tasksCompleted = tasksCompleted;
        }

        public String toString() {
            return "TaskExecutor.TaskResult(timeElapsed=" + this.timeElapsed + ", tasksExecuted=" + this.tasksExecuted + ", tasksFailed=" + this.tasksFailed + ", tasksCompleted=" + this.tasksCompleted + ")";
        }

        static {
            IBootstrap.dasBoot();
        }
    }

    public static enum TaskState {
        QUEUED,
        RUNNING,
        COMPLETED,
        FAILED;


        static {
            IBootstrap.dasBoot();
        }
    }
}

