/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.util;

import com.volmit.adapt.util.C;
import com.volmit.adapt.util.Callback;
import com.volmit.adapt.util.Element;
import com.volmit.adapt.util.ElementEvent;
import com.volmit.adapt.util.Form;
import com.volmit.adapt.util.MaterialBlock;
import com.volmit.adapt.util.extensions.java.util.List.XList;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class UIElement
implements Element {
    private final String id;
    private final List<String> lore;
    private MaterialBlock material;
    private boolean enchanted;
    private String name;
    private double progress;
    private boolean bg;
    private Callback<Element> eLeft;
    private Callback<Element> eRight;
    private Callback<Element> eShiftLeft;
    private Callback<Element> eShiftRight;
    private Callback<Element> eDraggedInto;
    private Callback<Element> eOtherDraggedInto;
    private int count;

    public UIElement(String id) {
        this.id = id;
        this.lore = new ArrayList<String>();
        this.enchanted = false;
        this.count = 1;
        this.material = new MaterialBlock(Material.AIR);
    }

    @Override
    public MaterialBlock getMaterial() {
        return this.material;
    }

    @Override
    public UIElement setMaterial(MaterialBlock material) {
        this.material = material;
        return this;
    }

    public Double clip(double value, double min, double max) {
        return Math.min(max, Math.max(min, value));
    }

    @Override
    public boolean isEnchanted() {
        return this.enchanted;
    }

    @Override
    public UIElement setEnchanted(boolean enchanted) {
        this.enchanted = enchanted;
        return this;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public UIElement setName(String name) {
        this.name = name;
        return this;
    }

    @Override
    public List<String> getLore() {
        return this.lore;
    }

    @Override
    public UIElement onLeftClick(Callback<Element> clicked) {
        this.eLeft = clicked;
        return this;
    }

    @Override
    public UIElement onRightClick(Callback<Element> clicked) {
        this.eRight = clicked;
        return this;
    }

    @Override
    public UIElement onShiftLeftClick(Callback<Element> clicked) {
        this.eShiftLeft = clicked;
        return this;
    }

    @Override
    public UIElement onShiftRightClick(Callback<Element> clicked) {
        this.eShiftRight = clicked;
        return this;
    }

    @Override
    public UIElement onDraggedInto(Callback<Element> into) {
        this.eDraggedInto = into;
        return this;
    }

    @Override
    public UIElement onOtherDraggedInto(Callback<Element> other) {
        this.eOtherDraggedInto = other;
        return this;
    }

    @Override
    public Element call(ElementEvent event, Element context) {
        try {
            switch (event) {
                case DRAG_INTO: {
                    this.eDraggedInto.run(context);
                    return this;
                }
                case LEFT: {
                    this.eLeft.run(context);
                    return this;
                }
                case OTHER_DRAG_INTO: {
                    this.eOtherDraggedInto.run(context);
                    return this;
                }
                case RIGHT: {
                    this.eRight.run(context);
                    return this;
                }
                case SHIFT_LEFT: {
                    this.eShiftLeft.run(context);
                    return this;
                }
                case SHIFT_RIGHT: {
                    this.eShiftRight.run(context);
                    return this;
                }
            }
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return this;
    }

    @Override
    public Element addLore(String loreLine) {
        XList.add(this.getLore(), this.wrapWordsWithFormatting(loreLine.replaceAll("\\Q\n\\E", " "), 52).split("\\Q\n\\E"));
        return this;
    }

    public String wrapWordsWithFormatting(String f, int l) {
        StringBuilder sb = new StringBuilder();
        String last = null;
        for (String i : Form.wrapWords(f, l).split("\\Q\n\\E")) {
            if (last != null) {
                sb.append("\n").append(C.getLastColors(last)).append(i);
            } else {
                sb.append("\n").append(i);
            }
            last = i;
        }
        return sb.substring(1);
    }

    @Override
    public Element setBackground(boolean bg) {
        this.bg = bg;
        return this;
    }

    @Override
    public boolean isBackgrond() {
        return this.bg;
    }

    @Override
    public Element setCount(int c) {
        this.count = this.clip(c, 1.0, 64.0).intValue();
        return this;
    }

    @Override
    public int getCount() {
        return this.count;
    }

    @Override
    public ItemStack computeItemStack() {
        try {
            ItemStack is = new ItemStack(this.getMaterial().getMaterial(), this.getCount(), this.getEffectiveDurability());
            ItemMeta im = is.getItemMeta();
            im.setDisplayName(this.getName());
            im.setLore(XList.copy(this.getLore()));
            if (this.isEnchanted()) {
                im.addEnchant(Enchantment.DURABILITY, 1, true);
            }
            im.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
            im.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES});
            im.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_POTION_EFFECTS});
            im.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_DYE});
            im.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_DESTROYS});
            im.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_UNBREAKABLE});
            is.setItemMeta(im);
            return is;
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public Element setProgress(double progress) {
        this.progress = this.clip(progress, 0.0, 1.0);
        return this;
    }

    @Override
    public double getProgress() {
        return this.progress;
    }

    @Override
    public short getEffectiveDurability() {
        if (this.progress == 1.0) {
            return 0;
        }
        if (this.getMaterial().getMaterial().getMaxDurability() == 0) {
            return 0;
        }
        int prog = (int)((double)this.getMaterial().getMaterial().getMaxDurability() * (1.0 - this.getProgress()));
        return this.clip(prog, 1.0, this.getMaterial().getMaterial().getMaxDurability() - 1).shortValue();
    }

    static {
        IBootstrap.dasBoot();
    }
}

