/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.util;

import com.volmit.adapt.util.CDou;
import com.volmit.adapt.util.Direction;
import com.volmit.adapt.util.Form;
import com.volmit.adapt.util.GListAdapter;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Axis;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Entity;
import org.bukkit.util.Vector;

public class VectorMath {
    public static Vector scaleStatic(Axis x, Vector v, double amt) {
        switch (x) {
            case X: {
                return VectorMath.scaleX(v, amt);
            }
            case Y: {
                return VectorMath.scaleY(v, amt);
            }
            case Z: {
                return VectorMath.scaleZ(v, amt);
            }
        }
        return null;
    }

    public static Vector scaleX(Vector v, double amt) {
        double x = v.getX();
        double y = v.getY();
        double z = v.getZ();
        double rx = x == 0.0 ? 1.0 : amt / x;
        return new Vector(x * rx, y * rx, z * rx);
    }

    public static Vector scaleY(Vector v, double amt) {
        double x = v.getX();
        double y = v.getY();
        double z = v.getZ();
        double rx = y == 0.0 ? 1.0 : amt / y;
        return new Vector(x * rx, y * rx, z * rx);
    }

    public static Vector scaleZ(Vector v, double amt) {
        double x = v.getX();
        double y = v.getY();
        double z = v.getZ();
        double rx = z == 0.0 ? 1.0 : amt / z;
        return new Vector(x * rx, y * rx, z * rx);
    }

    public static Vector reverseXZ(Vector v) {
        v.setX(-v.getX());
        v.setZ(-v.getZ());
        return v;
    }

    public static boolean isLookingNear(Location a2, Location b, double maxOff) {
        Vector actual;
        Vector perfect = VectorMath.direction(a2, b);
        return perfect.distance(actual = a2.getDirection()) <= maxOff;
    }

    public static Vector rotate(Direction current, Direction to, Vector v) {
        if (current.equals((Object)to)) {
            return v;
        }
        if (current.equals((Object)to.reverse())) {
            if (current.isVertical()) {
                return new Vector(v.getX(), -v.getY(), v.getZ());
            }
            return new Vector(-v.getX(), v.getY(), -v.getZ());
        }
        Vector c = current.toVector().clone().add(to.toVector());
        if (c.getX() == 0.0) {
            if (c.getY() != c.getZ()) {
                return VectorMath.rotate90CX(v);
            }
            return VectorMath.rotate90CCX(v);
        }
        if (c.getY() == 0.0) {
            if (c.getX() != c.getZ()) {
                return VectorMath.rotate90CY(v);
            }
            return VectorMath.rotate90CCY(v);
        }
        if (c.getZ() == 0.0) {
            if (c.getX() != c.getY()) {
                return VectorMath.rotate90CZ(v);
            }
            return VectorMath.rotate90CCZ(v);
        }
        return v;
    }

    public static Vector rotate(Direction current, Direction to, Vector v, int w, int h, int d) {
        if (current.equals((Object)to)) {
            return v;
        }
        if (current.equals((Object)to.reverse())) {
            if (current.isVertical()) {
                return new Vector(v.getX(), -v.getY() + (double)h, v.getZ());
            }
            return new Vector(-v.getX() + (double)w, v.getY(), -v.getZ() + (double)d);
        }
        Vector c = current.toVector().clone().add(to.toVector());
        if (c.getX() == 0.0) {
            if (c.getY() != c.getZ()) {
                return VectorMath.rotate90CX(v, d);
            }
            return VectorMath.rotate90CCX(v, h);
        }
        if (c.getY() == 0.0) {
            if (c.getX() != c.getZ()) {
                return VectorMath.rotate90CY(v, d);
            }
            return VectorMath.rotate90CCY(v, w);
        }
        if (c.getZ() == 0.0) {
            if (c.getX() != c.getY()) {
                return VectorMath.rotate90CZ(v, w);
            }
            return VectorMath.rotate90CCZ(v, h);
        }
        return v;
    }

    public static Vector rotate90CX(Vector v) {
        return new Vector(v.getX(), -v.getZ(), v.getY());
    }

    public static Vector rotate90CCX(Vector v) {
        return new Vector(v.getX(), v.getZ(), -v.getY());
    }

    public static Vector rotate90CY(Vector v) {
        return new Vector(-v.getZ(), v.getY(), v.getX());
    }

    public static Vector rotate90CCY(Vector v) {
        return new Vector(v.getZ(), v.getY(), -v.getX());
    }

    public static Vector rotate90CZ(Vector v) {
        return new Vector(v.getY(), -v.getX(), v.getZ());
    }

    public static Vector rotate90CCZ(Vector v) {
        return new Vector(-v.getY(), v.getX(), v.getZ());
    }

    public static Vector rotate90CX(Vector v, int s) {
        return new Vector(v.getX(), -v.getZ() + (double)s, v.getY());
    }

    public static Vector rotate90CCX(Vector v, int s) {
        return new Vector(v.getX(), v.getZ(), -v.getY() + (double)s);
    }

    public static Vector rotate90CY(Vector v, int s) {
        return new Vector(-v.getZ() + (double)s, v.getY(), v.getX());
    }

    public static Vector rotate90CCY(Vector v, int s) {
        return new Vector(v.getZ(), v.getY(), -v.getX() + (double)s);
    }

    public static Vector rotate90CZ(Vector v, int s) {
        return new Vector(v.getY(), -v.getX() + (double)s, v.getZ());
    }

    public static Vector rotate90CCZ(Vector v, int s) {
        return new Vector(-v.getY() + (double)s, v.getX(), v.getZ());
    }

    public static Vector getAxis(Direction current, Direction to) {
        if (current.equals((Object)Direction.U) || current.equals((Object)Direction.D)) {
            if (to.equals((Object)Direction.U) || to.equals((Object)Direction.D)) {
                return new Vector(1, 0, 0);
            }
            if (current.equals((Object)Direction.N) || current.equals((Object)Direction.S)) {
                return Direction.E.toVector();
            }
            return Direction.S.toVector();
        }
        return new Vector(0, 1, 0);
    }

    private static double round(double value, int precision) {
        return Double.valueOf(Form.f(value, precision));
    }

    public static Vector clip(Vector v, int decimals) {
        v.setX(VectorMath.round(v.getX(), decimals));
        v.setY(VectorMath.round(v.getY(), decimals));
        v.setZ(VectorMath.round(v.getZ(), decimals));
        return v;
    }

    public static Vector rotateVectorCC(Vector vec, Vector axis, double deg) {
        double theta = Math.toRadians(deg);
        double x = vec.getX();
        double y = vec.getY();
        double z = vec.getZ();
        double u = axis.getX();
        double v = axis.getY();
        double w = axis.getZ();
        double xPrime = u * (u * x + v * y + w * z) * (1.0 - Math.cos(theta)) + x * Math.cos(theta) + (-w * y + v * z) * Math.sin(theta);
        double yPrime = v * (u * x + v * y + w * z) * (1.0 - Math.cos(theta)) + y * Math.cos(theta) + (w * x - u * z) * Math.sin(theta);
        double zPrime = w * (u * x + v * y + w * z) * (1.0 - Math.cos(theta)) + z * Math.cos(theta) + (-v * x + u * y) * Math.sin(theta);
        return VectorMath.clip(new Vector(xPrime, yPrime, zPrime), 4);
    }

    public static List<BlockFace> split(BlockFace f) {
        ArrayList<BlockFace> faces = new ArrayList<BlockFace>();
        switch (f) {
            case DOWN: {
                faces.add(BlockFace.DOWN);
                break;
            }
            case EAST: {
                faces.add(BlockFace.EAST);
                break;
            }
            case EAST_NORTH_EAST: {
                faces.add(BlockFace.EAST);
                faces.add(BlockFace.EAST);
                faces.add(BlockFace.NORTH);
                break;
            }
            case EAST_SOUTH_EAST: {
                faces.add(BlockFace.EAST);
                faces.add(BlockFace.EAST);
                faces.add(BlockFace.SOUTH);
                break;
            }
            case NORTH: {
                faces.add(BlockFace.NORTH);
                break;
            }
            case NORTH_EAST: {
                faces.add(BlockFace.NORTH);
                faces.add(BlockFace.EAST);
                break;
            }
            case NORTH_NORTH_EAST: {
                faces.add(BlockFace.NORTH);
                faces.add(BlockFace.NORTH);
                faces.add(BlockFace.EAST);
                break;
            }
            case NORTH_NORTH_WEST: {
                faces.add(BlockFace.NORTH);
                faces.add(BlockFace.NORTH);
                faces.add(BlockFace.WEST);
                break;
            }
            case NORTH_WEST: {
                faces.add(BlockFace.NORTH);
                faces.add(BlockFace.WEST);
                break;
            }
            case SELF: {
                faces.add(BlockFace.SELF);
                break;
            }
            case SOUTH: {
                faces.add(BlockFace.SOUTH);
                break;
            }
            case SOUTH_EAST: {
                faces.add(BlockFace.SOUTH);
                faces.add(BlockFace.EAST);
                break;
            }
            case SOUTH_SOUTH_EAST: {
                faces.add(BlockFace.SOUTH);
                faces.add(BlockFace.SOUTH);
                faces.add(BlockFace.EAST);
                break;
            }
            case SOUTH_SOUTH_WEST: {
                faces.add(BlockFace.SOUTH);
                faces.add(BlockFace.SOUTH);
                faces.add(BlockFace.WEST);
                break;
            }
            case SOUTH_WEST: {
                faces.add(BlockFace.SOUTH);
                faces.add(BlockFace.WEST);
                break;
            }
            case UP: {
                faces.add(BlockFace.UP);
                break;
            }
            case WEST: {
                faces.add(BlockFace.WEST);
                break;
            }
            case WEST_NORTH_WEST: {
                faces.add(BlockFace.WEST);
                faces.add(BlockFace.WEST);
                faces.add(BlockFace.NORTH);
                break;
            }
            case WEST_SOUTH_WEST: {
                faces.add(BlockFace.WEST);
                faces.add(BlockFace.WEST);
                faces.add(BlockFace.SOUTH);
                break;
            }
        }
        return faces;
    }

    public static Vector direction(Location from, Location to) {
        return to.clone().subtract(from.clone()).toVector().normalize();
    }

    public static Vector directionNoNormal(Location from, Location to) {
        return to.clone().subtract(from.clone()).toVector();
    }

    public static Vector toVector(float yaw, float pitch) {
        return new Vector(Math.cos(pitch) * Math.cos(yaw), Math.sin(pitch), Math.cos(pitch) * Math.sin(-yaw));
    }

    public static void impulse(Entity e, Vector v) {
        VectorMath.impulse(e, v, 1.0);
    }

    public static void impulse(Entity e, Vector v, double effectiveness) {
        Vector vx = e.getVelocity();
        vx.add(v.clone().multiply(effectiveness));
        e.setVelocity(vx);
    }

    public static Vector reverse(Vector v) {
        if (v.getX() != 0.0) {
            v.setX(-v.getX());
        }
        if (v.getY() != 0.0) {
            v.setY(-v.getY());
        }
        if (v.getZ() != 0.0) {
            v.setZ(-v.getZ());
        }
        return v;
    }

    public static double getSpeed(Vector v) {
        Vector vi = new Vector(0, 0, 0);
        Vector vt = new Vector(0, 0, 0).add(v);
        return vi.distance(vt);
    }

    public static List<Vector> shift(final Vector vector, List<Vector> vectors) {
        return new ArrayList<Vector>(new GListAdapter<Vector, Vector>(){

            @Override
            public Vector onAdapt(Vector from) {
                return from.add(vector);
            }
        }.adapt(vectors));
    }

    public static BlockFace getBlockFace(Vector v) {
        Vector p = VectorMath.triNormalize(v);
        for (BlockFace i : BlockFace.values()) {
            if (p.getX() != (double)i.getModX() || p.getY() != (double)i.getModY() || p.getZ() != (double)i.getModZ()) continue;
            return i;
        }
        for (BlockFace i : BlockFace.values()) {
            if (p.getX() != (double)i.getModX() || p.getZ() != (double)i.getModZ()) continue;
            return i;
        }
        for (BlockFace i : BlockFace.values()) {
            if (p.getY() != (double)i.getModY() || p.getZ() != (double)i.getModZ()) continue;
            return i;
        }
        for (BlockFace i : BlockFace.values()) {
            if (p.getX() != (double)i.getModX() && p.getY() != (double)i.getModY()) continue;
            return i;
        }
        for (BlockFace i : BlockFace.values()) {
            if (p.getX() != (double)i.getModX() && p.getY() != (double)i.getModY() && p.getZ() != (double)i.getModZ()) continue;
            return i;
        }
        return null;
    }

    public static Vector angleLeft(Vector v, float amt) {
        Location l = new Location((World)Bukkit.getWorlds().get(0), 0.0, 0.0, 0.0);
        l.setDirection(v);
        float y = l.getYaw();
        float p = l.getPitch();
        CDou cy = new CDou(360.0);
        CDou cp = new CDou(180.0);
        cy.set(y);
        cp.set(p);
        cy.sub(amt);
        l.setYaw((float)cy.get());
        l.setPitch((float)cp.get());
        return l.getDirection();
    }

    public static Vector angleRight(Vector v, float amt) {
        Location l = new Location((World)Bukkit.getWorlds().get(0), 0.0, 0.0, 0.0);
        l.setDirection(v);
        float y = l.getYaw();
        float p = l.getPitch();
        CDou cy = new CDou(360.0);
        CDou cp = new CDou(180.0);
        cy.set(y);
        cp.set(p);
        cy.add(amt);
        l.setYaw((float)cy.get());
        l.setPitch((float)cp.get());
        return l.getDirection();
    }

    public static Vector angleUp(Vector v, float amt) {
        Location l = new Location((World)Bukkit.getWorlds().get(0), 0.0, 0.0, 0.0);
        l.setDirection(v);
        float y = l.getYaw();
        float p = l.getPitch();
        CDou cy = new CDou(360.0);
        cy.set(y);
        l.setYaw((float)cy.get());
        l.setPitch(Math.max(-90.0f, p - amt));
        return l.getDirection();
    }

    public static Vector angleDown(Vector v, float amt) {
        Location l = new Location((World)Bukkit.getWorlds().get(0), 0.0, 0.0, 0.0);
        l.setDirection(v);
        float y = l.getYaw();
        float p = l.getPitch();
        CDou cy = new CDou(360.0);
        cy.set(y);
        l.setYaw((float)cy.get());
        l.setPitch(Math.min(90.0f, p + amt));
        return l.getDirection();
    }

    public static Vector triNormalize(Vector direction) {
        Vector v = direction.clone();
        v.normalize();
        if (v.getX() > 0.333) {
            v.setX(1);
        } else if (v.getX() < -0.333) {
            v.setX(-1);
        } else {
            v.setX(0);
        }
        if (v.getY() > 0.333) {
            v.setY(1);
        } else if (v.getY() < -0.333) {
            v.setY(-1);
        } else {
            v.setY(0);
        }
        if (v.getZ() > 0.333) {
            v.setZ(1);
        } else if (v.getZ() < -0.333) {
            v.setZ(-1);
        } else {
            v.setZ(0);
        }
        return v;
    }

    static {
        IBootstrap.dasBoot();
    }
}

