/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.util;

import com.volmit.adapt.Adapt;
import com.volmit.adapt.util.Control;
import com.volmit.adapt.util.IController;
import com.volmit.adapt.util.IO;
import com.volmit.adapt.util.Instance;
import com.volmit.adapt.util.J;
import com.volmit.adapt.util.M;
import com.volmit.adapt.util.extensions.java.util.List.XList;
import com.volmit.adapt.util.extensions.java.util.Map.XMap;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public abstract class VolmitPlugin
extends JavaPlugin
implements Listener {
    public static boolean bad;
    private Map<String, IController> controllers;
    private List<IController> cachedControllers;
    private Map<Class<? extends IController>, IController> cachedClassControllers;

    public void l(Object l) {
        Adapt.info("[" + this.getName() + "]: " + l);
    }

    public void w(Object l) {
        Adapt.warn("[" + this.getName() + "]: " + l);
    }

    public void f(Object l) {
        Adapt.error("[" + this.getName() + "]: " + l);
    }

    public void v(Object l) {
        Adapt.verbose("[" + this.getName() + "]: " + l);
    }

    public void onEnable() {
        this.registerInstance();
        this.registerControllers();
        Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)this, this::tickControllers, 0L, 0L);
        J.a(this::outputInfo);
        this.registerListener(this);
        this.start();
    }

    public void unregisterAll() {
        try {
            this.stopControllers();
            this.unregisterListeners();
            this.unregisterInstance();
        }
        catch (Exception e) {
            Adapt.error("Adapt: Failed to unregister all, You have a plugin that is not unloading properly. This is a bug in that plugin. Please report it to the developer. This is on shutdown however, so it's not a big deal.");
            Adapt.error("Adapt: This is not a bug in Adapt. This is a bug in another plugin. Adapt is unloading ALL Command Nodes with Adapt ID's, If another plugin is unloading all or some of these nodes, it will cause this error.");
        }
    }

    private void outputInfo() {
        try {
            IO.delete(this.getDataFolder("info"));
            this.getDataFolder("info").mkdirs();
            this.outputPluginInfo();
        }
        catch (Throwable ignored) {
            Adapt.verbose("Failed to output info");
        }
    }

    private void outputPluginInfo() throws IOException {
        YamlConfiguration fc = new YamlConfiguration();
        fc.set("version", (Object)this.getDescription().getVersion());
        fc.set("name", (Object)this.getDescription().getName());
        fc.save(this.getDataFile("info", "plugin.yml"));
    }

    public void onDisable() {
        this.stop();
        Bukkit.getScheduler().cancelTasks((Plugin)this);
        this.unregisterListener(this);
        this.unregisterAll();
    }

    private void tickControllers() {
        if (bad) {
            return;
        }
        for (IController i : this.getControllers()) {
            this.tickController(i);
        }
    }

    private void tickController(IController i) {
        if (bad) {
            return;
        }
        if (i.getTickInterval() < 0) {
            return;
        }
        ++M.tick;
        if (M.interval(i.getTickInterval())) {
            try {
                i.tick();
            }
            catch (Throwable e) {
                this.w("Failed to tick controller " + i.getName());
                e.printStackTrace();
            }
        }
    }

    public List<IController> getControllers() {
        return this.cachedControllers;
    }

    private void registerControllers() {
        if (bad) {
            return;
        }
        this.controllers = new HashMap<String, IController>();
        this.cachedClassControllers = new HashMap<Class<? extends IController>, IController>();
        for (Field i : ((Object)((Object)this)).getClass().getDeclaredFields()) {
            if (!i.isAnnotationPresent(Control.class)) continue;
            try {
                i.setAccessible(true);
                IController pc = (IController)i.getType().getConstructor(new Class[0]).newInstance(new Object[0]);
                this.registerController(pc);
                i.set((Object)this, pc);
                this.v("Registered " + pc.getName() + " (" + i.getName() + ")");
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                this.w("Failed to register controller (field " + i.getName() + ")");
                e.printStackTrace();
            }
        }
        this.cachedControllers = XMap.v(this.controllers);
    }

    public IController getController(Class<? extends IController> c) {
        return this.cachedClassControllers.get(c);
    }

    private void registerController(IController pc) {
        if (bad) {
            return;
        }
        this.controllers.put(pc.getName(), pc);
        this.cachedClassControllers.put(pc.getClass(), pc);
        this.registerListener(pc);
        try {
            pc.start();
            this.v("Started " + pc.getName());
        }
        catch (Throwable e) {
            this.w("Failed to start controller " + pc.getName());
            e.printStackTrace();
        }
    }

    private void registerInstance() {
        if (bad) {
            return;
        }
        for (Field i : ((Object)((Object)this)).getClass().getDeclaredFields()) {
            if (!i.isAnnotationPresent(Instance.class)) continue;
            try {
                i.setAccessible(true);
                i.set((Object)(Modifier.isStatic(i.getModifiers()) ? null : this), (Object)this);
                this.v("Registered Instance " + i.getName());
            }
            catch (IllegalAccessException | IllegalArgumentException | SecurityException e) {
                this.w("Failed to register instance (field " + i.getName() + ")");
                e.printStackTrace();
            }
        }
    }

    private void unregisterInstance() {
        if (bad) {
            return;
        }
        for (Field i : ((Object)((Object)this)).getClass().getDeclaredFields()) {
            if (!i.isAnnotationPresent(Instance.class)) continue;
            try {
                i.setAccessible(true);
                i.set((Object)(Modifier.isStatic(i.getModifiers()) ? null : this), null);
                this.v("Unregistered Instance " + i.getName());
            }
            catch (IllegalAccessException | IllegalArgumentException | SecurityException e) {
                this.w("Failed to unregister instance (field " + i.getName() + ")");
                e.printStackTrace();
            }
        }
    }

    public String getTag() {
        if (bad) {
            return "";
        }
        return this.getTag("");
    }

    public void registerListener(Listener l) {
        if (bad) {
            return;
        }
        Bukkit.getPluginManager().registerEvents(l, (Plugin)this);
    }

    public void unregisterListener(Listener l) {
        if (bad) {
            return;
        }
        HandlerList.unregisterAll((Listener)l);
    }

    public void unregisterListeners() {
        if (bad) {
            return;
        }
        HandlerList.unregisterAll((Listener)this);
    }

    private void stopControllers() {
        if (bad) {
            return;
        }
        for (IController i : XMap.v(this.controllers)) {
            try {
                this.unregisterListener(i);
                i.stop();
                this.v("Stopped " + i.getName());
            }
            catch (Throwable e) {
                this.w("Failed to stop controller " + i.getName());
                e.printStackTrace();
            }
        }
    }

    public File getDataFile(String ... strings) {
        ArrayList s = new ArrayList();
        XList.add(s, strings);
        File f = new File(this.getDataFolder(), XList.toString(s, File.separator));
        f.getParentFile().mkdirs();
        return f;
    }

    public File getDataFileList(String pre, String[] strings) {
        ArrayList<String> v = new ArrayList<String>();
        XList.add(v, strings);
        v.add(0, pre);
        File f = new File(this.getDataFolder(), XList.toString(v, File.separator));
        f.getParentFile().mkdirs();
        return f;
    }

    public File getDataFolder(String ... strings) {
        if (strings.length == 0) {
            return super.getDataFolder();
        }
        ArrayList s = new ArrayList();
        XList.add(s, strings);
        File f = new File(this.getDataFolder(), XList.toString(s, File.separator));
        f.mkdirs();
        return f;
    }

    public File getDataFolderList(String pre, String[] strings) {
        ArrayList<String> v = new ArrayList<String>();
        XList.add(v, strings);
        v.add(0, pre);
        File f = new File(this.getDataFolder(), XList.toString(v, File.separator));
        f.mkdirs();
        return f;
    }

    public abstract void start();

    public abstract void stop();

    public abstract String getTag(String var1);

    static {
        IBootstrap.dasBoot();
        bad = false;
    }
}

