/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.util.advancements;

import com.volmit.adapt.util.advancements.CrazyAdvancementsAPI;
import com.volmit.adapt.util.advancements.NameKey;
import com.volmit.adapt.util.advancements.event.AdvancementScreenCloseEvent;
import com.volmit.adapt.util.advancements.event.AdvancementTabChangeEvent;
import com.volmit.adapt.util.arcane.curse.Curse;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.MessageToMessageDecoder;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketPlayInAdvancements;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_19_R3.entity.CraftPlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

public class AdvancementPacketReceiver {
    private static final HashMap<String, ChannelHandler> handlers;
    private static Field channelField;

    public AdvancementPacketReceiver() {
        for (Field f : NetworkManager.class.getDeclaredFields()) {
            if (!f.getType().isAssignableFrom(Channel.class)) continue;
            channelField = f;
            channelField.setAccessible(true);
            break;
        }
    }

    public ChannelHandler listen(final Player p, final PacketReceivingHandler handler) {
        Channel ch = this.getNettyChannel(p);
        ChannelPipeline pipe = ch.pipeline();
        MessageToMessageDecoder handle = new MessageToMessageDecoder<Packet<?>>(){

            protected void decode(ChannelHandlerContext chc, Packet<?> packet, List<Object> out) throws Exception {
                if (packet instanceof PacketPlayInAdvancements) {
                    if (!handler.handle(p, (PacketPlayInAdvancements)packet)) {
                        out.add(packet);
                    }
                    return;
                }
                out.add(packet);
            }
        };
        pipe.addAfter("decoder", "endercentral_crazy_advancements_listener_" + handler.hashCode(), (ChannelHandler)handle);
        return handle;
    }

    public Channel getNettyChannel(Player p) {
        NetworkManager manager = (NetworkManager)Curse.on(((CraftPlayer)p).getHandle().b).get("h");
        Channel channel = null;
        try {
            channel = (Channel)channelField.get(manager);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            e.printStackTrace();
        }
        return channel;
    }

    public boolean close(Player p, ChannelHandler handler) {
        try {
            ChannelPipeline pipe = this.getNettyChannel(p).pipeline();
            pipe.remove(handler);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public HashMap<String, ChannelHandler> getHandlers() {
        return handlers;
    }

    public void initPlayer(Player p) {
        handlers.put(p.getName(), this.listen(p, new PacketReceivingHandler(){

            @Override
            public boolean handle(Player p, PacketPlayInAdvancements packet) {
                if (packet.c() == PacketPlayInAdvancements.Status.a) {
                    NameKey name = new NameKey(packet.d());
                    AdvancementTabChangeEvent event = new AdvancementTabChangeEvent(p, name);
                    Bukkit.getPluginManager().callEvent((Event)event);
                    if (event.isCancelled()) {
                        CrazyAdvancementsAPI.clearActiveTab(p);
                        return false;
                    }
                    if (!event.getTabAdvancement().equals(name)) {
                        CrazyAdvancementsAPI.setActiveTab(p, event.getTabAdvancement());
                    } else {
                        CrazyAdvancementsAPI.setActiveTab(p, name, false);
                    }
                } else {
                    AdvancementScreenCloseEvent event = new AdvancementScreenCloseEvent(p);
                    Bukkit.getPluginManager().callEvent((Event)event);
                }
                return true;
            }
        }));
    }

    static {
        IBootstrap.dasBoot();
        handlers = new HashMap();
    }

    static interface PacketReceivingHandler {
        public boolean handle(Player var1, PacketPlayInAdvancements var2);
    }
}

