/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.util.advancements;

import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.volmit.adapt.Adapt;
import com.volmit.adapt.util.advancements.AdvancementPacketReceiver;
import com.volmit.adapt.util.advancements.JSONMessage;
import com.volmit.adapt.util.advancements.NameKey;
import com.volmit.adapt.util.advancements.advancement.Advancement;
import com.volmit.adapt.util.advancements.advancement.AdvancementDisplay;
import com.volmit.adapt.util.advancements.advancement.AdvancementFlag;
import com.volmit.adapt.util.advancements.advancement.AdvancementVisibility;
import com.volmit.adapt.util.advancements.advancement.ToastNotification;
import com.volmit.adapt.util.advancements.advancement.criteria.CriteriaType;
import com.volmit.adapt.util.advancements.advancement.progress.GenericResult;
import com.volmit.adapt.util.advancements.advancement.progress.GrantCriteriaResult;
import com.volmit.adapt.util.advancements.advancement.serialized.SerializedAdvancement;
import com.volmit.adapt.util.advancements.advancement.serialized.SerializedAdvancementDisplay;
import com.volmit.adapt.util.advancements.command.ProgressChangeOperation;
import com.volmit.adapt.util.advancements.item.CustomItem;
import com.volmit.adapt.util.advancements.item.SerializedCustomItem;
import com.volmit.adapt.util.advancements.manager.AdvancementManager;
import com.volmit.adapt.util.advancements.packet.AdvancementsPacket;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.CriterionInstance;
import net.minecraft.advancements.critereon.LootSerializationContext;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketPlayOutSelectAdvancementTab;
import net.minecraft.resources.MinecraftKey;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.craftbukkit.v1_19_R3.entity.CraftPlayer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class CrazyAdvancementsAPI
extends JavaPlugin
implements Listener {
    public static final String API_NAMESPACE = "crazy_advancements";
    public static final Criterion CRITERION;
    private static final Gson gson;
    private static final List<String> SELECTORS;
    private static final HashMap<String, NameKey> activeTabs;
    private static CrazyAdvancementsAPI instance;
    private static AdvancementPacketReceiver packetReciever;
    private final List<CustomItem> customItems = new ArrayList<CustomItem>();
    private final String noPermission = "I'm sorry but you do not have permission to perform this command. Please contact the server administrator if you believe that this is an error.";
    private final String commandIncompatible = "This Command is incompatible with your Arguments!";
    private AdvancementManager fileAdvancementManager;

    public static CrazyAdvancementsAPI getInstance() {
        return instance;
    }

    public static Gson getGson() {
        return gson;
    }

    public static void clearActiveTab(Player player) {
        CrazyAdvancementsAPI.setActiveTab(player, null, true);
    }

    public static void setActiveTab(Player player, String rootAdvancement) {
        CrazyAdvancementsAPI.setActiveTab(player, new NameKey(rootAdvancement));
    }

    public static void setActiveTab(Player player, @Nullable NameKey rootAdvancement) {
        CrazyAdvancementsAPI.setActiveTab(player, rootAdvancement, true);
    }

    static void setActiveTab(Player player, NameKey rootAdvancement, boolean update) {
        if (update) {
            PacketPlayOutSelectAdvancementTab packet = new PacketPlayOutSelectAdvancementTab(rootAdvancement == null ? null : rootAdvancement.getMinecraftKey());
            ((CraftPlayer)player).getHandle().b.a((Packet)packet);
        }
        activeTabs.put(player.getUniqueId().toString(), rootAdvancement);
    }

    public static NameKey getActiveTab(Player player) {
        return activeTabs.get(player.getUniqueId().toString());
    }

    public void reload() {
        this.loadCustomItems();
        this.reloadFileAdvancements();
    }

    private void reloadFileAdvancements() {
        if (this.fileAdvancementManager != null) {
            for (Player player : new ArrayList<Player>(this.fileAdvancementManager.getPlayers())) {
                this.fileAdvancementManager.removePlayer(player);
            }
            this.fileAdvancementManager.resetAccessible();
        }
        this.fileAdvancementManager = new AdvancementManager(new NameKey(API_NAMESPACE, "file"), new Player[0]);
        this.fileAdvancementManager.makeAccessible();
        this.loadFileAdvancements();
        for (Player player : Bukkit.getOnlinePlayers()) {
            packetReciever.initPlayer(player);
            this.fileAdvancementManager.loadProgress(player, new Advancement[0]);
            this.fileAdvancementManager.addPlayer(player);
        }
    }

    public void onLoad() {
        instance = this;
        this.loadCustomItems();
        this.fileAdvancementManager = new AdvancementManager(new NameKey(API_NAMESPACE, "file"), new Player[0]);
        this.fileAdvancementManager.makeAccessible();
        this.loadFileAdvancements();
    }

    private void loadCustomItems() {
        File[] files;
        File location = new File(this.getDataFolder().getAbsolutePath() + File.separator + "custom_items" + File.separator);
        this.customItems.clear();
        location.mkdirs();
        for (File file : files = location.listFiles()) {
            if (!file.isDirectory()) continue;
            String namespace = file.getName();
            this.customItems.addAll(this.loadCustomItemsFromNamespace(namespace, "", file));
        }
        System.out.println("Loaded " + this.customItems.size() + " Custom Items");
    }

    private List<CustomItem> loadCustomItemsFromNamespace(String namespace, String path, File location) {
        File[] files = location.listFiles();
        ArrayList<CustomItem> items = new ArrayList<CustomItem>();
        for (File file : files) {
            if (file.isDirectory()) {
                items.addAll(this.loadCustomItemsFromNamespace(namespace, path + file.getName() + "/", file));
                continue;
            }
            if (!file.isFile() || !file.getName().endsWith(".json")) continue;
            FileReader os = null;
            try {
                os = new FileReader(file);
                JsonElement element = JsonParser.parseReader((Reader)os);
                os.close();
                SerializedCustomItem item = (SerializedCustomItem)gson.fromJson(element, SerializedCustomItem.class);
                String fileName = file.getName();
                String key = fileName.substring(0, fileName.length() - 5);
                items.add(item.deserialize(new NameKey(namespace, path + key)));
            }
            catch (Exception e) {
                if (os != null) {
                    try {
                        os.close();
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                    }
                }
                System.err.println("Unable to load Custom Item from File " + namespace + "/" + file.getName() + ": " + e.getLocalizedMessage());
            }
        }
        return items;
    }

    private void loadFileAdvancements() {
        File[] files;
        File location = new File(this.getDataFolder().getAbsolutePath() + File.separator + "advancements" + File.separator);
        HashMap<NameKey, SerializedAdvancement> advancements = new HashMap<NameKey, SerializedAdvancement>();
        location.mkdirs();
        for (File file : files = location.listFiles()) {
            if (!file.isDirectory()) continue;
            String namespace = file.getName();
            advancements.putAll(this.loadAdvancementsFromNamespace(namespace, "", file));
        }
        ArrayList missingAdvancements = new ArrayList(advancements.keySet());
        HashMap<NameKey, Advancement> createdAdvancements = new HashMap<NameKey, Advancement>();
        while (missingAdvancements.size() > 0) {
            Iterator missingIterator = missingAdvancements.iterator();
            int processedAdvancements = 0;
            while (missingIterator.hasNext()) {
                NameKey name = (NameKey)missingIterator.next();
                SerializedAdvancement serializedAdvancement = (SerializedAdvancement)advancements.get(name);
                NameKey parent = serializedAdvancement.getParent();
                if (parent != null && !createdAdvancements.containsKey(parent)) continue;
                SerializedAdvancementDisplay serializedAdvancementDisplay = serializedAdvancement.getDisplay();
                ItemStack icon = this.getItemStack(serializedAdvancementDisplay.getIcon(), new CommandSender[0]);
                JSONMessage title = new JSONMessage(serializedAdvancementDisplay.getTitle().deserialize());
                JSONMessage description = new JSONMessage(serializedAdvancementDisplay.getDescription().deserialize());
                AdvancementDisplay.AdvancementFrame frame = AdvancementDisplay.AdvancementFrame.parse(serializedAdvancementDisplay.getFrame());
                AdvancementVisibility visibility = AdvancementVisibility.parseVisibility(serializedAdvancementDisplay.getVisibility());
                AdvancementDisplay display = new AdvancementDisplay(icon, title, description, frame, visibility);
                if (serializedAdvancementDisplay.getBackgroundTexture() != null) {
                    display.setBackgroundTexture(serializedAdvancementDisplay.getBackgroundTexture());
                }
                display.setX(serializedAdvancementDisplay.getX());
                display.setY(serializedAdvancementDisplay.getY());
                ArrayList<AdvancementFlag> flags = new ArrayList<AdvancementFlag>();
                if (serializedAdvancement.getFlags() != null) {
                    for (String flagName : serializedAdvancement.getFlags()) {
                        flags.add(AdvancementFlag.valueOf(flagName.toUpperCase(Locale.ROOT)));
                    }
                }
                Advancement advancement = new Advancement(parent == null ? null : (Advancement)createdAdvancements.get(parent), name, display, (AdvancementFlag[])flags.toArray(AdvancementFlag[]::new));
                if (serializedAdvancement.getCriteria() != null) {
                    advancement.setCriteria(serializedAdvancement.getCriteria().deserialize());
                }
                advancement.setReward(serializedAdvancement.getReward());
                this.fileAdvancementManager.addAdvancement(advancement);
                missingIterator.remove();
                createdAdvancements.put(name, advancement);
                ++processedAdvancements;
            }
            if (processedAdvancements != 0) continue;
            for (NameKey name : missingAdvancements) {
                System.err.println("Unable to load Advancement " + name + ": Parent does not exist");
            }
        }
    }

    private HashMap<NameKey, SerializedAdvancement> loadAdvancementsFromNamespace(String namespace, String path, File location) {
        File[] files = location.listFiles();
        HashMap<NameKey, SerializedAdvancement> advancements = new HashMap<NameKey, SerializedAdvancement>();
        for (File file : files) {
            if (file.isDirectory()) {
                advancements.putAll(this.loadAdvancementsFromNamespace(namespace, path + file.getName() + "/", file));
                continue;
            }
            if (!file.isFile() || !file.getName().endsWith(".json")) continue;
            FileReader os = null;
            try {
                os = new FileReader(file);
                JsonElement element = JsonParser.parseReader((Reader)os);
                os.close();
                SerializedAdvancement advancement = (SerializedAdvancement)gson.fromJson(element, SerializedAdvancement.class);
                String fileName = file.getName();
                String key = fileName.substring(0, fileName.length() - 5);
                advancements.put(new NameKey(namespace, path + key), advancement);
            }
            catch (Exception e) {
                if (os != null) {
                    try {
                        os.close();
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                    }
                }
                System.err.println("Unable to load Advancement from File " + namespace + "/" + file.getName() + ": " + e.getLocalizedMessage());
            }
        }
        return advancements;
    }

    public void onEnable() {
        packetReciever = new AdvancementPacketReceiver();
        for (Player player : Bukkit.getOnlinePlayers()) {
            packetReciever.initPlayer(player);
            this.fileAdvancementManager.loadProgress(player, new Advancement[0]);
            this.fileAdvancementManager.addPlayer(player);
        }
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)this);
    }

    public void onDisable() {
        for (Player player : Bukkit.getOnlinePlayers()) {
            AdvancementsPacket packet = new AdvancementsPacket(player, true, null, null);
            packet.send();
        }
    }

    @EventHandler
    public void onJoin(PlayerJoinEvent e) {
        final Player player = e.getPlayer();
        packetReciever.initPlayer(player);
        this.fileAdvancementManager.loadProgress(player, new Advancement[0]);
        Bukkit.getScheduler().runTaskLater((Plugin)this, new Runnable(){

            @Override
            public void run() {
                CrazyAdvancementsAPI.this.fileAdvancementManager.addPlayer(player);
            }
        }, 2L);
    }

    @EventHandler
    public void onQuit(PlayerQuitEvent e) {
        Player p = e.getPlayer();
        packetReciever.close(p, packetReciever.getHandlers().get(p.getName()));
        this.fileAdvancementManager.unloadProgress(p.getUniqueId(), new Advancement[0]);
        this.fileAdvancementManager.unloadVisibilityStatus(p.getUniqueId(), new Advancement[0]);
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (cmd.getName().equalsIgnoreCase("showtoast")) {
            block71: {
                if (sender.hasPermission("crazyadvancements.command.*") || sender.hasPermission("crazyadvancements.command.showtoast")) {
                    if (args.length >= 3) {
                        try {
                            ArrayList<Player> players = new ArrayList<Player>();
                            for (Entity entity : Bukkit.selectEntities((CommandSender)sender, (String)args[0])) {
                                if (!(entity instanceof Player)) continue;
                                players.add((Player)entity);
                            }
                            if (players.size() > 0) {
                                ItemStack stack = this.getItemStack(args[1], sender);
                                if (stack != null) {
                                    int messageStartIndex = 2;
                                    AdvancementDisplay.AdvancementFrame frame = AdvancementDisplay.AdvancementFrame.parseStrict(args[2]);
                                    if (frame == null) {
                                        frame = AdvancementDisplay.AdvancementFrame.TASK;
                                    } else {
                                        messageStartIndex = 3;
                                    }
                                    Object message = args[messageStartIndex];
                                    if (args.length > messageStartIndex + 1) {
                                        for (int i = messageStartIndex + 1; i < args.length; ++i) {
                                            message = (String)message + " " + args[i];
                                        }
                                    }
                                    for (Player player : players) {
                                        ToastNotification toast = new ToastNotification(stack, (String)message, frame);
                                        toast.send(player);
                                    }
                                    Adapt.messagePlayer(sender.getServer().getPlayer(sender.getName()), players.size() == 1 ? "Successfully displayed Toast to " + ((Player)players.get(0)).getName() + "!" : "Successfully displayed Toast to " + players.size() + "Players!");
                                } else {
                                    Adapt.messagePlayer(sender.getServer().getPlayer(sender.getName()), "'" + args[1] + "' isn't a valid Item Material");
                                }
                                break block71;
                            }
                            Adapt.messagePlayer(sender.getServer().getPlayer(sender.getName()), args[0].startsWith("@") ? "No Player found for Selector " + args[0] : "Can't find Player '" + args[0] + "'");
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                            Adapt.messagePlayer(sender.getServer().getPlayer(sender.getName()), "This Command is incompatible with your Arguments!");
                        }
                    } else {
                        Adapt.messagePlayer(sender.getServer().getPlayer(sender.getName()), "Usage: " + cmd.getUsage());
                    }
                } else {
                    Adapt.messagePlayer(sender.getServer().getPlayer(sender.getName()), "I'm sorry but you do not have permission to perform this command. Please contact the server administrator if you believe that this is an error.");
                }
            }
            return true;
        }
        if (cmd.getName().equalsIgnoreCase("grant") || cmd.getName().equalsIgnoreCase("revoke")) {
            block72: {
                boolean grant = cmd.getName().equalsIgnoreCase("grant");
                if (sender.hasPermission("crazyadvancements.command.*") || sender.hasPermission("crazyadvancements.command.grantrevoke")) {
                    if (args.length >= 3) {
                        try {
                            ArrayList<Player> players = new ArrayList<Player>();
                            for (Object entity : Bukkit.selectEntities((CommandSender)sender, (String)args[0])) {
                                if (!(entity instanceof Player)) continue;
                                players.add((Player)entity);
                            }
                            if (players.size() > 0) {
                                AdvancementManager manager = AdvancementManager.getAccessibleManager(new NameKey(args[1]));
                                if (manager != null) {
                                    for (Player player : players) {
                                        if (manager.getPlayers().contains(player)) {
                                            Advancement advancement = manager.getAdvancement(new NameKey(args[2]));
                                            if (advancement != null) {
                                                if (args.length >= 4) {
                                                    String[] convertedCriteria = Arrays.copyOfRange(args, 3, args.length);
                                                    boolean success = false;
                                                    if (grant) {
                                                        if (!advancement.isGranted(player)) {
                                                            result = manager.grantCriteria(player, advancement, convertedCriteria);
                                                            success = result == GrantCriteriaResult.CHANGED;
                                                        }
                                                    } else {
                                                        result = manager.revokeCriteria(player, advancement, convertedCriteria);
                                                        success = result == GenericResult.CHANGED;
                                                    }
                                                    String criteriaString = convertedCriteria[0];
                                                    if (convertedCriteria.length > 1) {
                                                        for (String criteria : Arrays.copyOfRange(convertedCriteria, 1, convertedCriteria.length - 1)) {
                                                            criteriaString = criteriaString + ", " + criteria;
                                                        }
                                                        criteriaString = criteriaString + " and " + convertedCriteria[convertedCriteria.length - 1];
                                                    }
                                                    if (success) {
                                                        if (this.fileAdvancementManager.equals(manager)) {
                                                            this.fileAdvancementManager.saveProgress(player, advancement);
                                                        }
                                                        Adapt.messagePlayer(sender.getServer().getPlayer(sender.getName()), "Successfully " + (grant ? "granted" : "revoked") + " Criteria " + criteriaString + " for '" + advancement.getName() + "' " + (grant ? "to" : "from") + " " + player.getName());
                                                        continue;
                                                    }
                                                    Adapt.messagePlayer(sender.getServer().getPlayer(sender.getName()), "Criteria " + criteriaString + " for '" + advancement.getName() + "' " + (grant ? "is already granted to" : "is already not granted to") + " " + player.getName());
                                                    continue;
                                                }
                                                boolean success = false;
                                                if (grant) {
                                                    if (!advancement.isGranted(player)) {
                                                        GenericResult result = manager.grantAdvancement(player, advancement);
                                                        success = result == GenericResult.CHANGED;
                                                    }
                                                } else {
                                                    GenericResult result = manager.revokeAdvancement(player, advancement);
                                                    boolean bl = success = result == GenericResult.CHANGED;
                                                }
                                                if (success) {
                                                    if (this.fileAdvancementManager.equals(manager)) {
                                                        this.fileAdvancementManager.saveProgress(player, advancement);
                                                    }
                                                    Adapt.messagePlayer(sender.getServer().getPlayer(sender.getName()), "Successfully " + (grant ? "granted" : "revoked") + " Advancement '" + advancement.getName() + "' " + (grant ? "to" : "from") + " " + player.getName());
                                                    continue;
                                                }
                                                Adapt.messagePlayer(sender.getServer().getPlayer(sender.getName()), "Advancement '" + advancement.getName() + "' " + (grant ? "is already granted to" : "is already not granted to") + " " + player.getName());
                                                continue;
                                            }
                                            Adapt.messagePlayer(sender.getServer().getPlayer(sender.getName()), "Advancement with Name '" + args[2] + "' does not exist in '" + args[1] + "'");
                                            continue;
                                        }
                                        Adapt.messagePlayer(sender.getServer().getPlayer(sender.getName()), "'" + args[1] + "' does not contain Player '" + args[0] + "'");
                                    }
                                } else {
                                    Adapt.messagePlayer(sender.getServer().getPlayer(sender.getName()), "Manager with Name '" + args[1] + "' does not exist");
                                }
                                break block72;
                            }
                            Adapt.messagePlayer(sender.getServer().getPlayer(sender.getName()), args[0].startsWith("@") ? "No Player found for Selector " + args[0] : "Can't find Player '" + args[0] + "'");
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                            Adapt.messagePlayer(sender.getServer().getPlayer(sender.getName()), "This Command is incompatible with your Arguments!");
                        }
                    } else {
                        Adapt.messagePlayer(sender.getServer().getPlayer(sender.getName()), "Usage: " + cmd.getUsage());
                    }
                } else {
                    Adapt.messagePlayer(sender.getServer().getPlayer(sender.getName()), "I'm sorry but you do not have permission to perform this command. Please contact the server administrator if you believe that this is an error.");
                }
            }
            return true;
        }
        if (cmd.getName().equalsIgnoreCase("setprogress")) {
            block73: {
                if (sender.hasPermission("crazyadvancements.command.*") || sender.hasPermission("crazyadvancements.command.grantrevoke")) {
                    if (args.length >= 3) {
                        try {
                            ArrayList<Player> players = new ArrayList<Player>();
                            for (Entity entity : Bukkit.selectEntities((CommandSender)sender, (String)args[0])) {
                                if (!(entity instanceof Player)) continue;
                                players.add((Player)entity);
                            }
                            if (players.size() > 0) {
                                AdvancementManager manager = AdvancementManager.getAccessibleManager(new NameKey(args[1]));
                                if (manager != null) {
                                    for (Player player : players) {
                                        if (manager.getPlayers().contains(player)) {
                                            Advancement advancement = manager.getAdvancement(new NameKey(args[2]));
                                            if (advancement != null) {
                                                if (args.length < 4) continue;
                                                int number = Integer.parseInt(args[3]);
                                                ProgressChangeOperation operation = args.length >= 5 ? ProgressChangeOperation.parse(args[4]) : ProgressChangeOperation.SET;
                                                int currentProgress = advancement.getProgress(player).getCriteriaProgress();
                                                int progress = operation.apply(currentProgress, number);
                                                manager.setCriteriaProgress(player, advancement, progress);
                                                if (this.fileAdvancementManager.equals(manager)) {
                                                    this.fileAdvancementManager.saveProgress(player, advancement);
                                                }
                                                Adapt.messagePlayer(sender.getServer().getPlayer(sender.getName()), "Successfully updated Criteria Progress for Advancement '" + advancement.getName() + "' for Player " + player.getName());
                                                continue;
                                            }
                                            Adapt.messagePlayer(sender.getServer().getPlayer(sender.getName()), "Advancement with Name '" + args[2] + "' does not exist in '" + args[1] + "'");
                                            continue;
                                        }
                                        Adapt.messagePlayer(sender.getServer().getPlayer(sender.getName()), "'" + args[1] + "' does not contain Player '" + args[0] + "'");
                                    }
                                } else {
                                    Adapt.messagePlayer(sender.getServer().getPlayer(sender.getName()), "Manager with Name '" + args[1] + "' does not exist");
                                }
                                break block73;
                            }
                            Adapt.messagePlayer(sender.getServer().getPlayer(sender.getName()), args[0].startsWith("@") ? "No Player found for Selector " + args[0] : "Can't find Player '" + args[0] + "'");
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                            Adapt.messagePlayer(sender.getServer().getPlayer(sender.getName()), "This Command is incompatible with your Arguments!");
                        }
                    } else {
                        Adapt.messagePlayer(sender.getServer().getPlayer(sender.getName()), "Usage: " + cmd.getUsage());
                    }
                } else {
                    Adapt.messagePlayer(sender.getServer().getPlayer(sender.getName()), "I'm sorry but you do not have permission to perform this command. Please contact the server administrator if you believe that this is an error.");
                }
            }
            return true;
        }
        if (cmd.getName().equalsIgnoreCase("careload") && (sender.hasPermission("crazyadvancements.command.*") || sender.hasPermission("crazyadvancements.command.reload"))) {
            if (args.length > 0) {
                switch (args[0].toLowerCase()) {
                    case "all": {
                        this.reload();
                        Adapt.messagePlayer(sender.getServer().getPlayer(sender.getName()), "Crazy Advancements API was reloaded");
                        break;
                    }
                    case "advancements": {
                        this.reloadFileAdvancements();
                        Adapt.messagePlayer(sender.getServer().getPlayer(sender.getName()), "JSON Advancements have been reloaded");
                        break;
                    }
                    case "items": {
                        this.loadCustomItems();
                        Adapt.messagePlayer(sender.getServer().getPlayer(sender.getName()), "Custom Items have been reloaded");
                        break;
                    }
                    default: {
                        Adapt.messagePlayer(sender.getServer().getPlayer(sender.getName()), "Invalid Reload Category '" + args[0] + "'. Valid categories are all, advancements, items");
                        break;
                    }
                }
            } else {
                this.reload();
                Adapt.messagePlayer(sender.getServer().getPlayer(sender.getName()), "Crazy Advancements API was reloaded");
            }
        }
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command cmd, String alias, String[] args) {
        Object manager;
        ArrayList<String> tab = new ArrayList<String>();
        if (cmd.getName().equalsIgnoreCase("showtoast") && (sender.hasPermission("crazyadvancements.command.*") || sender.hasPermission("crazyadvancements.command.showtoast"))) {
            if (args.length == 1) {
                for (String selector : SELECTORS) {
                    if (!selector.toLowerCase().startsWith(args[0].toLowerCase())) continue;
                    tab.add(selector);
                }
                for (Player player : Bukkit.getOnlinePlayers()) {
                    if (!player.getName().toLowerCase().startsWith(args[0].toLowerCase())) continue;
                    tab.add(player.getName());
                }
            } else if (args.length == 2) {
                for (Material mat : Material.values()) {
                    if (!mat.isItem() || !mat.name().toLowerCase().startsWith(args[1].toLowerCase())) continue;
                    tab.add(mat.name().toLowerCase());
                }
                for (CustomItem customItem : this.customItems) {
                    if (!customItem.getName().toString().startsWith(args[1].toLowerCase())) continue;
                    tab.add(customItem.getName().toString());
                }
            } else if (args.length == 3) {
                for (AdvancementDisplay.AdvancementFrame frame : AdvancementDisplay.AdvancementFrame.values()) {
                    if (!frame.name().toLowerCase().startsWith(args[2].toLowerCase())) continue;
                    tab.add(frame.name().toLowerCase());
                }
            }
        }
        if ((cmd.getName().equalsIgnoreCase("grant") || cmd.getName().equalsIgnoreCase("revoke")) && (sender.hasPermission("crazyadvancements.command.*") || sender.hasPermission("crazyadvancements.command.grantrevoke"))) {
            Advancement advancement;
            if (args.length == 1) {
                for (String selector : SELECTORS) {
                    if (!selector.toLowerCase().startsWith(args[0].toLowerCase())) continue;
                    tab.add(selector);
                }
                for (Player player : Bukkit.getOnlinePlayers()) {
                    if (!player.getName().toLowerCase().startsWith(args[0].toLowerCase())) continue;
                    tab.add(player.getName());
                }
            } else if (args.length == 2) {
                for (AdvancementManager manager2 : AdvancementManager.getAccessibleManagers()) {
                    if (!manager2.getName().toString().startsWith(args[1].toLowerCase())) continue;
                    tab.add(manager2.getName().toString());
                }
            } else if (args.length == 3) {
                manager = AdvancementManager.getAccessibleManager(new NameKey(args[1]));
                if (manager != null) {
                    for (Advancement advancement2 : ((AdvancementManager)manager).getAdvancements()) {
                        if (!advancement2.getName().toString().startsWith(args[2].toLowerCase()) && !advancement2.getName().getKey().startsWith(args[2].toLowerCase())) continue;
                        tab.add(advancement2.getName().toString());
                    }
                }
            } else if (args.length >= 4 && (manager = AdvancementManager.getAccessibleManager(new NameKey(args[1]))) != null && (advancement = ((AdvancementManager)manager).getAdvancement(new NameKey(args[2]))) != null) {
                String[] advancement2 = advancement.getCriteria().getActionNames();
                int n = advancement2.length;
                for (int i = 0; i < n; ++i) {
                    String criterion = advancement2[i];
                    if (!criterion.toLowerCase().startsWith(args[args.length - 1].toLowerCase())) continue;
                    tab.add(criterion);
                }
            }
        }
        if (cmd.getName().equalsIgnoreCase("setprogress") && (sender.hasPermission("crazyadvancements.command.*") || sender.hasPermission("crazyadvancements.command.grantrevoke"))) {
            Advancement advancement;
            if (args.length == 1) {
                for (String selector : SELECTORS) {
                    if (!selector.toLowerCase().startsWith(args[0].toLowerCase())) continue;
                    tab.add(selector);
                }
                for (Player player : Bukkit.getOnlinePlayers()) {
                    if (!player.getName().toLowerCase().startsWith(args[0].toLowerCase())) continue;
                    tab.add(player.getName());
                }
            } else if (args.length == 2) {
                for (AdvancementManager manager3 : AdvancementManager.getAccessibleManagers()) {
                    if (!manager3.getName().toString().startsWith(args[1].toLowerCase())) continue;
                    tab.add(manager3.getName().toString());
                }
            } else if (args.length == 3) {
                manager = AdvancementManager.getAccessibleManager(new NameKey(args[1]));
                if (manager != null) {
                    for (Advancement advancement3 : ((AdvancementManager)manager).getAdvancements()) {
                        if (!advancement3.getName().toString().startsWith(args[2].toLowerCase()) && !advancement3.getName().getKey().startsWith(args[2].toLowerCase()) || advancement3.getCriteria().getType() != CriteriaType.NUMBER) continue;
                        tab.add(advancement3.getName().toString());
                    }
                }
            } else if (args.length == 4) {
                Advancement advancement4;
                manager = AdvancementManager.getAccessibleManager(new NameKey(args[1]));
                if (manager != null && (advancement4 = ((AdvancementManager)manager).getAdvancement(new NameKey(args[2]))) != null && advancement4.getCriteria().getType() == CriteriaType.NUMBER) {
                    tab.add(args[3]);
                    tab.add("" + advancement4.getCriteria().getRequiredNumber());
                }
            } else if (args.length == 5 && (manager = AdvancementManager.getAccessibleManager(new NameKey(args[1]))) != null && (advancement = ((AdvancementManager)manager).getAdvancement(new NameKey(args[2]))) != null && advancement.getCriteria().getType() == CriteriaType.NUMBER) {
                for (ProgressChangeOperation operation : ProgressChangeOperation.values()) {
                    if (!operation.name().toLowerCase().startsWith(args[4].toLowerCase())) continue;
                    tab.add(operation.name().toLowerCase());
                }
            }
        }
        if (cmd.getName().equalsIgnoreCase("careload") && (sender.hasPermission("crazyadvancements.command.*") || sender.hasPermission("crazyadvancements.command.reload"))) {
            if ("all".startsWith(args[0])) {
                tab.add("all");
            }
            if ("advancements".startsWith(args[0])) {
                tab.add("advancements");
            }
            if ("items".startsWith(args[0])) {
                tab.add("items");
            }
        }
        return tab;
    }

    private Material getMaterial(String input) {
        for (Material mat : Material.values()) {
            if (!mat.name().equalsIgnoreCase(input)) continue;
            return mat;
        }
        return Material.matchMaterial((String)input);
    }

    private CustomItem getCustomItem(String input) {
        NameKey inputName = new NameKey(input);
        for (CustomItem item : this.customItems) {
            if (!item.getName().isSimilar(inputName)) continue;
            return item;
        }
        return null;
    }

    private ItemStack getItemStack(String input, CommandSender ... commandSender) {
        ItemMeta meta;
        ItemStack stack;
        int colonIndex = input.indexOf(58);
        String materialName = colonIndex == -1 ? input : input.substring(0, colonIndex);
        String data = colonIndex == -1 ? "" : input.substring(colonIndex + 1);
        Material material = this.getMaterial(materialName);
        if (material == null || !material.isItem()) {
            CustomItem customItem = this.getCustomItem(input);
            if (customItem == null) {
                return null;
            }
            material = customItem.getType();
            stack = new ItemStack(material);
            meta = stack.getItemMeta();
            meta.setCustomModelData(Integer.valueOf(customItem.getCustomModelData()));
            stack.setItemMeta(meta);
        } else {
            stack = new ItemStack(material);
        }
        switch (material) {
            case PLAYER_HEAD: {
                if (data.isEmpty()) break;
                if (commandSender.length > 0) {
                    for (String selector : SELECTORS) {
                        if (!data.startsWith(selector)) continue;
                        ArrayList<Player> players = new ArrayList<Player>();
                        for (Entity entity : Bukkit.selectEntities((CommandSender)commandSender[0], (String)data)) {
                            if (!(entity instanceof Player)) continue;
                            players.add((Player)entity);
                        }
                        if (players.size() > 0) {
                            Player player = (Player)players.get(0);
                            SkullMeta meta2 = (SkullMeta)stack.getItemMeta();
                            meta2.setOwningPlayer((OfflinePlayer)player);
                            stack.setItemMeta((ItemMeta)meta2);
                        }
                        return stack;
                    }
                }
                OfflinePlayer player = Bukkit.getOfflinePlayer((String)data);
                meta = (SkullMeta)stack.getItemMeta();
                meta.setOwningPlayer(player);
                stack.setItemMeta(meta);
            }
        }
        if (!data.isEmpty() && material.getMaxDurability() > 0) {
            try {
                short damage = Short.parseShort(data);
                meta = (Damageable)stack.getItemMeta();
                meta.setDamage((int)damage);
                stack.setItemMeta(meta);
            }
            catch (ClassCastException | NumberFormatException ignored) {
                Adapt.verbose("Invalid damage value for item " + input);
            }
        }
        return stack;
    }

    static {
        IBootstrap.dasBoot();
        CRITERION = new Criterion(new CriterionInstance(){

            public JsonObject a(LootSerializationContext arg0) {
                return null;
            }

            public MinecraftKey a() {
                return new MinecraftKey("", "");
            }
        });
        SELECTORS = Arrays.asList("@a", "@p", "@s", "@r");
        activeTabs = new HashMap();
        gson = new GsonBuilder().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).create();
    }
}

