/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.util.advancements.advancement;

import com.volmit.adapt.util.advancements.advancement.Advancement;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import java.util.Arrays;
import org.bukkit.entity.Player;

public abstract class AdvancementVisibility {
    public static final AdvancementVisibility ALWAYS;
    public static final AdvancementVisibility PARENT_GRANTED;
    public static final AdvancementVisibility VANILLA;
    public static final AdvancementVisibility HIDDEN;
    private final String name;

    public AdvancementVisibility() {
        this.name = "CUSTOM";
    }

    private AdvancementVisibility(String name) {
        this.name = name;
    }

    public static AdvancementVisibility parseVisibility(String name) {
        for (AdvancementVisibility visibility : Arrays.asList(ALWAYS, PARENT_GRANTED, VANILLA, HIDDEN)) {
            if (!visibility.getName().equalsIgnoreCase(name)) continue;
            return visibility;
        }
        return VANILLA;
    }

    public abstract boolean isVisible(Player var1, Advancement var2);

    public boolean isAlwaysVisibleWhenAnyChildIsGranted() {
        return true;
    }

    public String getName() {
        return this.name;
    }

    static {
        IBootstrap.dasBoot();
        ALWAYS = new AdvancementVisibility("ALWAYS"){

            @Override
            public boolean isVisible(Player player, Advancement advancement) {
                return true;
            }
        };
        PARENT_GRANTED = new AdvancementVisibility("PARENT_GRANTED"){

            @Override
            public boolean isVisible(Player player, Advancement advancement) {
                if (advancement.isGranted(player)) {
                    return true;
                }
                Advancement parent = advancement.getParent();
                return parent == null || parent.isGranted(player);
            }
        };
        VANILLA = new AdvancementVisibility("VANILLA"){

            @Override
            public boolean isVisible(Player player, Advancement advancement) {
                if (advancement.isGranted(player)) {
                    return true;
                }
                Advancement parent = advancement.getParent();
                if (parent != null && !parent.isGranted(player)) {
                    Advancement grandParent = parent.getParent();
                    return grandParent == null || grandParent.getParent() == null || grandParent.isGranted(player);
                }
                return true;
            }
        };
        HIDDEN = new AdvancementVisibility("HIDDEN"){

            @Override
            public boolean isVisible(Player player, Advancement advancement) {
                return advancement.isGranted(player);
            }
        };
    }
}

