/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.util.advancements.advancement;

import com.volmit.adapt.util.advancements.JSONMessage;
import com.volmit.adapt.util.advancements.NameKey;
import com.volmit.adapt.util.advancements.advancement.AdvancementDisplay;
import com.volmit.adapt.util.advancements.advancement.criteria.Criteria;
import com.volmit.adapt.util.advancements.advancement.progress.AdvancementProgress;
import com.volmit.adapt.util.advancements.packet.ToastPacket;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class ToastNotification {
    public static final NameKey NOTIFICATION_NAME;
    public static final Criteria NOTIFICATION_CRITERIA;
    public static final AdvancementProgress NOTIFICATION_PROGRESS;
    private final ItemStack icon;
    private final JSONMessage message;
    private final AdvancementDisplay.AdvancementFrame frame;

    public ToastNotification(ItemStack icon, JSONMessage message, AdvancementDisplay.AdvancementFrame frame) {
        this.icon = icon;
        this.message = message;
        this.frame = frame;
    }

    public ToastNotification(ItemStack icon, String message, AdvancementDisplay.AdvancementFrame frame) {
        this.icon = icon;
        this.message = new JSONMessage((BaseComponent)new TextComponent(message));
        this.frame = frame;
    }

    public ToastNotification(Material icon, JSONMessage message, AdvancementDisplay.AdvancementFrame frame) {
        this.icon = new ItemStack(icon);
        this.message = message;
        this.frame = frame;
    }

    public ToastNotification(Material icon, String message, AdvancementDisplay.AdvancementFrame frame) {
        this.icon = new ItemStack(icon);
        this.message = new JSONMessage((BaseComponent)new TextComponent(message));
        this.frame = frame;
    }

    public ItemStack getIcon() {
        return this.icon;
    }

    public JSONMessage getMessage() {
        return this.message;
    }

    public AdvancementDisplay.AdvancementFrame getFrame() {
        return this.frame;
    }

    public void send(Player player) {
        ToastPacket addPacket = new ToastPacket(player, true, this);
        ToastPacket removePacket = new ToastPacket(player, false, this);
        addPacket.send();
        removePacket.send();
    }

    static {
        IBootstrap.dasBoot();
        NOTIFICATION_NAME = new NameKey("crazy_advancements", "notification");
        NOTIFICATION_CRITERIA = new Criteria(1);
        NOTIFICATION_PROGRESS = new AdvancementProgress(NOTIFICATION_CRITERIA.getCriteria(), NOTIFICATION_CRITERIA.getRequirements());
        NOTIFICATION_PROGRESS.setCriteriaProgress(1);
    }
}

