/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.util.advancements.advancement.progress;

import com.google.common.collect.Iterables;
import com.volmit.adapt.util.advancements.advancement.progress.GenericResult;
import com.volmit.adapt.util.advancements.advancement.progress.GrantCriteriaResult;
import com.volmit.adapt.util.advancements.advancement.progress.SetCriteriaResult;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import java.util.Iterator;
import java.util.Map;
import java.util.stream.StreamSupport;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.CriterionProgress;

public class AdvancementProgress {
    private final net.minecraft.advancements.AdvancementProgress nmsProgress = new net.minecraft.advancements.AdvancementProgress();
    private long lastUpdate = -1L;

    public AdvancementProgress(Map<String, Criterion> criteria, String[][] requirements) {
        this.nmsProgress.a(criteria, requirements);
    }

    private static void setGranted(CriterionProgress criterionProgress) {
        criterionProgress.b();
    }

    private static void setUngranted(CriterionProgress criterionProgress) {
        criterionProgress.c();
    }

    private static boolean isGranted(CriterionProgress criterionProgress) {
        return criterionProgress.a();
    }

    public GenericResult grant() {
        GenericResult result = GenericResult.UNCHANGED;
        Iterable<String> missing = this.getRemainingCriteria();
        for (String next : missing) {
            CriterionProgress criterionProgress = this.getCriterionProgress(next);
            AdvancementProgress.setGranted(criterionProgress);
            result = GenericResult.CHANGED;
            this.setLastUpdate();
        }
        return result;
    }

    public GenericResult revoke() {
        GenericResult result = GenericResult.UNCHANGED;
        Iterable<String> awarded = this.getAwardedCriteria();
        Iterator<String> awardedIterator = awarded.iterator();
        for (long current = StreamSupport.stream(awarded.spliterator(), false).count(); current > 0L && awardedIterator.hasNext(); --current) {
            String next = awardedIterator.next();
            CriterionProgress criterionProgress = this.getCriterionProgress(next);
            AdvancementProgress.setUngranted(criterionProgress);
            result = GenericResult.CHANGED;
            this.setLastUpdate();
        }
        return result;
    }

    public GrantCriteriaResult grantCriteria(String ... criteria) {
        GrantCriteriaResult result = GrantCriteriaResult.UNCHANGED;
        boolean doneBefore = this.isDone();
        if (!doneBefore) {
            for (String criterion : criteria) {
                CriterionProgress criterionProgress = this.getCriterionProgress(criterion);
                if (criterionProgress == null || AdvancementProgress.isGranted(criterionProgress)) continue;
                AdvancementProgress.setGranted(criterionProgress);
                result = GrantCriteriaResult.CHANGED;
                this.setLastUpdate();
            }
            if (this.isDone()) {
                return GrantCriteriaResult.COMPLETED;
            }
        }
        return result;
    }

    public GenericResult revokeCriteria(String ... criteria) {
        GenericResult result = GenericResult.UNCHANGED;
        for (String criterion : criteria) {
            CriterionProgress criterionProgress = this.getCriterionProgress(criterion);
            if (criterionProgress == null || !AdvancementProgress.isGranted(criterionProgress)) continue;
            AdvancementProgress.setUngranted(criterionProgress);
            result = GenericResult.CHANGED;
            this.setLastUpdate();
        }
        return result;
    }

    public SetCriteriaResult setCriteriaProgress(int number) {
        CriterionProgress criterionProgress;
        String next;
        long current;
        SetCriteriaResult result = SetCriteriaResult.UNCHANGED;
        boolean doneBefore = this.isDone();
        Iterable<String> awarded = this.getAwardedCriteria();
        Iterator<String> awardedIterator = awarded.iterator();
        Iterable<String> missing = this.getRemainingCriteria();
        Iterator<String> missingIterator = missing.iterator();
        for (current = StreamSupport.stream(awarded.spliterator(), false).count(); current < (long)number && missingIterator.hasNext(); ++current) {
            next = missingIterator.next();
            criterionProgress = this.getCriterionProgress(next);
            AdvancementProgress.setGranted(criterionProgress);
            result = SetCriteriaResult.CHANGED;
            this.setLastUpdate();
        }
        while (current > (long)number && awardedIterator.hasNext()) {
            next = awardedIterator.next();
            criterionProgress = this.getCriterionProgress(next);
            AdvancementProgress.setUngranted(criterionProgress);
            --current;
            result = SetCriteriaResult.CHANGED;
            this.setLastUpdate();
        }
        if (!doneBefore && this.isDone()) {
            result = SetCriteriaResult.COMPLETED;
        }
        return result;
    }

    public Iterable<String> getRemainingCriteria() {
        return this.getNmsProgress().e();
    }

    public Iterable<String> getAwardedCriteria() {
        return this.getNmsProgress().f();
    }

    public int getCriteriaProgress() {
        return Iterables.size(this.getAwardedCriteria());
    }

    public CriterionProgress getCriterionProgress(String name) {
        return this.getNmsProgress().c(name);
    }

    public boolean isDone() {
        return this.getNmsProgress().a();
    }

    public net.minecraft.advancements.AdvancementProgress getNmsProgress() {
        return this.nmsProgress;
    }

    public long getLastUpdate() {
        return this.lastUpdate;
    }

    public void setLastUpdate() {
        this.lastUpdate = System.currentTimeMillis();
    }

    static {
        IBootstrap.dasBoot();
    }
}

