/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.util.advancements.packet;

import com.volmit.adapt.util.advancements.NameKey;
import com.volmit.adapt.util.advancements.advancement.Advancement;
import com.volmit.adapt.util.advancements.packet.PacketConverter;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketPlayOutAdvancements;
import net.minecraft.resources.MinecraftKey;
import org.bukkit.craftbukkit.v1_19_R3.entity.CraftPlayer;
import org.bukkit.entity.Player;

public class AdvancementsPacket {
    private final Player player;
    private final boolean reset;
    private final List<Advancement> advancements;
    private final List<NameKey> removedAdvancements;

    public AdvancementsPacket(Player player, boolean reset, List<Advancement> advancements, List<NameKey> removedAdvancements) {
        this.player = player;
        this.reset = reset;
        this.advancements = advancements == null ? new ArrayList<Advancement>() : new ArrayList<Advancement>(advancements);
        this.removedAdvancements = removedAdvancements == null ? new ArrayList<NameKey>() : new ArrayList<NameKey>(removedAdvancements);
    }

    public Player getPlayer() {
        return this.player;
    }

    public boolean isReset() {
        return this.reset;
    }

    public List<Advancement> getAdvancements() {
        return new ArrayList<Advancement>(this.advancements);
    }

    public List<NameKey> getRemovedAdvancements() {
        return new ArrayList<NameKey>(this.removedAdvancements);
    }

    public PacketPlayOutAdvancements build() {
        ArrayList<net.minecraft.advancements.Advancement> advancements = new ArrayList<net.minecraft.advancements.Advancement>();
        HashSet<MinecraftKey> removedAdvancements = new HashSet<MinecraftKey>();
        HashMap<MinecraftKey, AdvancementProgress> progress = new HashMap<MinecraftKey, AdvancementProgress>();
        for (Advancement advancement : this.advancements) {
            net.minecraft.advancements.Advancement nmsAdvancement = this.convertAdvancement(advancement);
            advancements.add(nmsAdvancement);
            progress.put(advancement.getName().getMinecraftKey(), advancement.getProgress(this.getPlayer()).getNmsProgress());
        }
        for (NameKey removed : this.removedAdvancements) {
            removedAdvancements.add(removed.getMinecraftKey());
        }
        PacketPlayOutAdvancements packet = new PacketPlayOutAdvancements(this.isReset(), advancements, removedAdvancements, progress);
        return packet;
    }

    protected net.minecraft.advancements.Advancement convertAdvancement(Advancement advancement) {
        return PacketConverter.toNmsAdvancement(advancement);
    }

    public void send() {
        PacketPlayOutAdvancements packet = this.build();
        ((CraftPlayer)this.getPlayer()).getHandle().b.a((Packet)packet);
    }

    static {
        IBootstrap.dasBoot();
    }
}

