/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.util.arcane.amulet.range;

import com.volmit.adapt.util.arcane.amulet.range.NumberRange;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import java.util.Iterator;
import java.util.NoSuchElementException;

public final class DoubleRange
extends NumberRange<Double, DoubleRange> {
    public DoubleRange(Double left, Double right) {
        this(left, right, 1.0);
    }

    public DoubleRange unaryMinus() {
        Double left = (Double)this.getLeftEndpoint();
        Double right = (Double)this.getRightEndpoint();
        if (this.isReversed()) {
            return new DoubleRange(left, right, (Double)this.getStep(), true, true, false);
        }
        return new DoubleRange(right, left, (Double)this.getStep(), true, true, true);
    }

    public DoubleRange(Double left, Double right, double step) {
        this(left, right, step, true, true, false);
    }

    public DoubleRange(Double left, Double right, double step, boolean leftClosed, boolean rightClosed, boolean reverse) {
        super(left, right, step, leftClosed, rightClosed, reverse);
        if (step <= 0.0) {
            throw new IllegalArgumentException("The step must be greater than 0: " + step);
        }
    }

    @Override
    public Iterator<Double> iterateFromLeft() {
        return new ForwardIterator();
    }

    @Override
    public Iterator<Double> iterateFromRight() {
        return new ReverseIterator();
    }

    @Override
    public Double getFromLeft(int iStepIndex) {
        if (iStepIndex < 0) {
            throw new IllegalArgumentException("Step index must be >= 0: " + iStepIndex);
        }
        if (!this.isLeftClosed()) {
            ++iStepIndex;
        }
        double value = (Double)this.getLeftEndpoint() + (Double)this.getStep() * (double)iStepIndex;
        if (this.isRightClosed() ? value <= (Double)this.getRightEndpoint() : value < (Double)this.getRightEndpoint()) {
            return value;
        }
        return null;
    }

    @Override
    public Double getFromRight(int iStepIndex) {
        if (iStepIndex < 0) {
            throw new IllegalArgumentException("Step index must be >= 0: " + iStepIndex);
        }
        if (!this.isRightClosed()) {
            ++iStepIndex;
        }
        double value = (Double)this.getRightEndpoint() - (Double)this.getStep() * (double)iStepIndex;
        if (this.isLeftClosed() ? value >= (Double)this.getLeftEndpoint() : value > (Double)this.getLeftEndpoint()) {
            return value;
        }
        return null;
    }

    static {
        IBootstrap.dasBoot();
    }

    public class ForwardIterator
    implements Iterator<Double> {
        private double _csr;

        ForwardIterator() {
            this._csr = (Double)DoubleRange.this.getLeftEndpoint();
            if (!DoubleRange.this.isLeftClosed() && this.hasNext()) {
                this.next();
            }
        }

        @Override
        public boolean hasNext() {
            return this._csr < (Double)DoubleRange.this.getRightEndpoint() || DoubleRange.this.isRightClosed() && this._csr == (Double)DoubleRange.this.getRightEndpoint();
        }

        @Override
        public Double next() {
            if (this._csr > (Double)DoubleRange.this.getRightEndpoint() || !DoubleRange.this.isRightClosed() && this._csr == (Double)DoubleRange.this.getRightEndpoint()) {
                throw new NoSuchElementException();
            }
            double ret = this._csr;
            this._csr += ((Double)DoubleRange.this.getStep()).doubleValue();
            return ret;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private class ReverseIterator
    implements Iterator<Double> {
        private double _csr;

        ReverseIterator() {
            this._csr = (Double)DoubleRange.this.getRightEndpoint();
            if (!DoubleRange.this.isRightClosed() && this.hasNext()) {
                this.next();
            }
        }

        @Override
        public boolean hasNext() {
            return this._csr > (Double)DoubleRange.this.getLeftEndpoint() || DoubleRange.this.isLeftClosed() && this._csr == (Double)DoubleRange.this.getLeftEndpoint();
        }

        @Override
        public Double next() {
            if (this._csr < (Double)DoubleRange.this.getLeftEndpoint() || !DoubleRange.this.isLeftClosed() && this._csr == (Double)DoubleRange.this.getLeftEndpoint()) {
                throw new NoSuchElementException();
            }
            double ret = this._csr;
            this._csr -= ((Double)DoubleRange.this.getStep()).doubleValue();
            return ret;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

