/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.util.arcane.amulet.range;

import com.volmit.adapt.util.arcane.amulet.range.AbstractIntIterator;
import com.volmit.adapt.util.arcane.amulet.range.NumberRange;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import java.util.Iterator;
import java.util.NoSuchElementException;

public final class IntegerRange
extends NumberRange<Integer, IntegerRange> {
    public IntegerRange(Integer left, Integer right) {
        this(left, right, 1);
    }

    public IntegerRange(Integer left, Integer right, int step) {
        this(left, right, step, true, true, false);
    }

    public IntegerRange(Integer left, Integer right, int step, boolean leftClosed, boolean rightClosed, boolean reverse) {
        super(left, right, step, leftClosed, rightClosed, reverse);
        if (step <= 0) {
            throw new IllegalArgumentException("The step must be greater than 0: " + step);
        }
    }

    public IntegerRange unaryMinus() {
        int left = (Integer)this.getLeftEndpoint();
        int right = (Integer)this.getRightEndpoint();
        if (this.isReversed()) {
            return new IntegerRange(left, right, (Integer)this.getStep(), true, true, false);
        }
        return new IntegerRange(right, left, (Integer)this.getStep(), true, true, true);
    }

    @Override
    public Iterator<Integer> iterateFromLeft() {
        return new ForwardIterator();
    }

    @Override
    public Iterator<Integer> iterateFromRight() {
        return new ReverseIterator();
    }

    @Override
    public Integer getFromLeft(int iStepIndex) {
        if (iStepIndex < 0) {
            throw new IllegalArgumentException("Step index must be >= 0: " + iStepIndex);
        }
        if (!this.isLeftClosed()) {
            ++iStepIndex;
        }
        int value = (Integer)this.getLeftEndpoint() + (Integer)this.getStep() * iStepIndex;
        if (this.isRightClosed() ? value <= (Integer)this.getRightEndpoint() : value < (Integer)this.getRightEndpoint()) {
            return value;
        }
        return null;
    }

    @Override
    public Integer getFromRight(int iStepIndex) {
        if (iStepIndex < 0) {
            throw new IllegalArgumentException("Step index must be >= 0: " + iStepIndex);
        }
        if (!this.isRightClosed()) {
            ++iStepIndex;
        }
        int value = (Integer)this.getRightEndpoint() - (Integer)this.getStep() * iStepIndex;
        if (this.isLeftClosed() ? value >= (Integer)this.getLeftEndpoint() : value > (Integer)this.getLeftEndpoint()) {
            return value;
        }
        return null;
    }

    static {
        IBootstrap.dasBoot();
    }

    public class ForwardIterator
    extends AbstractIntIterator {
        private int _csr;

        public ForwardIterator() {
            this._csr = (Integer)IntegerRange.this.getLeftEndpoint();
            if (!IntegerRange.this.isLeftClosed() && this.hasNext()) {
                this.next();
            }
        }

        @Override
        public boolean hasNext() {
            return this._csr < (Integer)IntegerRange.this.getRightEndpoint() || IntegerRange.this.isRightClosed() && this._csr == (Integer)IntegerRange.this.getRightEndpoint();
        }

        @Override
        public Integer next() {
            return this.nextInt();
        }

        @Override
        public int nextInt() {
            if (this._csr > (Integer)IntegerRange.this.getRightEndpoint() || !IntegerRange.this.isRightClosed() && this._csr == (Integer)IntegerRange.this.getRightEndpoint()) {
                throw new NoSuchElementException();
            }
            int ret = this._csr;
            this._csr += ((Integer)IntegerRange.this.getStep()).intValue();
            return ret;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private class ReverseIterator
    extends AbstractIntIterator {
        private int _csr;

        public ReverseIterator() {
            this._csr = (Integer)IntegerRange.this.getRightEndpoint();
            if (!IntegerRange.this.isRightClosed() && this.hasNext()) {
                this.next();
            }
        }

        @Override
        public boolean hasNext() {
            return this._csr > (Integer)IntegerRange.this.getLeftEndpoint() || IntegerRange.this.isLeftClosed() && this._csr == (Integer)IntegerRange.this.getLeftEndpoint();
        }

        @Override
        public Integer next() {
            return this.nextInt();
        }

        @Override
        public int nextInt() {
            if (this._csr < (Integer)IntegerRange.this.getLeftEndpoint() || !IntegerRange.this.isLeftClosed() && this._csr == (Integer)IntegerRange.this.getLeftEndpoint()) {
                throw new NoSuchElementException();
            }
            int ret = this._csr;
            this._csr -= ((Integer)IntegerRange.this.getStep()).intValue();
            return ret;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

