/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.util.arcane.curse.model;

import com.volmit.adapt.util.arcane.curse.Curse;
import com.volmit.adapt.util.arcane.curse.model.CursedConstructor;
import com.volmit.adapt.util.arcane.curse.model.CursedContext;
import com.volmit.adapt.util.arcane.curse.model.CursedField;
import com.volmit.adapt.util.arcane.curse.model.CursedMethod;
import com.volmit.adapt.util.arcane.curse.model.FuzzyMethod;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import sun.misc.Unsafe;

public class CursedComponent {
    private final CursedContext context;

    public CursedComponent type(Class<?> clazz) {
        this.context.type(clazz);
        return this;
    }

    public CursedComponent instance(Object instance) {
        this.context.instance(instance);
        return this;
    }

    public <T> T instance() {
        return (T)this.context.instance();
    }

    public Class<?> type() {
        return this.context.type();
    }

    public CursedComponent make() {
        try {
            return Curse.on(this.type()).instance(this.unsafe().allocateInstance(this.type()));
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
    }

    private Unsafe unsafe() {
        try {
            Field unsafeField = Unsafe.class.getDeclaredField("theUnsafe");
            unsafeField.setAccessible(true);
            return (Unsafe)unsafeField.get(null);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public CursedComponent construct(Object ... args) {
        List<Constructor> c = CursedComponent.getConstructors(this.context.type()).filter(i -> i.getParameterCount() == args.length).toList();
        for (Constructor i2 : c) {
            try {
                return Curse.on(i2.newInstance(args));
            }
            catch (Throwable throwable) {
            }
        }
        throw new RuntimeException("No constructor found for " + this.context.type() + " with args (" + Arrays.deepToString(args) + ")");
    }

    public Stream<CursedField> fields() {
        return CursedComponent.getFields(this.getClass()).map(i -> new CursedField(this.context(), (Field)i));
    }

    public Stream<CursedField> instanceFields() {
        return this.fields().filter(i -> !Modifier.isStatic(i.getMember().getModifiers()));
    }

    public Stream<CursedField> staticFields() {
        return this.fields().filter(i -> Modifier.isStatic(i.getMember().getModifiers()));
    }

    public Optional<CursedMethod> fuzz(FuzzyMethod invocation) {
        return CursedComponent.getMethods(this.type()).filter(i -> invocation.isStaticMethod() == Modifier.isStatic(i.getModifiers())).filter(i -> invocation.getReturns().equals(i.getReturnType())).filter(i -> invocation.getPossibleNames() == null || !invocation.getPossibleNames().isEmpty() || invocation.getPossibleNames().contains(i.getName())).filter(i -> {
            if ((invocation.getParameters() == null || invocation.getParameters().isEmpty()) && i.getParameterCount() == 0) {
                return true;
            }
            if (invocation.getParameters() != null && i.getParameterCount() == invocation.getParameters().size()) {
                for (int jj = 0; jj < i.getParameterCount(); ++jj) {
                    Class<?> b;
                    Class<?> a2 = i.getParameterTypes()[jj];
                    if (!a2.isAssignableFrom(b = invocation.getParameters().get(jj)) && !b.isAssignableFrom(a2)) continue;
                    return true;
                }
            }
            return false;
        }).map(i -> new CursedMethod(this.context(), (Method)i)).findFirst();
    }

    public <T> T get(String name) {
        try {
            return this.field(name).get();
        }
        catch (Throwable throwable) {
            try {
                return this.method("get" + CursedComponent.capitalize(name), new Class[0]).invoke(new Object[0]);
            }
            catch (Throwable throwable2) {
                throw new RuntimeException("No such field or getter: " + name + " or get" + CursedComponent.capitalize(name) + "()");
            }
        }
    }

    public CursedComponent set(String name, Object v) {
        try {
            return this.setOrThrow(name, v);
        }
        catch (Throwable e) {
            return this;
        }
    }

    public CursedComponent setOrThrow(String name, Object v) {
        try {
            this.field(name).set(v);
            return this;
        }
        catch (Throwable throwable) {
            try {
                this.method("set" + CursedComponent.capitalize(name), v.getClass()).invoke(v);
                return this;
            }
            catch (Throwable throwable2) {
                try {
                    CursedComponent.getMethods(this.context().type()).filter(i -> i.getName().equals("set" + CursedComponent.capitalize(name))).findFirst().ifPresent(i -> {
                        try {
                            i.invoke(this.context().instance(), v);
                        }
                        catch (Throwable e) {
                            throw new RuntimeException(e);
                        }
                    });
                    return this;
                }
                catch (Throwable throwable3) {
                    throw new RuntimeException("No such field or setter: " + name + " or set" + CursedComponent.capitalize(name) + "(" + v.getClass() + "). Also searched for any setter with any parameter type. If you are trying to set an object through a setter which does not have the same exact parameter type as your value, use set(name, value, type) instead.");
                }
            }
        }
    }

    public CursedComponent set(String name, Object v, Class<?> type) {
        try {
            this.field(name).set(v);
            return this;
        }
        catch (Throwable throwable) {
            try {
                this.method("set" + CursedComponent.capitalize(name), type).invoke(v);
                return this;
            }
            catch (Throwable throwable2) {
                throw new RuntimeException("No such field or setter: " + name + " or set" + CursedComponent.capitalize(name) + "(" + v.getClass() + ").");
            }
        }
    }

    private static String capitalize(String f) {
        return Character.toUpperCase(f.charAt(0)) + f.substring(1);
    }

    public CursedField field(Class<?> type) {
        return CursedComponent.getFields(this.context().type()).filter(i -> i.getType().equals(type)).findFirst().map(i -> this.field(i.getName())).orElseThrow(() -> new RuntimeException("No field of type " + type + " in " + this.context.type()));
    }

    public CursedMethod methodReturning(Class<?> type) {
        return CursedComponent.getMethods(this.context().type()).filter(i -> i.getReturnType().equals(type)).findFirst().map(i -> this.method(i.getName(), i.getParameterTypes())).orElseThrow(() -> new RuntimeException("No method returning type " + type + " in " + this.context.type()));
    }

    public CursedMethod methodReturningArgs(Class<?> type, Class<?> ... args) {
        return CursedComponent.getMethods(this.context().type()).filter(i -> i.getReturnType().equals(type)).filter(i -> Arrays.equals(i.getParameterTypes(), args)).findFirst().map(i -> this.method(i.getName(), i.getParameterTypes())).orElseThrow(() -> new RuntimeException("No method returning type " + type + " with args (" + Arrays.deepToString(args) + ") in " + this.context.type()));
    }

    public CursedMethod methodArgs(Class<?> ... args) {
        return CursedComponent.getMethods(this.context().type()).filter(i -> Arrays.equals(i.getParameterTypes(), args)).findFirst().map(i -> this.method(i.getName(), i.getParameterTypes())).orElseThrow(() -> new RuntimeException("No method with args (" + Arrays.deepToString(args) + ") in " + this.context.type()));
    }

    public Optional<CursedField> optionalField(String field) {
        return Optional.ofNullable(CursedComponent.getField(this.context.type(), field)).map(i -> new CursedField(this.context, (Field)i));
    }

    public CursedField field(String field) {
        return this.optionalField(field).get();
    }

    public Optional<CursedMethod> optionalMethod(String method, Class<?> ... args) {
        return Optional.ofNullable(CursedComponent.getMethod(this.context.type(), method, args)).map(i -> new CursedMethod(this.context, (Method)i));
    }

    public CursedMethod method(String method, Class<?> ... args) {
        return this.optionalMethod(method, args).get();
    }

    public Optional<CursedConstructor> optionalConstructor(Class<?> ... args) {
        return Optional.ofNullable(CursedComponent.getConstructor(this.context.type(), args)).map(i -> new CursedConstructor(this.context, (Constructor<?>)i));
    }

    public CursedConstructor constructor(Class<?> ... args) {
        return this.optionalConstructor(args).get();
    }

    private static Field getField(Class<?> clazz, String fieldName) {
        try {
            return clazz.getDeclaredField(fieldName);
        }
        catch (NoSuchFieldException | SecurityException e) {
            Class<?> superClass = clazz.getSuperclass();
            if (superClass == null) {
                return null;
            }
            return CursedComponent.getField(superClass, fieldName);
        }
    }

    private static Method getMethod(Class<?> clazz, String methodName, Class<?> ... args) {
        try {
            return clazz.getDeclaredMethod(methodName, args);
        }
        catch (NoSuchMethodException | SecurityException e) {
            Class<?> superClass = clazz.getSuperclass();
            if (superClass == null) {
                return null;
            }
            return CursedComponent.getMethod(superClass, methodName, args);
        }
    }

    private static Constructor<?> getConstructor(Class<?> clazz, Class<?> ... args) {
        try {
            return clazz.getDeclaredConstructor(args);
        }
        catch (NoSuchMethodException | SecurityException e) {
            Class<?> superClass = clazz.getSuperclass();
            if (superClass == null) {
                return null;
            }
            return CursedComponent.getConstructor(superClass, args);
        }
    }

    private static Stream<Field> getFields(Class<?> clazz) {
        Stream.Builder<Field> fields = Stream.builder();
        while (clazz != Object.class) {
            for (Field i : clazz.getDeclaredFields()) {
                fields.add(i);
            }
            clazz = clazz.getSuperclass();
        }
        return fields.build();
    }

    private static Stream<Method> getMethods(Class<?> clazz) {
        Stream.Builder<Method> methods = Stream.builder();
        while (clazz != Object.class) {
            for (Method i : clazz.getDeclaredMethods()) {
                methods.add(i);
            }
            clazz = clazz.getSuperclass();
        }
        return methods.build();
    }

    private static Stream<Constructor<?>> getConstructors(Class<?> clazz) {
        Stream.Builder<Constructor<?>> constructors = Stream.builder();
        while (clazz != Object.class) {
            for (Constructor<?> i : clazz.getDeclaredConstructors()) {
                constructors.add(i);
            }
            clazz = clazz.getSuperclass();
        }
        return constructors.build();
    }

    public CursedContext context() {
        return this.context;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CursedComponent)) {
            return false;
        }
        CursedComponent other = (CursedComponent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        CursedContext this$context = this.context();
        CursedContext other$context = other.context();
        return !(this$context == null ? other$context != null : !((Object)this$context).equals(other$context));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CursedComponent;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        CursedContext $context = this.context();
        result = result * 59 + ($context == null ? 43 : ((Object)$context).hashCode());
        return result;
    }

    public String toString() {
        return "CursedComponent(context=" + this.context() + ")";
    }

    public CursedComponent(CursedContext context) {
        this.context = context;
    }
}

