/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.util.arcane.spatial.container;

import com.volmit.adapt.util.arcane.spatial.util.Varint;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLongArray;
import java.util.function.IntConsumer;
import org.apache.commons.lang3.Validate;

public class DataBits {
    private static final int[] MAGIC = new int[]{-1, -1, 0, Integer.MIN_VALUE, 0, 0, 0x55555555, 0x55555555, 0, Integer.MIN_VALUE, 0, 1, 0x33333333, 0x33333333, 0, 0x2AAAAAAA, 0x2AAAAAAA, 0, 0x24924924, 0x24924924, 0, Integer.MIN_VALUE, 0, 2, 0x1C71C71C, 0x1C71C71C, 0, 0x19999999, 0x19999999, 0, 390451572, 390451572, 0, 0x15555555, 0x15555555, 0, 0x13B13B13, 0x13B13B13, 0, 306783378, 306783378, 0, 0x11111111, 0x11111111, 0, Integer.MIN_VALUE, 0, 3, 0xF0F0F0F, 0xF0F0F0F, 0, 0xE38E38E, 0xE38E38E, 0, 226050910, 226050910, 0, 0xCCCCCCC, 0xCCCCCCC, 0, 0xC30C30C, 0xC30C30C, 0, 195225786, 195225786, 0, 186737708, 186737708, 0, 0xAAAAAAA, 0xAAAAAAA, 0, 171798691, 171798691, 0, 0x9D89D89, 0x9D89D89, 0, 159072862, 159072862, 0, 0x9249249, 0x9249249, 0, 148102320, 148102320, 0, 0x8888888, 0x8888888, 0, 138547332, 138547332, 0, Integer.MIN_VALUE, 0, 4, 130150524, 130150524, 0, 0x7878787, 0x7878787, 0, 0x7507507, 0x7507507, 0, 0x71C71C7, 0x71C71C7, 0, 116080197, 116080197, 0, 113025455, 113025455, 0, 0x6906906, 0x6906906, 0, 0x6666666, 0x6666666, 0, 104755299, 104755299, 0, 0x6186186, 0x6186186, 0, 99882960, 99882960, 0, 97612893, 97612893, 0, 0x5B05B05, 0x5B05B05, 0, 93368854, 93368854, 0, 91382282, 91382282, 0, 0x5555555, 0x5555555, 0, 87652393, 87652393, 0, 85899345, 85899345, 0, 0x5050505, 0x5050505, 0, 0x4EC4EC4, 0x4EC4EC4, 0, 81037118, 81037118, 0, 79536431, 79536431, 0, 78090314, 78090314, 0, 0x4924924, 0x4924924, 0, 75350303, 75350303, 0, 74051160, 74051160, 0, 72796055, 72796055, 0, 0x4444444, 0x4444444, 0, 70409299, 70409299, 0, 69273666, 69273666, 0, 0x4104104, 0x4104104, 0, Integer.MIN_VALUE, 0, 5};
    private final AtomicLongArray data;
    private final int bits;
    private final long mask;
    private final int size;
    private final int valuesPerLong;
    private final int divideMul;
    private final int divideAdd;
    private final int divideShift;

    public DataBits(int bits, int length) {
        this(bits, length, (AtomicLongArray)null);
    }

    public DataBits(int bits, int length, DataInputStream din) throws IOException {
        this(bits, length, DataBits.longs(din, DataBits.dataLength(bits, length)));
    }

    public DataBits(int bits, int length, AtomicLongArray data) {
        Validate.inclusiveBetween((long)1L, (long)32L, (long)bits);
        this.size = length;
        this.bits = bits;
        this.mask = (1L << bits) - 1L;
        this.valuesPerLong = (char)(64 / bits);
        int var3 = 3 * (this.valuesPerLong - 1);
        this.divideMul = MAGIC[var3];
        this.divideAdd = MAGIC[var3 + 1];
        this.divideShift = MAGIC[var3 + 2];
        int var4 = (length + this.valuesPerLong - 1) / this.valuesPerLong;
        if (data != null) {
            if (data.length() != var4) {
                throw new RuntimeException("NO! Trying to load " + data.length() + " into actual size of " + var4 + " because length: " + length + " (bits: " + bits + ")");
            }
            this.data = data;
        } else {
            this.data = new AtomicLongArray(var4);
        }
    }

    public String toString() {
        return "DBits: " + this.size + "/" + this.bits + "[" + this.data.length() + "]";
    }

    private static int dataLength(int bits, int length) {
        return (length + (char)(64 / bits) - 1) / (char)(64 / bits);
    }

    private static AtomicLongArray longs(DataInputStream din, int longSize) throws IOException {
        AtomicLongArray a2 = new AtomicLongArray(longSize);
        for (int i = 0; i < a2.length(); ++i) {
            a2.set(i, Varint.readUnsignedVarLong(din));
        }
        return a2;
    }

    public DataBits setBits(int newBits) {
        if (this.bits != newBits) {
            DataBits newData = new DataBits(newBits, this.size);
            AtomicInteger c = new AtomicInteger(0);
            for (int i = 0; i < this.size; ++i) {
                newData.set(i, this.get(i));
            }
            return newData;
        }
        return this;
    }

    private int cellIndex(int var0) {
        long var1 = Integer.toUnsignedLong(this.divideMul);
        long var3 = Integer.toUnsignedLong(this.divideAdd);
        return (int)((long)var0 * var1 + var3 >> 32 >> this.divideShift);
    }

    public int getAndSet(int var0, int var1) {
        Validate.inclusiveBetween((long)0L, (long)(this.size - 1), (long)var0);
        Validate.inclusiveBetween((long)0L, (long)this.mask, (long)var1);
        int var2 = this.cellIndex(var0);
        long var3 = this.data.get(var2);
        int var5 = (var0 - var2 * this.valuesPerLong) * this.bits;
        int var6 = (int)(var3 >> var5 & this.mask);
        this.data.set(var2, var3 & (this.mask << var5 ^ 0xFFFFFFFFFFFFFFFFL) | ((long)var1 & this.mask) << var5);
        return var6;
    }

    public void set(int var0, int var1) {
        Validate.inclusiveBetween((long)0L, (long)(this.size - 1), (long)var0);
        Validate.inclusiveBetween((long)0L, (long)this.mask, (long)var1);
        int var2 = this.cellIndex(var0);
        long var3 = this.data.get(var2);
        int var5 = (var0 - var2 * this.valuesPerLong) * this.bits;
        this.data.set(var2, var3 & (this.mask << var5 ^ 0xFFFFFFFFFFFFFFFFL) | ((long)var1 & this.mask) << var5);
    }

    public int get(int var0) {
        Validate.inclusiveBetween((long)0L, (long)(this.size - 1), (long)var0);
        int var1 = this.cellIndex(var0);
        long var2 = this.data.get(var1);
        int var4 = (var0 - var1 * this.valuesPerLong) * this.bits;
        return (int)(var2 >> var4 & this.mask);
    }

    public AtomicLongArray getRaw() {
        return this.data;
    }

    public int getSize() {
        return this.size;
    }

    public int getBits() {
        return this.bits;
    }

    public void getAll(IntConsumer var0) {
        int var1 = 0;
        for (int i = 0; i < this.data.length(); ++i) {
            long var5 = this.data.get(i);
            for (int var7 = 0; var7 < this.valuesPerLong; ++var7) {
                var0.accept((int)(var5 & this.mask));
                var5 >>= this.bits;
                if (++var1 < this.size) continue;
                return;
            }
        }
    }

    public void write(DataOutputStream dos) throws IOException {
        for (int i = 0; i < this.data.length(); ++i) {
            Varint.writeUnsignedVarLong(this.data.get(i), dos);
        }
    }
}

