/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.util.arcane.spatial.container;

import com.volmit.adapt.util.arcane.spatial.container.DataBits;
import com.volmit.adapt.util.arcane.spatial.container.HashPalette;
import com.volmit.adapt.util.arcane.spatial.container.LinearPalette;
import com.volmit.adapt.util.arcane.spatial.container.NodeWritable;
import com.volmit.adapt.util.arcane.spatial.container.Palette;
import com.volmit.adapt.util.arcane.spatial.util.Varint;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

public class DataContainer<T> {
    protected static final int INITIAL_BITS = 3;
    protected static final int LINEAR_BITS_LIMIT = 4;
    protected static final int LINEAR_INITIAL_LENGTH = (int)Math.pow(2.0, 4.0) + 1;
    protected static final int[] BIT = DataContainer.computeBitLimits();
    private final AtomicReference<Palette<T>> palette;
    private final AtomicReference<DataBits> data;
    private final AtomicInteger bits;
    private final int length;
    private final NodeWritable<T> writer;

    public DataContainer(NodeWritable<T> writer, int length) {
        this.writer = writer;
        this.length = length;
        this.bits = new AtomicInteger(3);
        this.data = new AtomicReference<DataBits>(new DataBits(3, length));
        this.palette = new AtomicReference<Palette<T>>(this.newPalette(3));
    }

    public DataContainer(byte[] data, NodeWritable<T> writer) throws IOException {
        this(new ByteArrayInputStream(data), writer);
    }

    public DataContainer(InputStream in, NodeWritable<T> writer) throws IOException {
        this(new DataInputStream(in), writer);
    }

    public DataContainer(DataInputStream din, NodeWritable<T> writer) throws IOException {
        this.writer = writer;
        this.length = Varint.readUnsignedVarInt(din);
        this.palette = new AtomicReference<Palette<T>>(this.newPalette(din));
        this.data = new AtomicReference<DataBits>(new DataBits(this.palette.get().bits(), this.length, din));
        this.bits = new AtomicInteger(this.palette.get().bits());
    }

    public static String readBitString(DataInputStream din) throws IOException {
        DataContainer<Character> c = new DataContainer<Character>(din, new NodeWritable<Character>(){

            @Override
            public Character readNodeData(DataInputStream din) throws IOException {
                return Character.valueOf(din.readChar());
            }

            @Override
            public void writeNodeData(DataOutputStream dos, Character character) throws IOException {
                dos.writeChar(character.charValue());
            }
        });
        StringBuilder sb = new StringBuilder();
        for (int i = c.size() - 1; i >= 0; --i) {
            sb.setCharAt(i, c.get(i).charValue());
        }
        return sb.toString();
    }

    public static void writeBitString(String s, DataOutputStream dos) throws IOException {
        DataContainer<Character> c = new DataContainer<Character>(new NodeWritable<Character>(){

            @Override
            public Character readNodeData(DataInputStream din) throws IOException {
                return Character.valueOf(din.readChar());
            }

            @Override
            public void writeNodeData(DataOutputStream dos, Character character) throws IOException {
                dos.writeChar(character.charValue());
            }
        }, s.length());
        for (int i = 0; i < s.length(); ++i) {
            c.set(i, Character.valueOf(s.charAt(i)));
        }
        c.writeDos(dos);
    }

    public DataBits getData() {
        return this.data.get();
    }

    public Palette<T> getPalette() {
        return this.palette.get();
    }

    public String toString() {
        return "DataContainer <" + this.length + " x " + this.bits + " bits> -> Palette<" + this.palette.get().getClass().getSimpleName().replaceAll("\\QPalette\\E", "") + ">: " + this.palette.get().size() + " " + this.data.get().toString() + " PalBit: " + this.palette.get().bits();
    }

    public byte[] write() throws IOException {
        ByteArrayOutputStream boas = new ByteArrayOutputStream();
        this.write(boas);
        return boas.toByteArray();
    }

    public void write(OutputStream out) throws IOException {
        this.writeDos(new DataOutputStream(out));
    }

    public void writeDos(DataOutputStream dos) throws IOException {
        Varint.writeUnsignedVarInt(this.length, dos);
        Varint.writeUnsignedVarInt(this.palette.get().size(), dos);
        this.palette.get().iterateIO((data, __) -> this.writer.writeNodeData(dos, data));
        this.data.get().write(dos);
        dos.flush();
    }

    private Palette<T> newPalette(DataInputStream din) throws IOException {
        int paletteSize = Varint.readUnsignedVarInt(din);
        Palette<T> d = this.newPalette(DataContainer.bits(paletteSize + 1));
        d.from(paletteSize, this.writer, din);
        return d;
    }

    private Palette<T> newPalette(int bits) {
        if (bits <= 4) {
            return new LinearPalette(LINEAR_INITIAL_LENGTH);
        }
        return new HashPalette();
    }

    public void ensurePaletted(T t) {
        if (this.palette.get().id(t) == -1) {
            this.expandOne();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set(int position, T t) {
        DataContainer dataContainer = this;
        synchronized (dataContainer) {
            int id = this.palette.get().id(t);
            if (id == -1) {
                this.expandOne();
                id = this.palette.get().add(t);
            }
            this.data.get().set(position, id);
        }
    }

    private void expandOne() {
        if (this.palette.get().size() + 1 >= BIT[this.bits.get()]) {
            this.setBits(this.bits.get() + 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T get(int position) {
        DataContainer dataContainer = this;
        synchronized (dataContainer) {
            int id = this.data.get().get(position) + 1;
            if (id <= 0) {
                return null;
            }
            return this.palette.get().get(id - 1);
        }
    }

    public void setBits(int bits) {
        if (this.bits.get() != bits) {
            if (this.bits.get() <= 4 != bits <= 4) {
                this.palette.set(this.newPalette(bits).from(this.palette.get()));
            }
            this.bits.set(bits);
            this.data.set(this.data.get().setBits(bits));
        }
    }

    private static int[] computeBitLimits() {
        int[] m = new int[16];
        for (int i = 0; i < m.length; ++i) {
            m[i] = (int)Math.pow(2.0, i);
        }
        return m;
    }

    protected static int bits(int size) {
        if (BIT[3] >= size) {
            return 3;
        }
        for (int i = 0; i < BIT.length; ++i) {
            if (BIT[i] < size) continue;
            return i;
        }
        return BIT.length - 1;
    }

    public int size() {
        return this.getData().getSize();
    }
}

