/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.util.arcane.spatial.hunk.storage;

import com.volmit.adapt.util.arcane.spatial.hunk.Hunk;
import com.volmit.adapt.util.arcane.spatial.hunk.storage.StorageHunk;
import com.volmit.adapt.util.arcane.spatial.util.CompressedNumbers;
import java.util.Arrays;

public class ArrayHunk<T>
extends StorageHunk<T>
implements Hunk<T> {
    private final T[] data;

    public ArrayHunk(int w, int h, int d) {
        super(w, h, d);
        this.data = new Object[w * h * d];
    }

    @Override
    public void setRaw(int x, int y, int z, T t) {
        this.data[this.index((int)x, (int)y, (int)z)] = t;
    }

    @Override
    public T getRaw(int x, int y, int z) {
        return this.data[this.index(x, y, z)];
    }

    private int index(int x, int y, int z) {
        return CompressedNumbers.index3Dto1D(x, y, z, this.getWidth(), this.getHeight());
    }

    @Override
    public void fill(T t) {
        Arrays.fill(this.data, t);
    }

    public T[] getData() {
        return this.data;
    }

    @Override
    public String toString() {
        return "ArrayHunk(data=" + Arrays.deepToString(this.getData()) + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ArrayHunk)) {
            return false;
        }
        ArrayHunk other = (ArrayHunk)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return Arrays.deepEquals(this.getData(), other.getData());
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ArrayHunk;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Arrays.deepHashCode(this.getData());
        return result;
    }
}

