/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.util.arcane.spatial.hunk.storage;

import com.google.common.util.concurrent.AtomicDoubleArray;
import com.volmit.adapt.util.arcane.spatial.hunk.Hunk;
import com.volmit.adapt.util.arcane.spatial.hunk.storage.StorageHunk;

public class AtomicDoubleHunk
extends StorageHunk<Double>
implements Hunk<Double> {
    private final AtomicDoubleArray data;

    public AtomicDoubleHunk(int w, int h, int d) {
        super(w, h, d);
        this.data = new AtomicDoubleArray(w * h * d);
    }

    @Override
    public boolean isAtomic() {
        return true;
    }

    @Override
    public void setRaw(int x, int y, int z, Double t) {
        this.data.set(this.index(x, y, z), t.doubleValue());
    }

    @Override
    public Double getRaw(int x, int y, int z) {
        return this.data.get(this.index(x, y, z));
    }

    private int index(int x, int y, int z) {
        return z * this.getWidth() * this.getHeight() + y * this.getWidth() + x;
    }

    public AtomicDoubleArray getData() {
        return this.data;
    }

    @Override
    public String toString() {
        return "AtomicDoubleHunk(data=" + this.getData() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AtomicDoubleHunk)) {
            return false;
        }
        AtomicDoubleHunk other = (AtomicDoubleHunk)o;
        if (!other.canEqual(this)) {
            return false;
        }
        AtomicDoubleArray this$data = this.getData();
        AtomicDoubleArray other$data = other.getData();
        return !(this$data == null ? other$data != null : !this$data.equals(other$data));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof AtomicDoubleHunk;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        AtomicDoubleArray $data = this.getData();
        result = result * 59 + ($data == null ? 43 : $data.hashCode());
        return result;
    }
}

