/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.util.arcane.spatial.hunk.storage;

import com.volmit.adapt.util.arcane.spatial.hunk.Hunk;
import com.volmit.adapt.util.arcane.spatial.hunk.storage.StorageHunk;
import java.util.concurrent.atomic.AtomicIntegerArray;

public class AtomicIntegerHunk
extends StorageHunk<Integer>
implements Hunk<Integer> {
    private final AtomicIntegerArray data;

    public AtomicIntegerHunk(int w, int h, int d) {
        super(w, h, d);
        this.data = new AtomicIntegerArray(w * h * d);
    }

    @Override
    public boolean isAtomic() {
        return true;
    }

    @Override
    public void setRaw(int x, int y, int z, Integer t) {
        this.data.set(this.index(x, y, z), t);
    }

    @Override
    public Integer getRaw(int x, int y, int z) {
        return this.data.get(this.index(x, y, z));
    }

    private int index(int x, int y, int z) {
        return z * this.getWidth() * this.getHeight() + y * this.getWidth() + x;
    }

    public AtomicIntegerArray getData() {
        return this.data;
    }

    @Override
    public String toString() {
        return "AtomicIntegerHunk(data=" + this.getData() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AtomicIntegerHunk)) {
            return false;
        }
        AtomicIntegerHunk other = (AtomicIntegerHunk)o;
        if (!other.canEqual(this)) {
            return false;
        }
        AtomicIntegerArray this$data = this.getData();
        AtomicIntegerArray other$data = other.getData();
        return !(this$data == null ? other$data != null : !this$data.equals(other$data));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof AtomicIntegerHunk;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        AtomicIntegerArray $data = this.getData();
        result = result * 59 + ($data == null ? 43 : $data.hashCode());
        return result;
    }
}

