/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.util.arcane.spatial.hunk.storage;

import com.volmit.adapt.util.arcane.spatial.hunk.Hunk;
import com.volmit.adapt.util.arcane.spatial.hunk.storage.StorageHunk;
import com.volmit.adapt.util.arcane.spatial.util.Consume;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class MappedHunk<T>
extends StorageHunk<T>
implements Hunk<T> {
    private final Map<Integer, T> data = new ConcurrentHashMap<Integer, T>();

    public MappedHunk(int w, int h, int d) {
        super(w, h, d);
    }

    @Override
    public int getEntryCount() {
        return this.data.size();
    }

    @Override
    public boolean isMapped() {
        return true;
    }

    @Override
    public boolean isEmpty() {
        return this.data.isEmpty();
    }

    @Override
    public void setRaw(int x, int y, int z, T t) {
        if (t == null) {
            this.data.remove(this.index(x, y, z));
            return;
        }
        this.data.put(this.index(x, y, z), t);
    }

    private Integer index(int x, int y, int z) {
        return z * this.getWidth() * this.getHeight() + y * this.getWidth() + x;
    }

    @Override
    public synchronized Hunk<T> iterateSync(Consume.Four<Integer, Integer, Integer, T> c) {
        for (Map.Entry<Integer, T> g : this.data.entrySet()) {
            int idx = g.getKey();
            int z = idx / (this.getWidth() * this.getHeight());
            c.accept((idx -= z * this.getWidth() * this.getHeight()) % this.getWidth(), idx / this.getWidth(), z, g.getValue());
        }
        return this;
    }

    @Override
    public synchronized Hunk<T> iterateSyncIO(Consume.FourIO<Integer, Integer, Integer, T> c) throws IOException {
        for (Map.Entry<Integer, T> g : this.data.entrySet()) {
            int idx = g.getKey();
            int z = idx / (this.getWidth() * this.getHeight());
            c.accept((idx -= z * this.getWidth() * this.getHeight()) % this.getWidth(), idx / this.getWidth(), z, g.getValue());
        }
        return this;
    }

    @Override
    public void empty(T b) {
        this.data.clear();
    }

    @Override
    public T getRaw(int x, int y, int z) {
        return this.data.get(this.index(x, y, z));
    }

    public Map<Integer, T> getData() {
        return this.data;
    }

    @Override
    public String toString() {
        return "MappedHunk(data=" + this.getData() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MappedHunk)) {
            return false;
        }
        MappedHunk other = (MappedHunk)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Map<Integer, T> this$data = this.getData();
        Map<Integer, T> other$data = other.getData();
        return !(this$data == null ? other$data != null : !((Object)this$data).equals(other$data));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof MappedHunk;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<Integer, T> $data = this.getData();
        result = result * 59 + ($data == null ? 43 : ((Object)$data).hashCode());
        return result;
    }
}

