/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.util.arcane.spatial.hunk.storage;

import com.volmit.adapt.util.arcane.spatial.container.DataContainer;
import com.volmit.adapt.util.arcane.spatial.container.NodeWritable;
import com.volmit.adapt.util.arcane.spatial.hunk.Hunk;
import com.volmit.adapt.util.arcane.spatial.hunk.storage.StorageHunk;
import com.volmit.adapt.util.arcane.spatial.util.Consume;
import java.io.IOException;

public class PaletteHunk<T>
extends StorageHunk<T>
implements Hunk<T> {
    private DataContainer<T> data;

    public PaletteHunk(int w, int h, int d, NodeWritable<T> writer) {
        super(w, h, d);
        this.data = new DataContainer<T>(writer, w * h * d);
    }

    public void setPalette(DataContainer<T> c) {
        this.data = c;
    }

    @Override
    public boolean isMapped() {
        return false;
    }

    private int index(int x, int y, int z) {
        return z * this.getWidth() * this.getHeight() + y * this.getWidth() + x;
    }

    @Override
    public synchronized Hunk<T> iterateSync(Consume.Four<Integer, Integer, Integer, T> c) {
        for (int i = 0; i < this.getWidth(); ++i) {
            for (int j = 0; j < this.getHeight(); ++j) {
                for (int k = 0; k < this.getDepth(); ++k) {
                    T t = this.getRaw(i, j, k);
                    if (t == null) continue;
                    c.accept(i, j, k, t);
                }
            }
        }
        return this;
    }

    @Override
    public synchronized Hunk<T> iterateSyncIO(Consume.FourIO<Integer, Integer, Integer, T> c) throws IOException {
        for (int i = 0; i < this.getWidth(); ++i) {
            for (int j = 0; j < this.getHeight(); ++j) {
                for (int k = 0; k < this.getDepth(); ++k) {
                    T t = this.getRaw(i, j, k);
                    if (t == null) continue;
                    c.accept(i, j, k, t);
                }
            }
        }
        return this;
    }

    @Override
    public void setRaw(int x, int y, int z, T t) {
        this.data.set(this.index(x, y, z), t);
    }

    @Override
    public T getRaw(int x, int y, int z) {
        return this.data.get(this.index(x, y, z));
    }

    public DataContainer<T> getData() {
        return this.data;
    }

    public void setData(DataContainer<T> data) {
        this.data = data;
    }

    @Override
    public String toString() {
        return "PaletteHunk(data=" + this.getData() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PaletteHunk)) {
            return false;
        }
        PaletteHunk other = (PaletteHunk)o;
        if (!other.canEqual(this)) {
            return false;
        }
        DataContainer<T> this$data = this.getData();
        DataContainer<T> other$data = other.getData();
        return !(this$data == null ? other$data != null : !this$data.equals(other$data));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof PaletteHunk;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        DataContainer<T> $data = this.getData();
        result = result * 59 + ($data == null ? 43 : $data.hashCode());
        return result;
    }
}

