/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.util.arcane.spatial.hunk.storage;

import com.volmit.adapt.util.arcane.spatial.container.DataContainer;
import com.volmit.adapt.util.arcane.spatial.container.NodeWritable;
import com.volmit.adapt.util.arcane.spatial.hunk.Hunk;
import com.volmit.adapt.util.arcane.spatial.hunk.storage.PaletteHunk;
import com.volmit.adapt.util.arcane.spatial.hunk.storage.StorageHunk;
import com.volmit.adapt.util.arcane.spatial.util.Consume;
import java.io.IOException;
import java.util.function.Supplier;

public abstract class PaletteOrHunk<T>
extends StorageHunk<T>
implements Hunk<T>,
NodeWritable<T> {
    private final Hunk<T> hunk;

    public PaletteOrHunk(int width, int height, int depth, boolean allow, Supplier<Hunk<T>> factory) {
        super(width, height, depth);
        this.hunk = allow && width * height * depth <= 4096 ? new PaletteHunk(width, height, depth, this) : factory.get();
    }

    public DataContainer<T> palette() {
        return this.isPalette() ? ((PaletteHunk)this.hunk).getData() : null;
    }

    public void setPalette(DataContainer<T> c) {
        if (this.isPalette()) {
            ((PaletteHunk)this.hunk).setPalette(c);
        }
    }

    public boolean isPalette() {
        return this.hunk instanceof PaletteHunk;
    }

    @Override
    public void setRaw(int x, int y, int z, T t) {
        this.hunk.setRaw(x, y, z, t);
    }

    @Override
    public T getRaw(int x, int y, int z) {
        return this.hunk.getRaw(x, y, z);
    }

    @Override
    public int getEntryCount() {
        return this.hunk.getEntryCount();
    }

    @Override
    public boolean isMapped() {
        return this.hunk.isMapped();
    }

    @Override
    public boolean isEmpty() {
        return this.hunk.isMapped();
    }

    @Override
    public synchronized Hunk<T> iterateSync(Consume.Four<Integer, Integer, Integer, T> c) {
        this.hunk.iterateSync(c);
        return this;
    }

    @Override
    public synchronized Hunk<T> iterateSyncIO(Consume.FourIO<Integer, Integer, Integer, T> c) throws IOException {
        this.hunk.iterateSyncIO(c);
        return this;
    }

    @Override
    public void empty(T b) {
        this.hunk.empty(b);
    }
}

