/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.util.arcane.spatial.hunk.storage;

import com.volmit.adapt.util.arcane.spatial.hunk.Hunk;

public abstract class StorageHunk<T>
implements Hunk<T> {
    private final int width;
    private final int height;
    private final int depth;

    public StorageHunk(int width, int height, int depth) {
        if (width <= 0 || height <= 0 || depth <= 0) {
            throw new RuntimeException("Unsupported size " + width + " " + height + " " + depth);
        }
        this.width = width;
        this.height = height;
        this.depth = depth;
    }

    @Override
    public abstract void setRaw(int var1, int var2, int var3, T var4);

    @Override
    public abstract T getRaw(int var1, int var2, int var3);

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public int getDepth() {
        return this.depth;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StorageHunk)) {
            return false;
        }
        StorageHunk other = (StorageHunk)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getWidth() != other.getWidth()) {
            return false;
        }
        if (this.getHeight() != other.getHeight()) {
            return false;
        }
        return this.getDepth() == other.getDepth();
    }

    protected boolean canEqual(Object other) {
        return other instanceof StorageHunk;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getWidth();
        result = result * 59 + this.getHeight();
        result = result * 59 + this.getDepth();
        return result;
    }

    public String toString() {
        return "StorageHunk(width=" + this.getWidth() + ", height=" + this.getHeight() + ", depth=" + this.getDepth() + ")";
    }
}

