/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.util.arcane.spatial.hunk.storage;

import com.volmit.adapt.util.arcane.spatial.hunk.Hunk;
import com.volmit.adapt.util.arcane.spatial.hunk.storage.StorageHunk;
import java.util.Arrays;

public class SynchronizedArrayHunk<T>
extends StorageHunk<T>
implements Hunk<T> {
    private final T[] data;

    public SynchronizedArrayHunk(int w, int h, int d) {
        super(w, h, d);
        this.data = new Object[w * h * d];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setRaw(int x, int y, int z, T t) {
        T[] TArray = this.data;
        synchronized (this.data) {
            this.data[this.index((int)x, (int)y, (int)z)] = t;
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T getRaw(int x, int y, int z) {
        T[] TArray = this.data;
        synchronized (this.data) {
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return this.data[this.index(x, y, z)];
        }
    }

    private int index(int x, int y, int z) {
        return z * this.getWidth() * this.getHeight() + y * this.getWidth() + x;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fill(T t) {
        T[] TArray = this.data;
        synchronized (this.data) {
            Arrays.fill(this.data, t);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public T[] getData() {
        return this.data;
    }

    @Override
    public String toString() {
        return "SynchronizedArrayHunk(data=" + Arrays.deepToString(this.getData()) + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SynchronizedArrayHunk)) {
            return false;
        }
        SynchronizedArrayHunk other = (SynchronizedArrayHunk)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return Arrays.deepEquals(this.getData(), other.getData());
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof SynchronizedArrayHunk;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Arrays.deepHashCode(this.getData());
        return result;
    }
}

