/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.util.arcane.spatial.mantle;

import com.volmit.adapt.util.arcane.multiburst.BurstExecutor;
import com.volmit.adapt.util.arcane.multiburst.MultiBurst;
import com.volmit.adapt.util.arcane.spatial.mantle.MantleChunk;
import com.volmit.adapt.util.arcane.spatial.mantle.MantleRegion;
import com.volmit.adapt.util.arcane.spatial.matter.Matter;
import com.volmit.adapt.util.arcane.spatial.matter.MatterSlice;
import com.volmit.adapt.util.arcane.spatial.parallel.HyperLock;
import com.volmit.adapt.util.arcane.spatial.util.CompressedNumbers;
import com.volmit.adapt.util.arcane.spatial.util.Consume;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;

public class Mantle {
    private final File dataFolder;
    private final int worldHeight;
    private final Map<Long, Long> lastUse;
    private final Map<Long, MantleRegion> loadedRegions;
    private final HyperLock hyperLock = new HyperLock();
    private final Set<Long> unload;
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private final MultiBurst ioBurst;
    private final AtomicBoolean io;

    public Mantle(File dataFolder, int worldHeight) {
        this.dataFolder = dataFolder;
        this.worldHeight = worldHeight;
        this.io = new AtomicBoolean(false);
        this.unload = new HashSet<Long>();
        this.loadedRegions = new HashMap<Long, MantleRegion>();
        this.lastUse = new HashMap<Long, Long>();
        this.ioBurst = MultiBurst.burst;
    }

    public void clear() {
        this.loadedRegions.clear();
        this.lastUse.clear();
        this.unload.clear();
        this.hyperLock.clear();
        if (this.dataFolder.exists() && this.dataFolder.isDirectory()) {
            for (File i : this.dataFolder.listFiles()) {
                i.delete();
            }
        }
        this.dataFolder.delete();
    }

    public static File fileForRegion(File folder, int x, int z) {
        return Mantle.fileForRegion(folder, Mantle.key(x, z));
    }

    public static File fileForRegion(File folder, Long key) {
        File f = new File(folder, "p." + key + ".ttp");
        if (!f.getParentFile().exists()) {
            f.getParentFile().mkdirs();
        }
        return f;
    }

    public static Long key(int x, int z) {
        return CompressedNumbers.i2(x, z);
    }

    public MantleChunk getChunk(int x, int z) {
        return this.get(x >> 5, z >> 5).getOrCreate(x & 0x1F, z & 0x1F);
    }

    public void deleteChunk(int x, int z) {
        this.get(x >> 5, z >> 5).delete(x & 0x1F, z & 0x1F);
    }

    public boolean hasTectonicPlate(int x, int z) {
        Long k = Mantle.key(x, z);
        return this.loadedRegions.containsKey(k) || Mantle.fileForRegion(this.dataFolder, k).exists();
    }

    public <T> void iterateChunk(int x, int z, Class<T> type, Consume.Four<Integer, Integer, Integer, T> iterator) {
        if (!this.hasTectonicPlate(x >> 5, z >> 5)) {
            return;
        }
        this.get(x >> 5, z >> 5).getOrCreate(x & 0x1F, z & 0x1F).iterate(type, iterator);
    }

    public <T> void set(int x, int y, int z, T t) {
        if (this.closed.get()) {
            throw new RuntimeException("The Mantle is closed");
        }
        if (y < 0 || y >= this.worldHeight) {
            return;
        }
        Matter matter = this.get(x >> 4 >> 5, z >> 4 >> 5).getOrCreate(x >> 4 & 0x1F, z >> 4 & 0x1F).getOrCreate(y >> 4);
        matter.slice(matter.getClass(t)).set(x & 0xF, y & 0xF, z & 0xF, t);
    }

    public <T> void remove(int x, int y, int z, Class<T> t) {
        if (this.closed.get()) {
            throw new RuntimeException("The Mantle is closed");
        }
        if (y < 0 || y >= this.worldHeight) {
            return;
        }
        Matter matter = this.get(x >> 4 >> 5, z >> 4 >> 5).getOrCreate(x >> 4 & 0x1F, z >> 4 & 0x1F).getOrCreate(y >> 4);
        matter.slice(t).set(x & 0xF, y & 0xF, z & 0xF, null);
    }

    public <T> T get(int x, int y, int z, Class<T> t) {
        if (this.closed.get()) {
            throw new RuntimeException("The Mantle is closed");
        }
        if (!this.hasTectonicPlate(x >> 4 >> 5, z >> 4 >> 5)) {
            return null;
        }
        if (y < 0 || y >= this.worldHeight) {
            return null;
        }
        return this.get(x >> 4 >> 5, z >> 4 >> 5).getOrCreate(x >> 4 & 0x1F, z >> 4 & 0x1F).getOrCreate(y >> 4).slice(t).get(x & 0xF, y & 0xF, z & 0xF);
    }

    public boolean isClosed() {
        return this.closed.get();
    }

    public synchronized void close() {
        if (this.closed.get()) {
            return;
        }
        this.closed.set(true);
        this.saveAll();
        this.loadedRegions.clear();
    }

    public synchronized void trim(long idleDuration) {
        if (this.closed.get()) {
            throw new RuntimeException("The Mantle is closed");
        }
        this.io.set(true);
        this.unload.clear();
        for (Long i : this.lastUse.keySet()) {
            this.hyperLock.withLong(i, () -> {
                if (System.currentTimeMillis() - this.lastUse.get(i) >= idleDuration) {
                    this.unload.add(i);
                }
            });
        }
        for (Long i : this.unload) {
            this.hyperLock.withLong(i, () -> {
                MantleRegion m = this.loadedRegions.remove(i);
                this.lastUse.remove(i);
                try {
                    m.write(Mantle.fileForRegion(this.dataFolder, i));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            });
        }
        this.io.set(false);
    }

    private MantleRegion get(int x, int z) {
        MantleRegion p;
        if (this.io.get()) {
            try {
                return this.getSafe(x, z).get();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            catch (ExecutionException e) {
                e.printStackTrace();
            }
        }
        if ((p = this.loadedRegions.get(Mantle.key(x, z))) != null) {
            return p;
        }
        try {
            return this.getSafe(x, z).get();
        }
        catch (InterruptedException | ExecutionException e) {
            e.printStackTrace();
            return this.get(x, z);
        }
    }

    private Future<MantleRegion> getSafe(int x, int z) {
        Long k = Mantle.key(x, z);
        MantleRegion p = this.loadedRegions.get(k);
        if (p != null) {
            this.lastUse.put(k, System.currentTimeMillis());
            return CompletableFuture.completedFuture(p);
        }
        return this.ioBurst.completeValue(() -> this.hyperLock.withResult(x, z, () -> {
            this.lastUse.put(k, System.currentTimeMillis());
            MantleRegion region = this.loadedRegions.get(k);
            if (region != null) {
                return region;
            }
            File file = Mantle.fileForRegion(this.dataFolder, x, z);
            if (file.exists()) {
                try {
                    region = MantleRegion.read(this.worldHeight, file);
                    this.loadedRegions.put(k, region);
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    region = new MantleRegion(this.worldHeight, x, z);
                    this.loadedRegions.put(k, region);
                }
                return region;
            }
            region = new MantleRegion(this.worldHeight, x, z);
            this.loadedRegions.put(k, region);
            return region;
        }));
    }

    public void saveAll() {
        if (this.loadedRegions.isEmpty()) {
            return;
        }
        BurstExecutor b = this.ioBurst.burst(this.loadedRegions.size());
        for (Long i : this.loadedRegions.keySet()) {
            b.queue(() -> {
                try {
                    if (!this.dataFolder.exists()) {
                        this.dataFolder.mkdirs();
                    }
                    this.loadedRegions.get(i).write(Mantle.fileForRegion(this.dataFolder, i));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            });
        }
        try {
            b.complete();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public int getWorldHeight() {
        return this.worldHeight;
    }

    public void deleteChunkSlice(int x, int z, Class<?> c) {
        this.getChunk(x, z).deleteSlices(c);
    }

    public int getLoadedRegionCount() {
        return this.loadedRegions.size();
    }

    public <T> void set(int x, int y, int z, MatterSlice<T> slice) {
        if (slice.isEmpty()) {
            return;
        }
        slice.iterateSync((xx, yy, zz, t) -> this.set(x + xx, y + yy, z + zz, t));
    }

    public boolean isChunkLoaded(int x, int z) {
        return this.loadedRegions.containsKey(Mantle.key(x >> 5, z >> 5));
    }

    public Map<Long, MantleRegion> getLoadedRegions() {
        return this.loadedRegions;
    }
}

