/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.util.arcane.spatial.mantle;

import com.volmit.adapt.util.arcane.spatial.mantle.MantleChunk;
import com.volmit.adapt.util.arcane.spatial.util.CompressedNumbers;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class MantleRegion {
    private final int sectionHeight;
    private final AtomicReferenceArray<MantleChunk> chunks;
    private final int x;
    private final int z;

    public MantleRegion(int worldHeight, int x, int z) {
        this.sectionHeight = worldHeight >> 4;
        this.chunks = new AtomicReferenceArray(1024);
        this.x = x;
        this.z = z;
    }

    public MantleRegion(int worldHeight, DataInputStream din) throws IOException, ClassNotFoundException {
        this(worldHeight, din.readInt(), din.readInt());
        for (int i = 0; i < this.chunks.length(); ++i) {
            if (!din.readBoolean()) continue;
            this.chunks.set(i, new MantleChunk(this.sectionHeight, din));
        }
    }

    public static MantleRegion read(int worldHeight, File file) throws IOException, ClassNotFoundException {
        FileInputStream fin = new FileInputStream(file);
        GZIPInputStream gzi = new GZIPInputStream(fin);
        DataInputStream din = new DataInputStream(gzi);
        MantleRegion p = new MantleRegion(worldHeight, din);
        din.close();
        return p;
    }

    public boolean exists(int x, int z) {
        return this.get(x, z) != null;
    }

    public MantleChunk get(int x, int z) {
        return this.chunks.get(this.index(x, z));
    }

    public void clear() {
        for (int i = 0; i < this.chunks.length(); ++i) {
            this.chunks.set(i, null);
        }
    }

    public void delete(int x, int z) {
        this.chunks.set(this.index(x, z), null);
    }

    public MantleChunk getOrCreate(int x, int z) {
        MantleChunk chunk = this.get(x, z);
        if (chunk == null) {
            chunk = new MantleChunk(this.sectionHeight, x & 0x1F, z & 0x1F);
            this.chunks.set(this.index(x, z), chunk);
        }
        return chunk;
    }

    private int index(int x, int z) {
        return CompressedNumbers.index3Dto1D(x, z, 0, 32, 32);
    }

    public void write(File file) throws IOException {
        FileOutputStream fos = new FileOutputStream(file);
        GZIPOutputStream gzo = new GZIPOutputStream(fos);
        DataOutputStream dos = new DataOutputStream(gzo);
        this.write(dos);
        dos.close();
    }

    public void write(DataOutputStream dos) throws IOException {
        dos.writeInt(this.x);
        dos.writeInt(this.z);
        for (int i = 0; i < this.chunks.length(); ++i) {
            MantleChunk chunk = this.chunks.get(i);
            if (chunk != null) {
                dos.writeBoolean(true);
                chunk.write(dos);
                continue;
            }
            dos.writeBoolean(false);
        }
    }

    public int getX() {
        return this.x;
    }

    public int getZ() {
        return this.z;
    }
}

