/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.util.arcane.spatial.parallel;

import com.googlecode.concurrentlinkedhashmap.ConcurrentLinkedHashMap;
import com.volmit.adapt.util.arcane.spatial.util.CompressedNumbers;
import com.volmit.adapt.util.arcane.spatial.util.Run;
import java.io.IOException;
import java.util.HashSet;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Supplier;

public class HyperLock {
    private final ConcurrentLinkedHashMap<Long, ReentrantLock> locks;
    private boolean enabled = true;
    private boolean fair = false;

    public HyperLock() {
        this(1024, false);
    }

    public void clear() {
        for (Long i : new HashSet(this.locks.keySet())) {
            if (((ReentrantLock)this.locks.get((Object)i)).isLocked()) continue;
            this.locks.remove((Object)i);
        }
    }

    public HyperLock(int capacity) {
        this(capacity, false);
    }

    public HyperLock(int capacity, boolean fair) {
        this.fair = fair;
        this.locks = new ConcurrentLinkedHashMap.Builder().initialCapacity(capacity).maximumWeightedCapacity((long)capacity).concurrencyLevel(32).build();
    }

    public void with(int x, int z, Runnable r) {
        this.lock(x, z);
        r.run();
        this.unlock(x, z);
    }

    public void withLong(long k, Runnable r) {
        this.lock(CompressedNumbers.i2a(k), CompressedNumbers.i2b(k));
        r.run();
        this.unlock(CompressedNumbers.i2a(k), CompressedNumbers.i2b(k));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void withNasty(int x, int z, Run.Throwable r) throws Throwable {
        this.lock(x, z);
        Throwable ee = null;
        try {
            r.run();
        }
        catch (Throwable e) {
            ee = e;
        }
        finally {
            this.unlock(x, z);
            if (ee != null) {
                throw ee;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void withIO(int x, int z, Run.IO r) throws IOException {
        block5: {
            this.lock(x, z);
            IOException ee = null;
            try {
                r.run();
            }
            catch (IOException e) {
                ee = e;
            }
            finally {
                this.unlock(x, z);
                if (ee == null) break block5;
                throw ee;
            }
        }
    }

    public <T> T withResult(int x, int z, Supplier<T> r) {
        this.lock(x, z);
        T t = r.get();
        this.unlock(x, z);
        return t;
    }

    public boolean tryLock(int x, int z) {
        return this.getLock(x, z).tryLock();
    }

    public boolean tryLock(int x, int z, long timeout) {
        try {
            return this.getLock(x, z).tryLock(timeout, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            return false;
        }
    }

    private ReentrantLock getLock(int x, int z) {
        return (ReentrantLock)this.locks.computeIfAbsent((Object)CompressedNumbers.i2(x, z), k -> new ReentrantLock(this.fair));
    }

    public void lock(int x, int z) {
        if (!this.enabled) {
            return;
        }
        this.getLock(x, z).lock();
    }

    public void unlock(int x, int z) {
        if (!this.enabled) {
            return;
        }
        this.getLock(x, z).unlock();
    }

    public void disable() {
        this.enabled = false;
    }
}

