/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.util.command;

import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import org.bukkit.Sound;
import org.bukkit.entity.Player;

public class SoundFeedback {
    private Sound sound;
    private float volume;
    private float pitch;

    public void play(Player p) {
        p.playSound(p.getLocation(), this.sound, this.volume, this.pitch);
    }

    private static float $default$volume() {
        return 1.0f;
    }

    private static float $default$pitch() {
        return 1.0f;
    }

    SoundFeedback(Sound sound, float volume, float pitch) {
        this.sound = sound;
        this.volume = volume;
        this.pitch = pitch;
    }

    public static SoundFeedbackBuilder builder() {
        return new SoundFeedbackBuilder();
    }

    public Sound sound() {
        return this.sound;
    }

    public float volume() {
        return this.volume;
    }

    public float pitch() {
        return this.pitch;
    }

    public SoundFeedback sound(Sound sound) {
        this.sound = sound;
        return this;
    }

    public SoundFeedback volume(float volume) {
        this.volume = volume;
        return this;
    }

    public SoundFeedback pitch(float pitch) {
        this.pitch = pitch;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SoundFeedback)) {
            return false;
        }
        SoundFeedback other = (SoundFeedback)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Float.compare(this.volume(), other.volume()) != 0) {
            return false;
        }
        if (Float.compare(this.pitch(), other.pitch()) != 0) {
            return false;
        }
        Sound this$sound = this.sound();
        Sound other$sound = other.sound();
        return !(this$sound == null ? other$sound != null : !this$sound.equals(other$sound));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SoundFeedback;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Float.floatToIntBits(this.volume());
        result = result * 59 + Float.floatToIntBits(this.pitch());
        Sound $sound = this.sound();
        result = result * 59 + ($sound == null ? 43 : $sound.hashCode());
        return result;
    }

    public String toString() {
        return "SoundFeedback(sound=" + this.sound() + ", volume=" + this.volume() + ", pitch=" + this.pitch() + ")";
    }

    static {
        IBootstrap.dasBoot();
    }

    public static class SoundFeedbackBuilder {
        private Sound sound;
        private boolean volume$set;
        private float volume$value;
        private boolean pitch$set;
        private float pitch$value;

        SoundFeedbackBuilder() {
        }

        public SoundFeedbackBuilder sound(Sound sound) {
            this.sound = sound;
            return this;
        }

        public SoundFeedbackBuilder volume(float volume) {
            this.volume$value = volume;
            this.volume$set = true;
            return this;
        }

        public SoundFeedbackBuilder pitch(float pitch) {
            this.pitch$value = pitch;
            this.pitch$set = true;
            return this;
        }

        public SoundFeedback build() {
            float volume$value = this.volume$value;
            if (!this.volume$set) {
                volume$value = SoundFeedback.$default$volume();
            }
            float pitch$value = this.pitch$value;
            if (!this.pitch$set) {
                pitch$value = SoundFeedback.$default$pitch();
            }
            return new SoundFeedback(this.sound, volume$value, pitch$value);
        }

        public String toString() {
            return "SoundFeedback.SoundFeedbackBuilder(sound=" + this.sound + ", volume$value=" + this.volume$value + ", pitch$value=" + this.pitch$value + ")";
        }

        static {
            IBootstrap.dasBoot();
        }
    }
}

