/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.util.extensions.java.lang.String;

import com.volmit.adapt.util.arcane.amulet.io.IO;
import com.volmit.adapt.util.manifold.ext.rt.api.Extension;
import com.volmit.adapt.util.manifold.ext.rt.api.This;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@Extension
public class XString {
    public static String upper(@This String s) {
        return s.toUpperCase(Locale.ROOT);
    }

    public static byte[] md5(@This String s) {
        return IO.hashMD5(s);
    }

    public static String fromBase64(@This String s) {
        return new String(Base64.getUrlDecoder().decode(s), StandardCharsets.UTF_8);
    }

    public static String toBase64String(@This String s) {
        return Base64.getUrlEncoder().encodeToString(s.getBytes(StandardCharsets.UTF_8));
    }

    public static byte[] toBase64(@This String s) {
        return Base64.getUrlEncoder().encode(s.getBytes(StandardCharsets.UTF_8));
    }

    public static byte[] sha1(@This String s) {
        return IO.hashSHA1(s);
    }

    public static byte[] sha512(@This String s) {
        return IO.hashSHA512(s);
    }

    public static byte[] sha384(@This String s) {
        return IO.hashSHA384(s);
    }

    public static byte[] sha256(@This String s) {
        return IO.hashSHA256(s);
    }

    public static byte[] hash(@This String s, String algo) {
        return IO.hash(s, algo);
    }

    public static String lower(@This String s) {
        return s.toLowerCase(Locale.ROOT);
    }

    public static double toDouble(@This String s) {
        return Double.parseDouble(s);
    }

    public static double toDouble(@This String s, double or) {
        try {
            return XString.toDouble(s);
        }
        catch (NumberFormatException e) {
            return or;
        }
    }

    public static int toInt(@This String s) {
        return Integer.parseInt(s);
    }

    public static int toInt(@This String s, int or) {
        try {
            return XString.toInt(s);
        }
        catch (NumberFormatException e) {
            return or;
        }
    }

    public static long toLong(@This String s) {
        return Long.parseLong(s);
    }

    public static long toLong(@This String s, long or) {
        try {
            return XString.toLong(s);
        }
        catch (NumberFormatException e) {
            return or;
        }
    }

    public static String replaceAbs(@This String s, String find, String replace) {
        return s.replaceAll("\\Q" + find + "\\E", replace);
    }

    public static String[] splitAbs(@This String s, String find) {
        return s.split("\\Q" + find + "\\E");
    }

    public static String remove(@This String s, String find) {
        return XString.replaceAbs(s, find, "");
    }

    public static boolean isNotEmpty(@This String s) {
        return !s.isEmpty();
    }

    public static String normalize(@This String s) {
        String buf = s;
        while (buf.contains("  ")) {
            buf = XString.replaceAbs(buf, "  ", " ");
        }
        return buf.trim();
    }

    public static String capitalize(@This String s) {
        StringBuilder roll = new StringBuilder();
        boolean f = true;
        char[] cArray = s.trim().toCharArray();
        int n = cArray.length;
        for (int i = 0; i < n; ++i) {
            Character i2 = Character.valueOf(cArray[i]);
            if (f) {
                roll.append(Character.toUpperCase(i2.charValue()));
                f = false;
                continue;
            }
            roll.append(i2);
        }
        return roll.toString();
    }

    public static String capitalizeWords(@This String s) {
        StringBuilder rollx = new StringBuilder();
        for (String i : s.trim().split(" ")) {
            rollx.append(" ").append(XString.capitalize(i.trim()));
        }
        return rollx.substring(1);
    }

    public static String wrap(@This String s, int len) {
        return XString.wrap(s, len, null, false);
    }

    public static String wrapWords(@This String s, int len) {
        return XString.wrap(s, len, null, true);
    }

    public static String wrap(@This String s, int len, String newLineSep, boolean soft) {
        return XString.wrap(s, len, newLineSep, soft, " ");
    }

    public static String wrap(@This String s, int len, String newLineSep, boolean soft, String regex) {
        if (s == null) {
            return null;
        }
        if (newLineSep == null) {
            newLineSep = "\n";
        }
        if (len < 1) {
            len = 1;
        }
        if (regex.trim().equals("")) {
            regex = " ";
        }
        Pattern arg4 = Pattern.compile(regex);
        int arg5 = s.length();
        int arg6 = 0;
        StringBuilder arg7 = new StringBuilder(arg5 + 32);
        while (arg6 < arg5) {
            int arg8 = -1;
            Matcher arg9 = arg4.matcher(s.substring(arg6, Math.min(arg6 + len + 1, arg5)));
            if (arg9.find()) {
                if (arg9.start() == 0) {
                    arg6 += arg9.end();
                    continue;
                }
                arg8 = arg9.start();
            }
            if (arg5 - arg6 <= len) break;
            while (arg9.find()) {
                arg8 = arg9.start() + arg6;
            }
            if (arg8 >= arg6) {
                arg7.append(s, arg6, arg8);
                arg7.append(newLineSep);
                arg6 = arg8 + 1;
                continue;
            }
            if (soft) {
                arg7.append(s, arg6, len + arg6);
                arg7.append(newLineSep);
                arg6 += len;
                continue;
            }
            arg9 = arg4.matcher(s.substring(arg6 + len));
            if (arg9.find()) {
                arg8 = arg9.start() + arg6 + len;
            }
            if (arg8 >= 0) {
                arg7.append(s, arg6, arg8);
                arg7.append(newLineSep);
                arg6 = arg8 + 1;
                continue;
            }
            arg7.append(s.substring(arg6));
            arg6 = arg5;
        }
        arg7.append(s.substring(arg6));
        return arg7.toString();
    }

    public static String elipse(@This String s, int l) {
        if (s.length() <= l) {
            return s;
        }
        return s.substring(0, l) + "...";
    }

    public static int fromRoman(@This String number) {
        if (number.isEmpty()) {
            return 0;
        }
        if ((number = number.toUpperCase()).startsWith("M")) {
            return 1000 + XString.fromRoman(number.substring(1));
        }
        if (number.startsWith("CM")) {
            return 900 + XString.fromRoman(number.substring(2));
        }
        if (number.startsWith("D")) {
            return 500 + XString.fromRoman(number.substring(1));
        }
        if (number.startsWith("CD")) {
            return 400 + XString.fromRoman(number.substring(2));
        }
        if (number.startsWith("C")) {
            return 100 + XString.fromRoman(number.substring(1));
        }
        if (number.startsWith("XC")) {
            return 90 + XString.fromRoman(number.substring(2));
        }
        if (number.startsWith("L")) {
            return 50 + XString.fromRoman(number.substring(1));
        }
        if (number.startsWith("XL")) {
            return 40 + XString.fromRoman(number.substring(2));
        }
        if (number.startsWith("X")) {
            return 10 + XString.fromRoman(number.substring(1));
        }
        if (number.startsWith("IX")) {
            return 9 + XString.fromRoman(number.substring(2));
        }
        if (number.startsWith("V")) {
            return 5 + XString.fromRoman(number.substring(1));
        }
        if (number.startsWith("IV")) {
            return 4 + XString.fromRoman(number.substring(2));
        }
        if (number.startsWith("I")) {
            return 1 + XString.fromRoman(number.substring(1));
        }
        return 0;
    }

    public static String scroll(@This String smx, int viewport, long time) {
        int len;
        int walk;
        String src = " ".repeat(viewport) + smx + " ".repeat(viewport);
        String base = src.substring(walk = (int)(time % (long)((len = src.length()) - viewport)), Math.min(walk + viewport, len - 1));
        base = base.length() < viewport ? base + " ".repeat(viewport - base.length() - 3) : base;
        return base;
    }

    static {
        IBootstrap.dasBoot();
    }
}

