/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.util.extensions.java.util.List;

import com.volmit.adapt.util.arcane.amulet.MagicalSugar;
import com.volmit.adapt.util.arcane.amulet.functional.Consume;
import com.volmit.adapt.util.extensions.java.util.Random.XRandom;
import com.volmit.adapt.util.extensions.java.util.stream.Stream.XStream;
import com.volmit.adapt.util.manifold.ext.rt.api.Extension;
import com.volmit.adapt.util.manifold.ext.rt.api.Self;
import com.volmit.adapt.util.manifold.ext.rt.api.This;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;

@Extension
public class XList {
    @Self
    public static <E> List<E> withoutDuplicates(@This List<E> self) {
        return XList.withoutDuplicates(self, ArrayList::new);
    }

    public static <E> E getRandom(@This List<E> self, Random r) {
        if (self.isEmpty()) {
            return null;
        }
        if (self.size() == 1) {
            return self.get(0);
        }
        return self.get(XRandom.i(r, 0, XList.last(self)));
    }

    public static <E> E getRandom(@This List<E> self) {
        return XList.getRandom(self, XRandom.r());
    }

    public static <E> boolean addIfMissing(@This List<E> self, E e) {
        if (!self.contains(e)) {
            self.add(e);
            return true;
        }
        return false;
    }

    @Self
    public static <E> List<E> where(@This List<E> self, Predicate<E> pred) {
        return XStream.where(self.stream(), pred).toList();
    }

    @Self
    public static <E> List<E> forceAdd(@This List<E> self, Object[] values) {
        for (Object i : values) {
            self.add(i);
        }
        return self;
    }

    @Self
    public static <E> List<E> forceAdd(@This List<E> self, int[] values) {
        int[] nArray = values;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            Integer i2 = nArray[i];
            self.add(i2);
        }
        return self;
    }

    @Self
    public static <E> List<E> forceAdd(@This List<E> self, double[] values) {
        double[] dArray = values;
        int n = dArray.length;
        for (int i = 0; i < n; ++i) {
            Double i2 = dArray[i];
            self.add(i2);
        }
        return self;
    }

    @Self
    public static <E> List<E> forceAdd(@This List<E> self, float[] values) {
        float[] fArray = values;
        int n = fArray.length;
        for (int i = 0; i < n; ++i) {
            Float i2 = Float.valueOf(fArray[i]);
            self.add(i2);
        }
        return self;
    }

    @Self
    public static <E> List<E> forceAdd(@This List<E> self, byte[] values) {
        byte[] byArray = values;
        int n = byArray.length;
        for (int i = 0; i < n; ++i) {
            Byte i2 = byArray[i];
            self.add(i2);
        }
        return self;
    }

    @Self
    public static <E> List<E> forceAdd(@This List<E> self, short[] values) {
        short[] sArray = values;
        int n = sArray.length;
        for (int i = 0; i < n; ++i) {
            Short i2 = sArray[i];
            self.add(i2);
        }
        return self;
    }

    @Self
    public static <E> List<E> forceAdd(@This List<E> self, long[] values) {
        long[] lArray = values;
        int n = lArray.length;
        for (int i = 0; i < n; ++i) {
            Long i2 = lArray[i];
            self.add(i2);
        }
        return self;
    }

    @Self
    public static <E> List<E> forceAdd(@This List<E> self, boolean[] values) {
        boolean[] blArray = values;
        int n = blArray.length;
        for (int i = 0; i < n; ++i) {
            Boolean i2 = blArray[i];
            self.add(i2);
        }
        return self;
    }

    @Self
    public static <E> List<E> sort(@This List<E> self) {
        self.sort(Comparator.comparing(Object::toString));
        return self;
    }

    @Self
    public static <E> List<E> withoutDuplicates(@This List<E> self, Supplier<List<E>> factory) {
        List<E> f = factory.get();
        f.addAll(new HashSet<E>(self));
        return f;
    }

    public static <E> E middleValue(@This List<E> self) {
        return self.get(XList.middleIndex(self));
    }

    public static <E> int middleIndex(@This List<E> self) {
        return self.size() % 2 == 0 ? self.size() / 2 : self.size() / 2 + 1;
    }

    @Self
    public static <E> List<E> forEachIndex(@This List<E> self, Consume.Two<List<E>, Integer> itr) {
        Iterator iterator = MagicalSugar.index.prefixBind(self).iterator();
        while (iterator.hasNext()) {
            int i = (Integer)iterator.next();
            itr.accept(self, i);
        }
        return self;
    }

    @Self
    public static <E> List<E> forEachReverseIndex(@This List<E> self, Consume.Two<List<E>, Integer> itr) {
        Iterator iterator = MagicalSugar.reverse.prefixBind(MagicalSugar.index.prefixBind(self)).iterator();
        while (iterator.hasNext()) {
            int i = (Integer)iterator.next();
            itr.accept(self, i);
        }
        return self;
    }

    @Self
    public static <E> List<E> evenValues(@This List<E> self) {
        ArrayList even = new ArrayList();
        Iterator iterator = MagicalSugar.reverse.prefixBind(MagicalSugar.index.prefixBind(self)).iterator();
        while (iterator.hasNext()) {
            int i = (Integer)iterator.next();
            if (i % 2 != 0) continue;
            XList.addFirst(even, self.remove(i));
        }
        return even;
    }

    @Self
    public static <E> List<E> oddValues(@This List<E> self) {
        ArrayList odd = new ArrayList();
        Iterator iterator = MagicalSugar.reverse.prefixBind(MagicalSugar.index.prefixBind(self)).iterator();
        while (iterator.hasNext()) {
            int i = (Integer)iterator.next();
            if (i % 2 == 0) continue;
            XList.addFirst(odd, self.remove(i));
        }
        return odd;
    }

    @Self
    public static <E> List<E> copy(@This List<E> self) {
        return XList.copy(self, ArrayList::new);
    }

    @Self
    public static <E> List<E> copyClear(@This List<E> self) {
        List<E> t = XList.copy(self);
        self.clear();
        return t;
    }

    @Self
    public static <E> List<E> unmodifiable(@This List<E> self) {
        return Collections.unmodifiableList(self);
    }

    @Self
    public static <E> List<E> copy(@This List<E> self, Supplier<List<E>> factory) {
        List<E> t = factory.get();
        t.addAll(self);
        return t;
    }

    public static <E> int last(@This List<E> self) {
        return self.size() - 1;
    }

    @Self
    public static <E> List<E> removeLast(@This List<E> self) {
        if (self.isEmpty()) {
            return self;
        }
        self.remove(XList.last(self));
        return self;
    }

    public static <E> boolean isNotEmpty(@This List<E> self) {
        return !self.isEmpty();
    }

    @SafeVarargs
    @Self
    public static <E> List<E> add(@This List<E> self, E ... o) {
        Collections.addAll(self, o);
        return self;
    }

    @SafeVarargs
    @Self
    public static <E> List<E> qadd(@This List<E> self, E ... o) {
        Collections.addAll(self, o);
        return self;
    }

    @Self
    public static <E> List<E> add(@This List<E> self, List<E> o) {
        self.addAll(o);
        return self;
    }

    @Self
    public static <E> List<E> addFirst(@This List<E> self, E o) {
        self.add(0, o);
        return self;
    }

    @SafeVarargs
    @Self
    public static <E> List<E> remove(@This List<E> self, E ... o) {
        for (E i : o) {
            self.remove(i);
        }
        return self;
    }

    @Self
    public static <E> List<E> remove(@This List<E> self, List<E> o) {
        for (E i : o) {
            self.remove(i);
        }
        return self;
    }

    @Self
    public static <E> List<E> swapIndexes(@This List<E> self, int a2, int b) {
        E aa = self.remove(a2);
        E bb = self.get(b);
        self.add(a2, bb);
        self.remove(b);
        self.add(b, aa);
        return self;
    }

    @Self
    public static <E> List<E> removeWhere(@This List<E> self, Predicate<E> predicate) {
        if (self.isEmpty()) {
            return self;
        }
        ArrayList<E> drop = new ArrayList<E>();
        Iterator iterator = MagicalSugar.reverse.prefixBind(MagicalSugar.index.prefixBind(self)).iterator();
        while (iterator.hasNext()) {
            int i = (Integer)iterator.next();
            if (!predicate.test(self.get(i))) continue;
            drop.add(self.get(i));
        }
        self.removeAll(drop);
        return self;
    }

    @Self
    public static <E> List<E> keepWhere(@This List<E> self, Predicate<E> predicate) {
        return XList.removeWhere(self, predicate.negate());
    }

    @Self
    public static <E, R> List<R> convert(@This List<E> self, Function<E, R> converter) {
        ArrayList<R> f = new ArrayList<R>();
        for (E i : self) {
            R r = converter.apply(i);
            if (r == null) continue;
            f.add(r);
        }
        return f;
    }

    public static <E> E pop(@This List<E> self) {
        if (self.isEmpty()) {
            return null;
        }
        return self.remove(0);
    }

    public static <E> E popLast(@This List<E> self) {
        if (self.isEmpty()) {
            return null;
        }
        return self.remove(XList.last(self));
    }

    @Extension
    public static <E> List<E> from(Collection<E> collection) {
        return XList.from(collection, ArrayList::new);
    }

    @Extension
    public static <E> CopyOnWriteArrayList<E> copyOnWrite() {
        return new CopyOnWriteArrayList();
    }

    @Extension
    public static <E> ArrayList<E> array() {
        return new ArrayList();
    }

    @Extension
    public static <E> LinkedList<E> linked() {
        return new LinkedList();
    }

    @Extension
    public static <E> List<E> from(Collection<E> collection, Supplier<List<E>> factory) {
        List<E> l = factory.get();
        l.addAll(collection);
        return l;
    }

    @SafeVarargs
    @Extension
    public static <E> List<E> from(E ... collection) {
        return XList.from(ArrayList::new, collection);
    }

    @SafeVarargs
    public static <E> List<E> from(Supplier<List<E>> factory, E ... collection) {
        List<E> l = factory.get();
        XList.add(l, collection);
        return l;
    }

    public static <E> E popRandom(@This List<E> self) {
        return XList.popRandom(self, XRandom.r());
    }

    public static <E> E popRandom(@This List<E> self, Random r) {
        if (self.isEmpty()) {
            return null;
        }
        return self.remove(XRandom.i(r, 0, XList.last(self)));
    }

    @Self
    public static <E> List<E> minus(@This List<E> self, E that) {
        List<E> s = XList.from(self);
        s.remove(that);
        return s;
    }

    @Self
    public static <E> List<E> minus(@This List<E> self, Collection<E> that) {
        List<E> s = XList.from(self);
        s.removeAll(that);
        return s;
    }

    @Self
    public static <E> List<E> reverse(@This List<E> self) {
        Collections.reverse(self);
        return self;
    }

    @Self
    public static <E> List<E> unaryMinus(@This List<E> self) {
        return XList.reverse(XList.from(self));
    }

    @Self
    public static <E> List<E> minus(@This List<E> self, List<E> that) {
        return XList.remove(XList.from(self), that);
    }

    public static <E> boolean hasIndex(@This List<E> self, int index) {
        return self.size() > index && index >= 0;
    }

    public static <E> String toString(@This List<E> self, String split) {
        if (self.isEmpty()) {
            return "";
        }
        if (self.size() == 1) {
            return "" + self.get(0);
        }
        StringBuilder b = new StringBuilder();
        for (E i : self) {
            b.append(split).append(i);
        }
        return b.substring(split.length());
    }

    static {
        IBootstrap.dasBoot();
    }
}

