/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.util.extensions.java.util.stream.Stream;

import com.volmit.adapt.util.arcane.amulet.functional.Function;
import com.volmit.adapt.util.extensions.java.util.List.XList;
import com.volmit.adapt.util.manifold.ext.rt.api.Extension;
import com.volmit.adapt.util.manifold.ext.rt.api.Self;
import com.volmit.adapt.util.manifold.ext.rt.api.This;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;

@Extension
public class XStream {
    public static <T, R> R splitInterlace(@This Stream<T> thiz, Function.Two<Stream<T>, Stream<T>, R> s) {
        List<T> f = thiz.toList();
        return s.apply(XList.evenValues(f).stream(), XList.oddValues(f).stream());
    }

    public static <T> Set<T> toSet(@This Stream<T> thiz) {
        return thiz.collect(Collectors.toSet());
    }

    public static <T> IntStream ints(@This Stream<T> thiz) {
        return thiz.mapToInt(i -> (Integer)i);
    }

    public static <T> DoubleStream doubles(@This Stream<T> thiz) {
        return thiz.mapToDouble(i -> (Double)i);
    }

    public static <T> LongStream longs(@This Stream<T> thiz) {
        return thiz.mapToLong(i -> (Long)i);
    }

    @Self
    public static <T> Stream<T> and(@This Stream<T> thiz, Stream<T> add) {
        return Stream.concat(thiz, add);
    }

    @Self
    public static <T> Stream<T> where(@This Stream<T> thiz, Predicate<T> pred) {
        return thiz.filter(pred);
    }

    @Self
    public static <T> Stream<T> without(@This Stream<T> thiz, Predicate<T> pred) {
        return thiz.filter(pred.negate());
    }

    @Self
    public static <T> Stream<T> and(@This Stream<T> thiz, T add) {
        return XStream.and(thiz, Stream.of(add));
    }

    @Self
    public static <T> Stream<T> plus(@This Stream<T> thiz, Stream<T> add) {
        return Stream.concat(thiz, add);
    }

    static {
        IBootstrap.dasBoot();
    }
}

