/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.util.manifold.util;

public class PrimitiveUtil {
    public static int getPriorityOf(Class to, Class from) {
        if (to == from) {
            return 0;
        }
        int infoLoss = PrimitiveUtil.losesInformation(from, to);
        boolean sameFamily = PrimitiveUtil.isInSameFamily(from, to);
        int iScore = 1;
        if (infoLoss > 1) {
            iScore += 24;
            if (!sameFamily) {
                ++iScore;
            }
        } else if (sameFamily) {
            if (from == Character.TYPE || from == Character.class) {
                from = Short.TYPE;
            }
            iScore += PrimitiveUtil.distance(from, to);
        } else {
            iScore += infoLoss;
            iScore += 4;
        }
        return iScore;
    }

    private static int distance(Class from, Class to) {
        int iDistance = PrimitiveUtil.getIndex(to) - PrimitiveUtil.getIndex(from);
        return iDistance >= 0 ? iDistance : 5;
    }

    public static int losesInformation(Class from, Class to) {
        int[][] tab = new int[][]{{0, 0, 0, 0, 0, 0, 0, 0}, {2, 0, 2, 2, 0, 0, 0, 1}, {2, 0, 0, 0, 0, 0, 0, 1}, {2, 2, 2, 0, 0, 0, 0, 1}, {2, 2, 2, 2, 0, 0, 0, 1}, {2, 2, 2, 2, 2, 0, 0, 1}, {2, 2, 2, 2, 2, 2, 0, 0}, {2, 2, 2, 2, 2, 2, 1, 0}};
        int i = PrimitiveUtil.getIndex(from);
        int j = PrimitiveUtil.getIndex(to);
        if (i == -1 || j == -1) {
            return 0;
        }
        return tab[i][j];
    }

    private static int getIndex(Class type) {
        if (type == Boolean.TYPE || type == Boolean.class) {
            return 0;
        }
        if (type == Character.TYPE || type == Character.class) {
            return 1;
        }
        if (type == Byte.TYPE || type == Byte.class) {
            return 2;
        }
        if (type == Short.TYPE || type == Short.class) {
            return 3;
        }
        if (type == Integer.TYPE || type == Integer.class) {
            return 4;
        }
        if (type == Long.TYPE || type == Long.class) {
            return 5;
        }
        if (type == Float.TYPE || type == Float.class) {
            return 6;
        }
        if (type == Double.TYPE || type == Double.class) {
            return 7;
        }
        return -1;
    }

    private static boolean isInSameFamily(Class t1, Class t2) {
        int indexT2;
        int indexT1 = PrimitiveUtil.getIndex(t1);
        return indexT1 == (indexT2 = PrimitiveUtil.getIndex(t2)) || indexT1 > 0 && indexT1 < 6 && indexT2 > 0 && indexT2 < 6 || indexT1 > 5 && indexT2 > 5;
    }

    public static boolean isBoxed(Class type) {
        return type == Boolean.class || type == Byte.class || type == Character.class || type == Double.class || type == Float.class || type == Integer.class || type == Long.class || type == Short.class || type == Void.class;
    }

    public static boolean isBoxedTypeFor(Class primitiveType, Class boxedType) {
        if (primitiveType != null && primitiveType.isPrimitive()) {
            if (primitiveType == Boolean.TYPE && boxedType == Boolean.class) {
                return true;
            }
            if (primitiveType == Character.TYPE && boxedType == Character.class) {
                return true;
            }
            if (primitiveType == Byte.TYPE && boxedType == Byte.class) {
                return true;
            }
            if (primitiveType == Short.TYPE && boxedType == Short.class) {
                return true;
            }
            if (primitiveType == Integer.TYPE && boxedType == Integer.class) {
                return true;
            }
            if (primitiveType == Long.TYPE && boxedType == Long.class) {
                return true;
            }
            if (primitiveType == Float.TYPE && boxedType == Float.class) {
                return true;
            }
            if (primitiveType == Double.TYPE && boxedType == Double.class) {
                return true;
            }
        }
        return false;
    }

    public static Class getPrimitiveType(Class boxedType) {
        if (boxedType == Boolean.class) {
            return Boolean.TYPE;
        }
        if (boxedType == Character.class) {
            return Character.TYPE;
        }
        if (boxedType == Byte.class) {
            return Byte.TYPE;
        }
        if (boxedType == Short.class) {
            return Short.TYPE;
        }
        if (boxedType == Integer.class) {
            return Integer.TYPE;
        }
        if (boxedType == Long.class) {
            return Long.TYPE;
        }
        if (boxedType == Float.class) {
            return Float.TYPE;
        }
        if (boxedType == Double.class) {
            return Double.TYPE;
        }
        return null;
    }

    public static Class getBoxedType(Class primitiveType) {
        if (primitiveType == Boolean.TYPE) {
            return Boolean.class;
        }
        if (primitiveType == Character.TYPE) {
            return Character.class;
        }
        if (primitiveType == Byte.TYPE) {
            return Byte.class;
        }
        if (primitiveType == Short.TYPE) {
            return Short.class;
        }
        if (primitiveType == Integer.TYPE) {
            return Integer.class;
        }
        if (primitiveType == Long.TYPE) {
            return Long.class;
        }
        if (primitiveType == Float.TYPE) {
            return Float.class;
        }
        if (primitiveType == Double.TYPE) {
            return Double.class;
        }
        return null;
    }

    public static boolean arePrimitiveTypesAssignable(Class toType, Class fromType) {
        if (toType == null || fromType == null || !toType.isPrimitive() || !fromType.isPrimitive()) {
            return false;
        }
        if (toType == fromType) {
            return true;
        }
        if (toType == Double.TYPE) {
            return fromType == Float.TYPE || fromType == Integer.TYPE || fromType == Character.TYPE || fromType == Short.TYPE || fromType == Byte.TYPE;
        }
        if (toType == Float.TYPE) {
            return fromType == Character.TYPE || fromType == Short.TYPE || fromType == Byte.TYPE;
        }
        if (toType == Long.TYPE) {
            return fromType == Integer.TYPE || fromType == Character.TYPE || fromType == Short.TYPE || fromType == Byte.TYPE;
        }
        if (toType == Integer.TYPE) {
            return fromType == Short.TYPE || fromType == Character.TYPE || fromType == Byte.TYPE;
        }
        if (toType == Short.TYPE) {
            return fromType == Byte.TYPE;
        }
        return false;
    }
}

