/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.util.manifold.util;

import com.volmit.adapt.util.manifold.util.concurrent.ConcurrentWeakHashMap;
import java.lang.reflect.Array;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class TypeAncestry {
    private static TypeAncestry INSTANCE;
    private final Map<Class, Set<Class>> _ancestry = new ConcurrentWeakHashMap<Class, Set<Class>>();

    public static TypeAncestry instance() {
        return INSTANCE == null ? (INSTANCE = new TypeAncestry()) : INSTANCE;
    }

    private TypeAncestry() {
    }

    public Set<Class> getTypesInAncestry(Class type) {
        return this._ancestry.computeIfAbsent(type, t -> {
            if (t.isArray()) {
                Set<Class> types = TypeAncestry.getAllClassesInClassHierarchyAsIntrinsicTypes(t);
                types.addAll(new HashSet<Class>(TypeAncestry.getArrayVersionsOfEachType(this.getTypesInAncestry(t.getComponentType()))));
                return Collections.unmodifiableSet(types);
            }
            Set<Class> types = TypeAncestry.getAllClassesInClassHierarchyAsIntrinsicTypes(t);
            return Collections.unmodifiableSet(types);
        });
    }

    public static Set<Class> getAllClassesInClassHierarchyAsIntrinsicTypes(Class type) {
        HashSet<Class> classSet = new HashSet<Class>();
        TypeAncestry.addAllClassesInClassHierarchy(type, classSet);
        classSet.add(Object.class);
        return classSet;
    }

    private static void addAllClassesInClassHierarchy(Class type, Set<Class> set) {
        Class<?>[] interfaces;
        if (!set.add(type)) {
            return;
        }
        for (Class<?> interfaceClass : interfaces = type.getInterfaces()) {
            TypeAncestry.addAllClassesInClassHierarchy(interfaceClass, set);
        }
        Class superClass = type.getSuperclass();
        if (superClass != null) {
            TypeAncestry.addAllClassesInClassHierarchy(superClass, set);
        }
    }

    public static Set<Class> getArrayVersionsOfEachType(Set<Class> componentTypes) {
        HashSet<Class> allTypes = new HashSet<Class>();
        allTypes.add(Object.class);
        for (Class type : componentTypes) {
            allTypes.add(Array.newInstance(type, 0).getClass());
        }
        return allTypes;
    }
}

