/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.util.manifold.util.concurrent;

import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class ConcurrentHashSet<K>
implements Set<K> {
    private final ConcurrentMap<K, Boolean> _map;

    public ConcurrentHashSet() {
        this._map = new ConcurrentHashMap<K, Boolean>();
    }

    public ConcurrentHashSet(int initialCapacity) {
        this._map = new ConcurrentHashMap<K, Boolean>(initialCapacity);
    }

    public ConcurrentHashSet(Set<K> set) {
        this._map = new ConcurrentHashMap<K, Boolean>(set.size());
        for (K value : set) {
            this._map.put(value, Boolean.TRUE);
        }
    }

    @Override
    public int size() {
        return this._map.size();
    }

    @Override
    public boolean isEmpty() {
        return this._map.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this._map.containsKey(o);
    }

    @Override
    public Iterator<K> iterator() {
        return this._map.keySet().iterator();
    }

    @Override
    public Object[] toArray() {
        return this._map.keySet().toArray();
    }

    @Override
    public <T> T[] toArray(T[] a2) {
        return this._map.keySet().toArray(a2);
    }

    @Override
    public boolean add(K o) {
        return this._map.putIfAbsent(o, Boolean.TRUE) == null;
    }

    @Override
    public boolean remove(Object o) {
        return this._map.keySet().remove(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this._map.keySet().containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends K> c) {
        boolean ret = false;
        for (K value : c) {
            ret |= this.add(value);
        }
        return ret;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this._map.keySet().retainAll(c);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this._map.keySet().removeAll(c);
    }

    @Override
    public void clear() {
        this._map.clear();
    }

    public String toString() {
        return this._map.keySet().toString();
    }
}

