/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt;

import com.google.gson.Gson;
import com.volmit.adapt.Adapt;
import com.volmit.adapt.api.xp.Curves;
import com.volmit.adapt.util.IO;
import com.volmit.adapt.util.JSONObject;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Material;

public class AdaptConfig {
    private static AdaptConfig config;
    public boolean debug = false;
    public boolean autoUpdateCheck = true;
    public boolean autoUpdateLanguage = true;
    public boolean splashScreen = true;
    public boolean xpInCreative = false;
    public boolean allowAdaptationsInCreative = false;
    public String adaptActivatorBlock = "BOOKSHELF";
    public String adaptActivatorBlockName = "a Bookshelf";
    public List<String> blacklistedWorlds = List.of("some_world_adapt_should_not_run_in", "anotherWorldFolderName");
    public int experienceMaxLevel = 1000;
    boolean preventHunterSkillsWhenHungerApplied = true;
    private ValueConfig value = new ValueConfig();
    private boolean metrics = true;
    private String language = "en_US";
    private String fallbackLanguageDontChangeUnlessYouKnowWhatYouAreDoing = "en_US";
    private Curves xpCurve = Curves.XL3L7;
    private double playerXpPerSkillLevelUpBase = 489.0;
    private double playerXpPerSkillLevelUpLevelMultiplier = 44.0;
    private double powerPerLevel = 0.73;
    private boolean hardcoreResetOnPlayerDeath = false;
    private boolean hardcoreNoRefunds = false;
    private boolean loginBonus = true;
    private boolean advancements = true;
    private boolean useSql = false;
    private boolean useEnchantmentTableParticleForActiveEffects = true;
    private boolean escClosesAllGuis = false;
    private boolean guiBackButton = false;
    private int learnUnlearnButtonDelayTicks = 14;
    private int maxRecipeListPrecaution = 25;
    private boolean actionbarNotifyXp = true;
    private boolean actionbarNotifyLevel = true;
    private boolean unlearnAllButton = false;
    private SqlSettings sql = new SqlSettings();
    private Protector protectorSupport = new Protector();
    private Map<String, Map<String, Boolean>> protectionOverrides = Map.of("adaptation-name", Map.of("WorldGuard", true));
    private boolean verbose = false;

    public static AdaptConfig get() {
        if (config == null) {
            AdaptConfig adaptConfig = new AdaptConfig();
            File file = Adapt.instance.getDataFile(new String[]{"adapt", "adapt.json"});
            if (!file.exists()) {
                try {
                    IO.writeAll(file, new JSONObject(new Gson().toJson((Object)adaptConfig)).toString(4));
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                    config = adaptConfig;
                    return adaptConfig;
                }
            }
            try {
                config = (AdaptConfig)new Gson().fromJson(IO.readAll(file), AdaptConfig.class);
                IO.writeAll(file, new JSONObject(new Gson().toJson((Object)config)).toString(4));
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                config = new AdaptConfig();
            }
        }
        return config;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public boolean isAutoUpdateCheck() {
        return this.autoUpdateCheck;
    }

    public boolean isAutoUpdateLanguage() {
        return this.autoUpdateLanguage;
    }

    public boolean isSplashScreen() {
        return this.splashScreen;
    }

    public boolean isXpInCreative() {
        return this.xpInCreative;
    }

    public boolean isAllowAdaptationsInCreative() {
        return this.allowAdaptationsInCreative;
    }

    public String getAdaptActivatorBlock() {
        return this.adaptActivatorBlock;
    }

    public String getAdaptActivatorBlockName() {
        return this.adaptActivatorBlockName;
    }

    public List<String> getBlacklistedWorlds() {
        return this.blacklistedWorlds;
    }

    public int getExperienceMaxLevel() {
        return this.experienceMaxLevel;
    }

    public boolean isPreventHunterSkillsWhenHungerApplied() {
        return this.preventHunterSkillsWhenHungerApplied;
    }

    public ValueConfig getValue() {
        return this.value;
    }

    public boolean isMetrics() {
        return this.metrics;
    }

    public String getLanguage() {
        return this.language;
    }

    public String getFallbackLanguageDontChangeUnlessYouKnowWhatYouAreDoing() {
        return this.fallbackLanguageDontChangeUnlessYouKnowWhatYouAreDoing;
    }

    public Curves getXpCurve() {
        return this.xpCurve;
    }

    public double getPlayerXpPerSkillLevelUpBase() {
        return this.playerXpPerSkillLevelUpBase;
    }

    public double getPlayerXpPerSkillLevelUpLevelMultiplier() {
        return this.playerXpPerSkillLevelUpLevelMultiplier;
    }

    public double getPowerPerLevel() {
        return this.powerPerLevel;
    }

    public boolean isHardcoreResetOnPlayerDeath() {
        return this.hardcoreResetOnPlayerDeath;
    }

    public boolean isHardcoreNoRefunds() {
        return this.hardcoreNoRefunds;
    }

    public boolean isLoginBonus() {
        return this.loginBonus;
    }

    public boolean isAdvancements() {
        return this.advancements;
    }

    public boolean isUseSql() {
        return this.useSql;
    }

    public boolean isUseEnchantmentTableParticleForActiveEffects() {
        return this.useEnchantmentTableParticleForActiveEffects;
    }

    public boolean isEscClosesAllGuis() {
        return this.escClosesAllGuis;
    }

    public boolean isGuiBackButton() {
        return this.guiBackButton;
    }

    public int getLearnUnlearnButtonDelayTicks() {
        return this.learnUnlearnButtonDelayTicks;
    }

    public int getMaxRecipeListPrecaution() {
        return this.maxRecipeListPrecaution;
    }

    public boolean isActionbarNotifyXp() {
        return this.actionbarNotifyXp;
    }

    public boolean isActionbarNotifyLevel() {
        return this.actionbarNotifyLevel;
    }

    public boolean isUnlearnAllButton() {
        return this.unlearnAllButton;
    }

    public SqlSettings getSql() {
        return this.sql;
    }

    public Protector getProtectorSupport() {
        return this.protectorSupport;
    }

    public Map<String, Map<String, Boolean>> getProtectionOverrides() {
        return this.protectionOverrides;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean bl) {
        this.verbose = bl;
    }

    static {
        IBootstrap.dasBoot();
        config = null;
    }

    public static class ValueConfig {
        private double baseValue = 1.0;
        private Map<String, Double> valueMutlipliers = this.defaultValueMultipliersOverrides();

        private Map<String, Double> defaultValueMultipliersOverrides() {
            HashMap<String, Double> hashMap = new HashMap<String, Double>();
            hashMap.put(Material.BLAZE_ROD.name(), 50.0);
            hashMap.put(Material.ENDER_PEARL.name(), 75.0);
            hashMap.put(Material.GHAST_TEAR.name(), 100.0);
            hashMap.put(Material.LEATHER.name(), 1.5);
            hashMap.put(Material.BEEF.name(), 1.125);
            hashMap.put(Material.PORKCHOP.name(), 1.125);
            hashMap.put(Material.EGG.name(), 1.335);
            hashMap.put(Material.CHICKEN.name(), 1.13);
            hashMap.put(Material.MUTTON.name(), 1.125);
            hashMap.put(Material.WHEAT.name(), 1.25);
            hashMap.put(Material.BEETROOT.name(), 1.25);
            hashMap.put(Material.CARROT.name(), 1.25);
            hashMap.put(Material.FLINT.name(), 1.35);
            hashMap.put(Material.IRON_ORE.name(), 1.75);
            hashMap.put(Material.DIAMOND_ORE.name(), 5.0);
            hashMap.put(Material.GOLD_ORE.name(), 4.0);
            hashMap.put(Material.LAPIS_ORE.name(), 3.5);
            hashMap.put(Material.COAL_ORE.name(), 1.35);
            hashMap.put(Material.REDSTONE_ORE.name(), 4.5);
            hashMap.put(Material.NETHER_GOLD_ORE.name(), 4.5);
            hashMap.put(Material.NETHER_QUARTZ_ORE.name(), 1.11);
            return hashMap;
        }

        public double getBaseValue() {
            return this.baseValue;
        }

        public Map<String, Double> getValueMutlipliers() {
            return this.valueMutlipliers;
        }

        static {
            IBootstrap.dasBoot();
        }
    }

    public static class SqlSettings {
        private String host = "localhost";
        private int port = 1337;
        private String database = "adapt";
        private String username = "user";
        private String password = "password";

        public String getHost() {
            return this.host;
        }

        public int getPort() {
            return this.port;
        }

        public String getDatabase() {
            return this.database;
        }

        public String getUsername() {
            return this.username;
        }

        public String getPassword() {
            return this.password;
        }

        static {
            IBootstrap.dasBoot();
        }
    }

    public static class Protector {
        private boolean worldguard = true;
        private boolean factionsClaim = false;
        private boolean residence = true;
        private boolean chestProtect = true;

        public boolean isWorldguard() {
            return this.worldguard;
        }

        public boolean isFactionsClaim() {
            return this.factionsClaim;
        }

        public boolean isResidence() {
            return this.residence;
        }

        public boolean isChestProtect() {
            return this.chestProtect;
        }

        static {
            IBootstrap.dasBoot();
        }
    }
}

