/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.api.advancement;

import com.volmit.adapt.util.advancements.NameKey;
import com.volmit.adapt.util.advancements.advancement.Advancement;
import com.volmit.adapt.util.advancements.advancement.AdvancementDisplay;
import com.volmit.adapt.util.advancements.advancement.AdvancementFlag;
import com.volmit.adapt.util.advancements.advancement.AdvancementVisibility;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.bukkit.Material;

public class AdaptAdvancement {
    private String background;
    private Material icon;
    private String title;
    private String description;
    private AdvancementDisplay.AdvancementFrame frame;
    private boolean toast;
    private boolean announce;
    private AdvancementVisibility visibility;
    private String key;
    private List<AdaptAdvancement> children;

    public Advancement toAdvancement() {
        return this.toAdvancement(null, 0, 0);
    }

    public Advancement toAdvancement(Advancement advancement, int n, int n2) {
        if (this.children == null) {
            this.children = new ArrayList<AdaptAdvancement>();
        }
        AdvancementDisplay advancementDisplay = new AdvancementDisplay(this.getIcon(), this.getTitle(), this.getDescription(), this.getFrame(), this.getVisibility());
        if (this.background != null) {
            advancementDisplay.setBackgroundTexture(this.getBackground());
        }
        advancementDisplay.setX(1.0f + (float)n2);
        advancementDisplay.setY(1.0f + (float)n);
        return new Advancement(advancement, new NameKey("adapt", this.getKey()), advancementDisplay, new AdvancementFlag[0]);
    }

    public List<Advancement> toAdvancements() {
        return this.toAdvancements(null, 0, 0);
    }

    public List<Advancement> toAdvancements(Advancement advancement, int n, int n2) {
        ArrayList<Advancement> arrayList = new ArrayList<Advancement>();
        Advancement advancement2 = this.toAdvancement(advancement, n, n2);
        boolean bl = false;
        if (this.children != null && !this.children.isEmpty()) {
            for (AdaptAdvancement adaptAdvancement : this.children) {
                arrayList.addAll(adaptAdvancement.toAdvancements(advancement2, arrayList.size(), n2 + 1));
            }
        }
        arrayList.add(advancement2);
        return arrayList;
    }

    private static Material $default$icon() {
        return Material.EMERALD;
    }

    private static String $default$title() {
        return "MISSING TITLE";
    }

    private static String $default$description() {
        return "MISSING DESCRIPTION";
    }

    private static AdvancementDisplay.AdvancementFrame $default$frame() {
        return AdvancementDisplay.AdvancementFrame.TASK;
    }

    private static boolean $default$toast() {
        return false;
    }

    private static boolean $default$announce() {
        return false;
    }

    private static AdvancementVisibility $default$visibility() {
        return AdvancementVisibility.PARENT_GRANTED;
    }

    private static String $default$key() {
        return "root";
    }

    AdaptAdvancement(String string, Material material, String string2, String string3, AdvancementDisplay.AdvancementFrame advancementFrame, boolean bl, boolean bl2, AdvancementVisibility advancementVisibility, String string4, List<AdaptAdvancement> list) {
        this.background = string;
        this.icon = material;
        this.title = string2;
        this.description = string3;
        this.frame = advancementFrame;
        this.toast = bl;
        this.announce = bl2;
        this.visibility = advancementVisibility;
        this.key = string4;
        this.children = list;
    }

    public static AdaptAdvancementBuilder builder() {
        return new AdaptAdvancementBuilder();
    }

    public String getBackground() {
        return this.background;
    }

    public Material getIcon() {
        return this.icon;
    }

    public String getTitle() {
        return this.title;
    }

    public String getDescription() {
        return this.description;
    }

    public AdvancementDisplay.AdvancementFrame getFrame() {
        return this.frame;
    }

    public boolean isToast() {
        return this.toast;
    }

    public boolean isAnnounce() {
        return this.announce;
    }

    public AdvancementVisibility getVisibility() {
        return this.visibility;
    }

    public String getKey() {
        return this.key;
    }

    public List<AdaptAdvancement> getChildren() {
        return this.children;
    }

    public void setBackground(String string) {
        this.background = string;
    }

    public void setIcon(Material material) {
        this.icon = material;
    }

    public void setTitle(String string) {
        this.title = string;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public void setFrame(AdvancementDisplay.AdvancementFrame advancementFrame) {
        this.frame = advancementFrame;
    }

    public void setToast(boolean bl) {
        this.toast = bl;
    }

    public void setAnnounce(boolean bl) {
        this.announce = bl;
    }

    public void setVisibility(AdvancementVisibility advancementVisibility) {
        this.visibility = advancementVisibility;
    }

    public void setKey(String string) {
        this.key = string;
    }

    public void setChildren(List<AdaptAdvancement> list) {
        this.children = list;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof AdaptAdvancement)) {
            return false;
        }
        AdaptAdvancement adaptAdvancement = (AdaptAdvancement)object;
        if (!adaptAdvancement.canEqual(this)) {
            return false;
        }
        if (this.isToast() != adaptAdvancement.isToast()) {
            return false;
        }
        if (this.isAnnounce() != adaptAdvancement.isAnnounce()) {
            return false;
        }
        String string = this.getBackground();
        String string2 = adaptAdvancement.getBackground();
        if (string == null ? string2 != null : !string.equals(string2)) {
            return false;
        }
        Material material = this.getIcon();
        Material material2 = adaptAdvancement.getIcon();
        if (material == null ? material2 != null : !material.equals(material2)) {
            return false;
        }
        String string3 = this.getTitle();
        String string4 = adaptAdvancement.getTitle();
        if (string3 == null ? string4 != null : !string3.equals(string4)) {
            return false;
        }
        String string5 = this.getDescription();
        String string6 = adaptAdvancement.getDescription();
        if (string5 == null ? string6 != null : !string5.equals(string6)) {
            return false;
        }
        AdvancementDisplay.AdvancementFrame advancementFrame = this.getFrame();
        AdvancementDisplay.AdvancementFrame advancementFrame2 = adaptAdvancement.getFrame();
        if (advancementFrame == null ? advancementFrame2 != null : !((Object)((Object)advancementFrame)).equals((Object)advancementFrame2)) {
            return false;
        }
        AdvancementVisibility advancementVisibility = this.getVisibility();
        AdvancementVisibility advancementVisibility2 = adaptAdvancement.getVisibility();
        if (advancementVisibility == null ? advancementVisibility2 != null : !advancementVisibility.equals(advancementVisibility2)) {
            return false;
        }
        String string7 = this.getKey();
        String string8 = adaptAdvancement.getKey();
        if (string7 == null ? string8 != null : !string7.equals(string8)) {
            return false;
        }
        List<AdaptAdvancement> list = this.getChildren();
        List<AdaptAdvancement> list2 = adaptAdvancement.getChildren();
        return !(list == null ? list2 != null : !((Object)list).equals(list2));
    }

    protected boolean canEqual(Object object) {
        return object instanceof AdaptAdvancement;
    }

    public int hashCode() {
        int n = 59;
        int n2 = 1;
        n2 = n2 * 59 + (this.isToast() ? 79 : 97);
        n2 = n2 * 59 + (this.isAnnounce() ? 79 : 97);
        String string = this.getBackground();
        n2 = n2 * 59 + (string == null ? 43 : string.hashCode());
        Material material = this.getIcon();
        n2 = n2 * 59 + (material == null ? 43 : material.hashCode());
        String string2 = this.getTitle();
        n2 = n2 * 59 + (string2 == null ? 43 : string2.hashCode());
        String string3 = this.getDescription();
        n2 = n2 * 59 + (string3 == null ? 43 : string3.hashCode());
        AdvancementDisplay.AdvancementFrame advancementFrame = this.getFrame();
        n2 = n2 * 59 + (advancementFrame == null ? 43 : ((Object)((Object)advancementFrame)).hashCode());
        AdvancementVisibility advancementVisibility = this.getVisibility();
        n2 = n2 * 59 + (advancementVisibility == null ? 43 : advancementVisibility.hashCode());
        String string4 = this.getKey();
        n2 = n2 * 59 + (string4 == null ? 43 : string4.hashCode());
        List<AdaptAdvancement> list = this.getChildren();
        n2 = n2 * 59 + (list == null ? 43 : ((Object)list).hashCode());
        return n2;
    }

    public String toString() {
        return "AdaptAdvancement(background=" + this.getBackground() + ", icon=" + this.getIcon() + ", title=" + this.getTitle() + ", description=" + this.getDescription() + ", frame=" + this.getFrame() + ", toast=" + this.isToast() + ", announce=" + this.isAnnounce() + ", visibility=" + this.getVisibility() + ", key=" + this.getKey() + ", children=" + this.getChildren() + ")";
    }

    static {
        IBootstrap.dasBoot();
    }

    public static class AdaptAdvancementBuilder {
        private String background;
        private boolean icon$set;
        private Material icon$value;
        private boolean title$set;
        private String title$value;
        private boolean description$set;
        private String description$value;
        private boolean frame$set;
        private AdvancementDisplay.AdvancementFrame frame$value;
        private boolean toast$set;
        private boolean toast$value;
        private boolean announce$set;
        private boolean announce$value;
        private boolean visibility$set;
        private AdvancementVisibility visibility$value;
        private boolean key$set;
        private String key$value;
        private ArrayList<AdaptAdvancement> children;

        AdaptAdvancementBuilder() {
        }

        public AdaptAdvancementBuilder background(String string) {
            this.background = string;
            return this;
        }

        public AdaptAdvancementBuilder icon(Material material) {
            this.icon$value = material;
            this.icon$set = true;
            return this;
        }

        public AdaptAdvancementBuilder title(String string) {
            this.title$value = string;
            this.title$set = true;
            return this;
        }

        public AdaptAdvancementBuilder description(String string) {
            this.description$value = string;
            this.description$set = true;
            return this;
        }

        public AdaptAdvancementBuilder frame(AdvancementDisplay.AdvancementFrame advancementFrame) {
            this.frame$value = advancementFrame;
            this.frame$set = true;
            return this;
        }

        public AdaptAdvancementBuilder toast(boolean bl) {
            this.toast$value = bl;
            this.toast$set = true;
            return this;
        }

        public AdaptAdvancementBuilder announce(boolean bl) {
            this.announce$value = bl;
            this.announce$set = true;
            return this;
        }

        public AdaptAdvancementBuilder visibility(AdvancementVisibility advancementVisibility) {
            this.visibility$value = advancementVisibility;
            this.visibility$set = true;
            return this;
        }

        public AdaptAdvancementBuilder key(String string) {
            this.key$value = string;
            this.key$set = true;
            return this;
        }

        public AdaptAdvancementBuilder child(AdaptAdvancement adaptAdvancement) {
            if (this.children == null) {
                this.children = new ArrayList();
            }
            this.children.add(adaptAdvancement);
            return this;
        }

        public AdaptAdvancementBuilder children(Collection<? extends AdaptAdvancement> collection) {
            if (collection == null) {
                throw new NullPointerException("children cannot be null");
            }
            if (this.children == null) {
                this.children = new ArrayList();
            }
            this.children.addAll(collection);
            return this;
        }

        public AdaptAdvancementBuilder clearChildren() {
            if (this.children != null) {
                this.children.clear();
            }
            return this;
        }

        public AdaptAdvancement build() {
            List<AdaptAdvancement> list = switch (this.children == null ? 0 : this.children.size()) {
                case 0 -> Collections.emptyList();
                case 1 -> Collections.singletonList(this.children.get(0));
                default -> Collections.unmodifiableList(new ArrayList<AdaptAdvancement>(this.children));
            };
            Material material = this.icon$value;
            if (!this.icon$set) {
                material = AdaptAdvancement.$default$icon();
            }
            String string = this.title$value;
            if (!this.title$set) {
                string = AdaptAdvancement.$default$title();
            }
            String string2 = this.description$value;
            if (!this.description$set) {
                string2 = AdaptAdvancement.$default$description();
            }
            AdvancementDisplay.AdvancementFrame advancementFrame = this.frame$value;
            if (!this.frame$set) {
                advancementFrame = AdaptAdvancement.$default$frame();
            }
            boolean bl = this.toast$value;
            if (!this.toast$set) {
                bl = AdaptAdvancement.$default$toast();
            }
            boolean bl2 = this.announce$value;
            if (!this.announce$set) {
                bl2 = AdaptAdvancement.$default$announce();
            }
            AdvancementVisibility advancementVisibility = this.visibility$value;
            if (!this.visibility$set) {
                advancementVisibility = AdaptAdvancement.$default$visibility();
            }
            String string3 = this.key$value;
            if (!this.key$set) {
                string3 = AdaptAdvancement.$default$key();
            }
            return new AdaptAdvancement(this.background, material, string, string2, advancementFrame, bl, bl2, advancementVisibility, string3, list);
        }

        public String toString() {
            return "AdaptAdvancement.AdaptAdvancementBuilder(background=" + this.background + ", icon$value=" + this.icon$value + ", title$value=" + this.title$value + ", description$value=" + this.description$value + ", frame$value=" + this.frame$value + ", toast$value=" + this.toast$value + ", announce$value=" + this.announce$value + ", visibility$value=" + this.visibility$value + ", key$value=" + this.key$value + ", children=" + this.children + ")";
        }

        static {
            IBootstrap.dasBoot();
        }
    }
}

