/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.api.tick;

import com.volmit.adapt.api.tick.Ticked;
import com.volmit.adapt.util.BurstExecutor;
import com.volmit.adapt.util.J;
import com.volmit.adapt.util.MultiBurst;
import com.volmit.adapt.util.extensions.java.util.List.XList;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

public class Ticker {
    private final List<Ticked> ticklist = new ArrayList<Ticked>(4096);
    private final List<Ticked> newTicks = new ArrayList<Ticked>(128);
    private final List<String> removeTicks = new ArrayList<String>(128);
    private volatile boolean ticking = false;

    public Ticker() {
        J.ar(() -> {
            if (!this.ticking) {
                this.tick();
            }
        }, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(Ticked ticked) {
        List<Ticked> list = this.newTicks;
        synchronized (list) {
            this.newTicks.add(ticked);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregister(Ticked ticked) {
        List<String> list = this.removeTicks;
        synchronized (list) {
            this.removeTicks.add(ticked.getId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        List<Object> list = this.ticklist;
        synchronized (list) {
            this.ticklist.clear();
        }
        list = this.removeTicks;
        synchronized (list) {
            this.removeTicks.clear();
        }
        list = this.newTicks;
        synchronized (list) {
            this.newTicks.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tick() {
        this.ticking = true;
        AtomicInteger atomicInteger = new AtomicInteger(0);
        BurstExecutor burstExecutor = MultiBurst.burst.burst(this.ticklist.size());
        int n = 0;
        while (n < this.ticklist.size()) {
            int n2 = n++;
            burstExecutor.queue(() -> {
                Ticked ticked = this.ticklist.get(n2);
                if (ticked != null && ticked.shouldTick()) {
                    atomicInteger.incrementAndGet();
                    try {
                        ticked.tick();
                    }
                    catch (Throwable throwable) {
                        throwable.printStackTrace();
                    }
                }
            });
        }
        burstExecutor.complete();
        List<Object> list = this.newTicks;
        synchronized (list) {
            while (XList.isNotEmpty(this.newTicks)) {
                atomicInteger.incrementAndGet();
                this.ticklist.add(XList.popRandom(this.newTicks));
            }
        }
        list = this.removeTicks;
        synchronized (list) {
            block8: while (XList.isNotEmpty(this.removeTicks)) {
                atomicInteger.incrementAndGet();
                String string = XList.popRandom(this.removeTicks);
                for (int i = 0; i < this.ticklist.size(); ++i) {
                    if (!this.ticklist.get(i).getId().equals(string)) continue;
                    this.ticklist.remove(i);
                    continue block8;
                }
            }
        }
        this.ticking = false;
        atomicInteger.get();
    }

    static {
        IBootstrap.dasBoot();
    }
}

