/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.content.adaptation.agility;

import com.volmit.adapt.api.adaptation.SimpleAdaptation;
import com.volmit.adapt.util.C;
import com.volmit.adapt.util.Element;
import com.volmit.adapt.util.Form;
import com.volmit.adapt.util.Localizer;
import com.volmit.adapt.util.M;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerToggleSneakEvent;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.util.Vector;

public class AgilitySuperJump
extends SimpleAdaptation<Config> {
    private final Map<Player, Long> lastJump;

    public AgilitySuperJump() {
        super("agility-super-jump");
        this.registerConfiguration(Config.class);
        this.setDescription(Localizer.dLocalize("agility", "superjump", "description"));
        this.setDisplayName(Localizer.dLocalize("agility", "superjump", "name"));
        this.setIcon(Material.LEATHER_BOOTS);
        this.setBaseCost(((Config)this.getConfig()).baseCost);
        this.setCostFactor(((Config)this.getConfig()).costFactor);
        this.setMaxLevel(((Config)this.getConfig()).maxLevel);
        this.setInitialCost(((Config)this.getConfig()).initialCost);
        this.setInterval(9999L);
        this.lastJump = new HashMap<Player, Long>();
    }

    private double getJumpHeight(int n) {
        return ((Config)this.getConfig()).baseJumpMultiplier + ((Config)this.getConfig()).jumpLevelMultiplier * (double)n;
    }

    @Override
    public void addStats(int n, Element element) {
        element.addLore(C.GREEN + "+ " + Form.pc(this.getJumpHeight(n), 0) + C.GRAY + " " + Localizer.dLocalize("agility", "superjump", "lore1"));
        element.addLore(C.LIGHT_PURPLE + " " + Localizer.dLocalize("agility", "superjump", "lore2"));
    }

    @EventHandler
    public void on(PlayerToggleSneakEvent playerToggleSneakEvent) {
        if (playerToggleSneakEvent.isCancelled()) {
            return;
        }
        Player player = playerToggleSneakEvent.getPlayer();
        if (!this.hasAdaptation(player)) {
            return;
        }
        if (playerToggleSneakEvent.isSneaking() && player.isOnGround()) {
            player.playSound(player.getLocation(), Sound.ITEM_ARMOR_EQUIP_LEATHER, 0.3f, 0.35f);
        }
    }

    @EventHandler
    public void on(PlayerQuitEvent playerQuitEvent) {
        Player player = playerQuitEvent.getPlayer();
        this.lastJump.remove(player);
    }

    @EventHandler
    public void on(PlayerMoveEvent playerMoveEvent) {
        Vector vector;
        if (playerMoveEvent.isCancelled()) {
            return;
        }
        Player player = playerMoveEvent.getPlayer();
        if (player.isSwimming() || player.isFlying() || player.isGliding() || player.isSprinting()) {
            return;
        }
        if (player.isSneaking() && this.hasAdaptation(player) && this.canUse(this.getPlayer(player)) && (vector = player.getVelocity()).getY() > 0.0) {
            double d = 0.4;
            PotionEffect potionEffect = player.getPotionEffect(PotionEffectType.JUMP);
            if (potionEffect != null) {
                d += (double)((float)potionEffect.getAmplifier() + 1.0f) * (double)0.1f;
            }
            if (this.lastJump.get(player) != null && M.ms() - this.lastJump.get(player) < 1000L) {
                return;
            }
            if (this.lastJump.get(player) != null && M.ms() - this.lastJump.get(player) > 1500L) {
                this.lastJump.remove(player);
            }
            if (player.getLocation().getBlock().getType() != Material.LADDER && vector.getY() > d && player.isOnline()) {
                player.getWorld().playSound(player.getLocation(), Sound.ITEM_ARMOR_EQUIP_LEATHER, 1.25f, 0.7f);
                player.getWorld().playSound(player.getLocation(), Sound.ITEM_ARMOR_EQUIP_LEATHER, 1.25f, 1.7f);
                if (((Config)this.getConfig()).showParticles) {
                    player.getWorld().spawnParticle(Particle.BLOCK_CRACK, player.getLocation().clone().add(0.0, 0.3, 0.0), 15, 0.1, 0.8, 0.1, 0.1, (Object)player.getLocation().getBlock().getRelative(BlockFace.DOWN).getBlockData());
                }
                player.setVelocity(player.getVelocity().setY(this.getJumpHeight(this.getLevel(player))));
                this.lastJump.put(player, M.ms());
            }
        }
    }

    @Override
    public void onTick() {
    }

    @Override
    public boolean isEnabled() {
        return ((Config)this.getConfig()).enabled;
    }

    @Override
    public boolean isPermanent() {
        return ((Config)this.getConfig()).permanent;
    }

    static {
        IBootstrap.dasBoot();
    }

    protected static class Config {
        boolean permanent = false;
        boolean enabled = true;
        boolean showParticles = true;
        int baseCost = 2;
        double costFactor = 0.55;
        int maxLevel = 3;
        int initialCost = 5;
        double baseJumpMultiplier = 0.23;
        double jumpLevelMultiplier = 0.23;

        static {
            IBootstrap.dasBoot();
        }
    }
}

