/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.content.adaptation.axe;

import com.volmit.adapt.api.adaptation.SimpleAdaptation;
import com.volmit.adapt.util.C;
import com.volmit.adapt.util.Element;
import com.volmit.adapt.util.Form;
import com.volmit.adapt.util.Impulse;
import com.volmit.adapt.util.Localizer;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.SoundCategory;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.entity.EntityDamageByEntityEvent;

public class AxeGroundSmash
extends SimpleAdaptation<Config> {
    private final List<Integer> holds = new ArrayList<Integer>();

    public AxeGroundSmash() {
        super("axe-ground-smash");
        this.registerConfiguration(Config.class);
        this.setDescription(Localizer.dLocalize("axe", "groundsmash", "description"));
        this.setDisplayName(Localizer.dLocalize("axe", "groundsmash", "name"));
        this.setIcon(Material.NETHERITE_AXE);
        this.setBaseCost(((Config)this.getConfig()).baseCost);
        this.setCostFactor(((Config)this.getConfig()).costFactor);
        this.setMaxLevel(((Config)this.getConfig()).maxLevel);
        this.setInitialCost(((Config)this.getConfig()).initialCost);
        this.setInterval(4333L);
    }

    @Override
    public void addStats(int n, Element element) {
        double d = this.getLevelPercent(n);
        element.addLore(C.RED + "+ " + Form.f(this.getFalloffDamage(d), 1) + " - " + Form.f(this.getDamage(d), 1) + C.GRAY + " " + Localizer.dLocalize("axe", "groundsmash", "lore1"));
        element.addLore(C.RED + "+ " + Form.f(this.getRadius(d), 1) + C.GRAY + " " + Localizer.dLocalize("axe", "groundsmash", "lore2"));
        element.addLore(C.RED + "+ " + Form.pc(this.getForce(d), 0) + C.GRAY + " " + Localizer.dLocalize("axe", "groundsmash", "lore3"));
        element.addLore(C.YELLOW + "* " + Form.duration((double)this.getCooldownTime(this.getLevelPercent(n)) * 50.0, 1) + C.GRAY + " " + Localizer.dLocalize("axe", "groundsmash", "lore4"));
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void on(EntityDamageByEntityEvent entityDamageByEntityEvent) {
        Player player;
        if (entityDamageByEntityEvent.isCancelled()) {
            return;
        }
        Entity entity = entityDamageByEntityEvent.getDamager();
        if (entity instanceof Player && this.hasAdaptation(player = (Player)entity) && player.isSneaking()) {
            if (!this.isAxe(player.getInventory().getItemInMainHand())) {
                return;
            }
            double d = this.getLevelPercent(player);
            if (player.hasCooldown(player.getInventory().getItemInMainHand().getType())) {
                return;
            }
            player.setCooldown(player.getInventory().getItemInMainHand().getType(), this.getCooldownTime(d));
            new Impulse(this.getRadius(d)).damage(this.getDamage(d), this.getFalloffDamage(d)).force(this.getForce(d)).punch(entityDamageByEntityEvent.getEntity().getLocation());
            entityDamageByEntityEvent.getEntity().getWorld().playSound(entityDamageByEntityEvent.getEntity().getLocation(), Sound.ENTITY_ZOMBIE_ATTACK_IRON_DOOR, SoundCategory.HOSTILE, 0.6f, 0.4f);
            entityDamageByEntityEvent.getEntity().getWorld().playSound(entityDamageByEntityEvent.getEntity().getLocation(), Sound.ENTITY_ZOMBIE_ATTACK_IRON_DOOR, SoundCategory.HOSTILE, 0.5f, 0.1f);
            entityDamageByEntityEvent.getEntity().getWorld().playSound(entityDamageByEntityEvent.getEntity().getLocation(), Sound.ENTITY_TURTLE_EGG_CRACK, SoundCategory.HOSTILE, 1.0f, 0.4f);
        }
    }

    public int getCooldownTime(double d) {
        return (int)((1.0 - d) * ((Config)this.getConfig()).cooldownTicksInverseLevelMultiplier + ((Config)this.getConfig()).cooldownTicksBase);
    }

    public double getRadius(double d) {
        return ((Config)this.getConfig()).radiusLevelFactorMultiplier * d;
    }

    public double getDamage(double d) {
        return ((Config)this.getConfig()).damageLevelFactorMultiplier * d;
    }

    public double getForce(double d) {
        return ((Config)this.getConfig()).forceFactorMultiplier * d + ((Config)this.getConfig()).forceBase;
    }

    public double getFalloffDamage(double d) {
        return ((Config)this.getConfig()).falloffFactor * d;
    }

    @Override
    public void onTick() {
    }

    @Override
    public boolean isEnabled() {
        return ((Config)this.getConfig()).enabled;
    }

    @Override
    public boolean isPermanent() {
        return ((Config)this.getConfig()).permanent;
    }

    static {
        IBootstrap.dasBoot();
    }

    protected static class Config {
        boolean permanent = false;
        boolean enabled = true;
        int baseCost = 6;
        double costFactor = 0.75;
        int maxLevel = 5;
        int initialCost = 8;
        double falloffFactor = 3.0;
        double radiusLevelFactorMultiplier = 8.0;
        double damageLevelFactorMultiplier = 8.0;
        double forceFactorMultiplier = 1.15;
        double forceBase = 0.27;
        double cooldownTicksBase = 80.0;
        double cooldownTicksInverseLevelMultiplier = 225.0;

        static {
            IBootstrap.dasBoot();
        }
    }
}

