/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.content.adaptation.crafting;

import com.volmit.adapt.api.adaptation.SimpleAdaptation;
import com.volmit.adapt.nms.NMS;
import com.volmit.adapt.util.C;
import com.volmit.adapt.util.Element;
import com.volmit.adapt.util.Localizer;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.block.Action;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;

public class CraftingStations
extends SimpleAdaptation<Config> {
    public CraftingStations() {
        super("crafting-stations");
        this.registerConfiguration(Config.class);
        this.setDescription(Localizer.dLocalize("crafting", "stations", "description"));
        this.setDisplayName(Localizer.dLocalize("crafting", "stations", "name"));
        this.setIcon(Material.CRAFTING_TABLE);
        this.setBaseCost(((Config)this.getConfig()).baseCost);
        this.setCostFactor(((Config)this.getConfig()).costFactor);
        this.setMaxLevel(((Config)this.getConfig()).maxLevel);
        this.setInitialCost(((Config)this.getConfig()).initialCost);
        this.setInterval(9248L);
    }

    @Override
    public void addStats(int n, Element element) {
        element.addLore(C.RED + Localizer.dLocalize("crafting", "stations", "lore2"));
        element.addLore(C.GRAY + Localizer.dLocalize("crafting", "stations", "lore3"));
    }

    @EventHandler
    public void on(PlayerInteractEvent playerInteractEvent) {
        Player player = playerInteractEvent.getPlayer();
        if (!this.hasAdaptation(player)) {
            return;
        }
        ItemStack itemStack = player.getInventory().getItemInMainHand();
        switch (itemStack.getType()) {
            case CRAFTING_TABLE: {
                if (player.hasCooldown(itemStack.getType())) {
                    playerInteractEvent.setCancelled(true);
                    return;
                }
                NMS.get().sendCooldown(player, itemStack.getType(), 1000);
                player.setCooldown(itemStack.getType(), 1000);
                if (!playerInteractEvent.getAction().equals((Object)Action.RIGHT_CLICK_AIR) && !playerInteractEvent.getAction().equals((Object)Action.LEFT_CLICK_AIR) && !playerInteractEvent.getAction().equals((Object)Action.LEFT_CLICK_BLOCK)) break;
                player.playSound(player.getLocation(), Sound.PARTICLE_SOUL_ESCAPE, 1.0f, 0.1f);
                player.playSound(player.getLocation(), Sound.BLOCK_ENDER_CHEST_OPEN, 1.0f, 0.1f);
                player.openWorkbench(null, true);
                break;
            }
            case GRINDSTONE: {
                if (player.hasCooldown(itemStack.getType())) {
                    playerInteractEvent.setCancelled(true);
                    return;
                }
                NMS.get().sendCooldown(player, itemStack.getType(), 1000);
                player.setCooldown(itemStack.getType(), 1000);
                if (!playerInteractEvent.getAction().equals((Object)Action.RIGHT_CLICK_AIR) && !playerInteractEvent.getAction().equals((Object)Action.LEFT_CLICK_AIR) && !playerInteractEvent.getAction().equals((Object)Action.LEFT_CLICK_BLOCK)) break;
                player.playSound(player.getLocation(), Sound.PARTICLE_SOUL_ESCAPE, 1.0f, 0.1f);
                player.playSound(player.getLocation(), Sound.BLOCK_ENDER_CHEST_OPEN, 1.0f, 0.1f);
                Inventory inventory = Bukkit.createInventory((InventoryHolder)player, (InventoryType)InventoryType.GRINDSTONE);
                player.openInventory(inventory);
                break;
            }
            case ANVIL: {
                if (player.hasCooldown(itemStack.getType())) {
                    playerInteractEvent.setCancelled(true);
                    return;
                }
                NMS.get().sendCooldown(player, itemStack.getType(), 1000);
                player.setCooldown(itemStack.getType(), 1000);
                if (!playerInteractEvent.getAction().equals((Object)Action.RIGHT_CLICK_AIR) && !playerInteractEvent.getAction().equals((Object)Action.LEFT_CLICK_AIR) && !playerInteractEvent.getAction().equals((Object)Action.LEFT_CLICK_BLOCK)) break;
                player.playSound(player.getLocation(), Sound.PARTICLE_SOUL_ESCAPE, 1.0f, 0.1f);
                player.playSound(player.getLocation(), Sound.BLOCK_ENDER_CHEST_OPEN, 1.0f, 0.1f);
                Inventory inventory = Bukkit.createInventory((InventoryHolder)player, (InventoryType)InventoryType.ANVIL);
                player.openInventory(inventory);
                break;
            }
            case STONECUTTER: {
                if (player.hasCooldown(itemStack.getType())) {
                    playerInteractEvent.setCancelled(true);
                    return;
                }
                NMS.get().sendCooldown(player, itemStack.getType(), 1000);
                player.setCooldown(itemStack.getType(), 1000);
                if (!playerInteractEvent.getAction().equals((Object)Action.RIGHT_CLICK_AIR) && !playerInteractEvent.getAction().equals((Object)Action.LEFT_CLICK_AIR) && !playerInteractEvent.getAction().equals((Object)Action.LEFT_CLICK_BLOCK)) break;
                player.playSound(player.getLocation(), Sound.PARTICLE_SOUL_ESCAPE, 1.0f, 0.1f);
                player.playSound(player.getLocation(), Sound.BLOCK_ENDER_CHEST_OPEN, 1.0f, 0.1f);
                Inventory inventory = Bukkit.createInventory((InventoryHolder)player, (InventoryType)InventoryType.STONECUTTER);
                player.openInventory(inventory);
                break;
            }
            case CARTOGRAPHY_TABLE: {
                if (player.hasCooldown(itemStack.getType())) {
                    playerInteractEvent.setCancelled(true);
                    return;
                }
                NMS.get().sendCooldown(player, itemStack.getType(), 1000);
                player.setCooldown(itemStack.getType(), 1000);
                if (!playerInteractEvent.getAction().equals((Object)Action.RIGHT_CLICK_AIR) && !playerInteractEvent.getAction().equals((Object)Action.LEFT_CLICK_AIR) && !playerInteractEvent.getAction().equals((Object)Action.LEFT_CLICK_BLOCK)) break;
                player.playSound(player.getLocation(), Sound.PARTICLE_SOUL_ESCAPE, 1.0f, 0.1f);
                player.playSound(player.getLocation(), Sound.BLOCK_ENDER_CHEST_OPEN, 1.0f, 0.1f);
                Inventory inventory = Bukkit.createInventory((InventoryHolder)player, (InventoryType)InventoryType.CARTOGRAPHY);
                player.openInventory(inventory);
                break;
            }
            case LOOM: {
                if (player.hasCooldown(itemStack.getType())) {
                    playerInteractEvent.setCancelled(true);
                    return;
                }
                NMS.get().sendCooldown(player, itemStack.getType(), 1000);
                player.setCooldown(itemStack.getType(), 1000);
                if (!playerInteractEvent.getAction().equals((Object)Action.RIGHT_CLICK_AIR) && !playerInteractEvent.getAction().equals((Object)Action.LEFT_CLICK_AIR) && !playerInteractEvent.getAction().equals((Object)Action.LEFT_CLICK_BLOCK)) break;
                player.playSound(player.getLocation(), Sound.PARTICLE_SOUL_ESCAPE, 1.0f, 0.1f);
                player.playSound(player.getLocation(), Sound.BLOCK_ENDER_CHEST_OPEN, 1.0f, 0.1f);
                Inventory inventory = Bukkit.createInventory((InventoryHolder)player, (InventoryType)InventoryType.LOOM);
                player.openInventory(inventory);
            }
        }
    }

    @Override
    public void onTick() {
    }

    @Override
    public boolean isEnabled() {
        return ((Config)this.getConfig()).enabled;
    }

    @Override
    public boolean isPermanent() {
        return ((Config)this.getConfig()).permanent;
    }

    static {
        IBootstrap.dasBoot();
    }

    protected static class Config {
        public int cooldown = 125;
        boolean permanent = true;
        boolean enabled = true;
        int baseCost = 5;
        int maxLevel = 1;
        int initialCost = 2;
        double costFactor = 1.0;

        static {
            IBootstrap.dasBoot();
        }
    }
}

