/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.content.adaptation.rift;

import com.volmit.adapt.api.adaptation.SimpleAdaptation;
import com.volmit.adapt.util.C;
import com.volmit.adapt.util.Element;
import com.volmit.adapt.util.J;
import com.volmit.adapt.util.Localizer;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.player.PlayerToggleSneakEvent;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class RiftDescent
extends SimpleAdaptation<Config> {
    private final List<Player> cooldown = new ArrayList<Player>();

    public RiftDescent() {
        super("rift-descent");
        this.registerConfiguration(Config.class);
        this.setDescription(Localizer.dLocalize("rift", "descent", "description"));
        this.setDisplayName(Localizer.dLocalize("rift", "descent", "name"));
        this.setMaxLevel(1);
        this.setIcon(Material.SHULKER_BOX);
        this.setBaseCost(((Config)this.getConfig()).baseCost);
        this.setCostFactor(((Config)this.getConfig()).costFactor);
        this.setInitialCost(((Config)this.getConfig()).initialCost);
        this.setInterval(9544L);
    }

    @Override
    public void addStats(int n, Element element) {
        element.addLore(C.YELLOW + Localizer.dLocalize("rift", "descent", "lore1"));
        element.addLore(C.GREEN + Localizer.dLocalize("rift", "descent", "lore2") + " " + C.WHITE + ((Config)this.getConfig()).cooldown + "s");
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void on(PlayerToggleSneakEvent playerToggleSneakEvent) {
        Player player = playerToggleSneakEvent.getPlayer();
        if (player.getPotionEffect(PotionEffectType.LEVITATION) == null) {
            return;
        }
        if (!this.hasAdaptation(player)) {
            return;
        }
        if (this.cooldown.contains(player)) {
            return;
        }
        PotionEffect potionEffect = player.getPotionEffect(PotionEffectType.LEVITATION);
        if (!playerToggleSneakEvent.isSneaking() && potionEffect != null) {
            player.removePotionEffect(PotionEffectType.LEVITATION);
            J.a(() -> {
                this.cooldown.add(player);
                try {
                    Thread.sleep((long)(((Config)this.getConfig()).cooldown * 1000.0));
                }
                catch (InterruptedException interruptedException) {
                    throw new RuntimeException(interruptedException);
                }
                player.playSound(player.getLocation(), Sound.ENTITY_EXPERIENCE_ORB_PICKUP, 1.0f, 1.0f);
                this.cooldown.remove(player);
            });
            J.s(() -> {
                player.addPotionEffect(new PotionEffect(PotionEffectType.SLOW_FALLING, (int)(20.0 * ((Config)this.getConfig()).cooldown), 0));
                player.playSound(player.getLocation(), Sound.ENTITY_ENDER_DRAGON_FLAP, 1.0f, 1.0f);
            });
        }
    }

    @Override
    public void onTick() {
    }

    @Override
    public boolean isEnabled() {
        return ((Config)this.getConfig()).enabled;
    }

    @Override
    public boolean isPermanent() {
        return ((Config)this.getConfig()).permanent;
    }

    static {
        IBootstrap.dasBoot();
    }

    protected static class Config {
        boolean permanent = true;
        boolean enabled = true;
        double cooldown = 5.0;
        int baseCost = 1;
        double costFactor = 2.0;
        int initialCost = 3;

        static {
            IBootstrap.dasBoot();
        }
    }
}

