/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.content.adaptation.sword;

import com.volmit.adapt.Adapt;
import com.volmit.adapt.api.adaptation.SimpleAdaptation;
import com.volmit.adapt.content.adaptation.sword.effects.DamagingBleedEffect;
import com.volmit.adapt.content.item.ItemListings;
import com.volmit.adapt.util.C;
import com.volmit.adapt.util.Element;
import com.volmit.adapt.util.Form;
import com.volmit.adapt.util.Localizer;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import de.slikey.effectlib.effect.BleedEffect;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.potion.PotionEffectType;

public class SwordsPoisonedBlade
extends SimpleAdaptation<Config> {
    private final Map<Player, Long> cooldowns;

    public SwordsPoisonedBlade() {
        super("sword-poison-blade");
        this.registerConfiguration(Config.class);
        this.setDescription(Localizer.dLocalize("sword", "poisonedblade", "description"));
        this.setDisplayName(Localizer.dLocalize("sword", "poisonedblade", "name"));
        this.setIcon(Material.GREEN_DYE);
        this.setBaseCost(((Config)this.getConfig()).baseCost);
        this.setMaxLevel(((Config)this.getConfig()).maxLevel);
        this.setInterval(4984L);
        this.setInitialCost(((Config)this.getConfig()).initialCost);
        this.setCostFactor(((Config)this.getConfig()).costFactor);
        this.cooldowns = new HashMap<Player, Long>();
    }

    @Override
    public void addStats(int n, Element element) {
        element.addLore(C.GREEN + "+ " + C.GRAY + " " + Localizer.dLocalize("sword", "poisonedblade", "lore1"));
        element.addLore(C.YELLOW + "* " + Form.duration(this.getDurationOfEffect(n), 1) + C.GRAY + " " + Localizer.dLocalize("sword", "poisonedblade", "lore2"));
        element.addLore(C.RED + "* " + Form.duration(this.getCooldown(n), 1) + C.GRAY + " " + Localizer.dLocalize("sword", "poisonedblade", "lore3"));
    }

    public long getCooldown(int n) {
        return ((Config)this.getConfig()).cooldown * (long)n;
    }

    public long getDurationOfEffect(int n) {
        return ((Config)this.getConfig()).effectDuration * (long)n;
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void on(EntityDamageByEntityEvent entityDamageByEntityEvent) {
        Player player;
        if (entityDamageByEntityEvent.isCancelled()) {
            return;
        }
        Entity entity = entityDamageByEntityEvent.getDamager();
        if (entity instanceof Player && this.hasAdaptation(player = (Player)entity) && ItemListings.getToolSwords().contains(player.getInventory().getItemInMainHand().getType())) {
            if (this.cooldowns.containsKey(player)) {
                if (this.cooldowns.get(player).compareTo(System.currentTimeMillis()) > 0) {
                    return;
                }
                this.cooldowns.remove(player);
            }
            entity = entityDamageByEntityEvent.getEntity();
            this.cooldowns.put(player, System.currentTimeMillis() + this.getCooldown(this.getLevel(player)));
            if (entity instanceof Player) {
                Player player2 = (Player)entity;
                if (!this.canPVP(player, player2.getLocation())) {
                    return;
                }
                BleedEffect bleedEffect = new BleedEffect(Adapt.instance.adaptEffectManager);
                bleedEffect.setEntity((Entity)player2);
                bleedEffect.material = Material.LARGE_FERN;
                bleedEffect.height = -1.0;
                bleedEffect.iterations = Math.toIntExact(2L * (3L + this.getDurationOfEffect(this.getLevel(player)) / 1000L));
                bleedEffect.period = 5;
                bleedEffect.hurt = false;
                bleedEffect.start();
                this.addPotionStacks(player2, PotionEffectType.POISON, 2, 50 * this.getLevel(player), true);
            } else {
                BleedEffect bleedEffect;
                if (!this.canPVE(player, entity.getLocation())) {
                    return;
                }
                if (entity instanceof LivingEntity) {
                    LivingEntity livingEntity = (LivingEntity)entity;
                    bleedEffect = new DamagingBleedEffect(Adapt.instance.adaptEffectManager, 1.0, livingEntity);
                } else {
                    bleedEffect = new BleedEffect(Adapt.instance.adaptEffectManager);
                }
                BleedEffect bleedEffect2 = bleedEffect;
                bleedEffect2.setEntity(entity);
                bleedEffect2.material = Material.LARGE_FERN;
                bleedEffect2.height = -1.0;
                bleedEffect2.iterations = Math.toIntExact(2L * (3L + this.getDurationOfEffect(this.getLevel(player)) / 1000L));
                bleedEffect2.period = 5;
                bleedEffect2.hurt = false;
                bleedEffect2.start();
            }
        }
    }

    @Override
    public void onTick() {
    }

    @Override
    public boolean isEnabled() {
        return ((Config)this.getConfig()).enabled;
    }

    @Override
    public boolean isPermanent() {
        return ((Config)this.getConfig()).permanent;
    }

    static {
        IBootstrap.dasBoot();
    }

    protected static class Config {
        public long cooldown = 5000L;
        public long effectDuration = 1000L;
        boolean permanent = false;
        boolean enabled = true;
        int baseCost = 7;
        int maxLevel = 7;
        int initialCost = 7;
        double costFactor = 0.325;

        static {
            IBootstrap.dasBoot();
        }
    }
}

