/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.content.adaptation.taming;

import com.volmit.adapt.Adapt;
import com.volmit.adapt.api.adaptation.SimpleAdaptation;
import com.volmit.adapt.util.C;
import com.volmit.adapt.util.Element;
import com.volmit.adapt.util.Form;
import com.volmit.adapt.util.J;
import com.volmit.adapt.util.Localizer;
import com.volmit.adapt.util.M;
import com.volmit.adapt.util.extensions.java.util.Map.XMap;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.attribute.Attribute;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Tameable;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.potion.PotionEffectType;

public class TamingHealthRegeneration
extends SimpleAdaptation<Config> {
    private final Map<UUID, Long> lastDamage = new HashMap<UUID, Long>();

    public TamingHealthRegeneration() {
        super("tame-health-regeneration");
        this.registerConfiguration(Config.class);
        this.setDescription(Localizer.dLocalize("taming", "regeneration", "description"));
        this.setDisplayName(Localizer.dLocalize("taming", "regeneration", "name"));
        this.setIcon(Material.GOLDEN_APPLE);
        this.setBaseCost(((Config)this.getConfig()).baseCost);
        this.setMaxLevel(((Config)this.getConfig()).maxLevel);
        this.setInitialCost(((Config)this.getConfig()).initialCost);
        this.setInterval(1033L);
        this.setCostFactor(((Config)this.getConfig()).costFactor);
    }

    @Override
    public void addStats(int n, Element element) {
        element.addLore(C.GREEN + "+ " + Form.f(this.getRegenSpeed(n), 0) + C.GRAY + " " + Localizer.dLocalize("taming", "regeneration", "lore1"));
    }

    @EventHandler
    public void on(EntityDamageByEntityEvent entityDamageByEntityEvent) {
        Player player;
        Tameable tameable;
        if (entityDamageByEntityEvent.isCancelled()) {
            return;
        }
        Entity entity = entityDamageByEntityEvent.getEntity();
        if (entity instanceof Tameable && (entity = (tameable = (Tameable)entity).getOwner()) instanceof Player && this.hasAdaptation(player = (Player)entity)) {
            if (this.lastDamage.containsKey(tameable.getUniqueId())) {
                Adapt.verbose("Tamed Entity " + tameable.getUniqueId() + " last damaged " + (M.ms() - this.lastDamage.get(tameable.getUniqueId())) + "ms ago");
                return;
            }
            double d = tameable.getAttribute(Attribute.GENERIC_MAX_HEALTH).getValue();
            if (tameable.isTamed() && tameable.getOwner() instanceof Player && tameable.getHealth() < d) {
                Adapt.verbose("Successfully healed tamed entity " + tameable.getUniqueId());
                int n = this.getLevel(player);
                if (n > 0) {
                    Adapt.verbose("[PRE] Current Health: " + tameable.getHealth() + " Max Health: " + d);
                    tameable.addPotionEffect(PotionEffectType.REGENERATION.createEffect(25 * this.getLevel(player), 3));
                    J.a(() -> {
                        try {
                            Thread.sleep((long)this.getLevel(player) * 2000L);
                        }
                        catch (InterruptedException interruptedException) {
                            throw new RuntimeException(interruptedException);
                        }
                        Adapt.verbose("[POST] Current Health: " + tameable.getHealth() + " Max Health: " + d);
                    });
                    if (((Config)this.getConfig()).showParticles) {
                        Adapt.verbose("Healing tamed entity " + tameable.getUniqueId() + " with particles");
                        tameable.getWorld().spawnParticle(Particle.HEART, tameable.getLocation().add(0.0, 1.0, 0.0), 2 * player.getLevel());
                    } else {
                        Adapt.verbose("Healing tamed entity " + tameable.getUniqueId() + " without particles");
                    }
                }
            }
            this.lastDamage.put(entityDamageByEntityEvent.getEntity().getUniqueId(), M.ms());
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void on(EntityDeathEvent entityDeathEvent) {
        this.lastDamage.remove(entityDeathEvent.getEntity().getUniqueId());
    }

    private double getRegenSpeed(int n) {
        return this.getLevelPercent(n) * this.getLevelPercent(n) * ((Config)this.getConfig()).regenFactor + ((Config)this.getConfig()).regenBase;
    }

    @Override
    public void onTick() {
        for (UUID uUID : XMap.k(this.lastDamage)) {
            if (M.ms() - this.lastDamage.get(uUID) <= 8000L) continue;
            this.lastDamage.remove(uUID);
        }
    }

    @Override
    public boolean isEnabled() {
        return ((Config)this.getConfig()).enabled;
    }

    @Override
    public boolean isPermanent() {
        return ((Config)this.getConfig()).permanent;
    }

    static {
        IBootstrap.dasBoot();
    }

    protected static class Config {
        boolean permanent = false;
        boolean enabled = true;
        boolean showParticles = true;
        int baseCost = 7;
        int maxLevel = 3;
        int initialCost = 8;
        double costFactor = 0.4;
        double regenFactor = 5.0;
        double regenBase = 1.0;

        static {
            IBootstrap.dasBoot();
        }
    }
}

