/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.content.adaptation.tragoul;

import com.volmit.adapt.Adapt;
import com.volmit.adapt.api.adaptation.SimpleAdaptation;
import com.volmit.adapt.util.C;
import com.volmit.adapt.util.Element;
import com.volmit.adapt.util.Localizer;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.attribute.Attribute;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.plugin.Plugin;

public class TragoulHealing
extends SimpleAdaptation<Config> {
    private final Map<Player, Long> cooldowns;
    private final Map<Player, Long> healingWindow;

    public TragoulHealing() {
        super("tragoul-healing");
        this.registerConfiguration(Config.class);
        this.setDescription(Localizer.dLocalize("tragoul", "healing", "description"));
        this.setDisplayName(Localizer.dLocalize("tragoul", "healing", "name"));
        this.setIcon(Material.REDSTONE);
        this.setInterval(25000L);
        this.setBaseCost(((Config)this.getConfig()).baseCost);
        this.setMaxLevel(((Config)this.getConfig()).maxLevel);
        this.setInitialCost(((Config)this.getConfig()).initialCost);
        this.setCostFactor(((Config)this.getConfig()).costFactor);
        this.cooldowns = new HashMap<Player, Long>();
        this.healingWindow = new HashMap<Player, Long>();
    }

    @Override
    public void addStats(int n, Element element) {
        element.addLore(C.GREEN + Localizer.dLocalize("tragoul", "healing", "lore1"));
        element.addLore(C.YELLOW + Localizer.dLocalize("tragoul", "healing", "lore2"));
        element.addLore(C.YELLOW + Localizer.dLocalize("tragoul", "healing", "lore3") + (((Config)this.getConfig()).minHealPercent + (((Config)this.getConfig()).maxHealPercent - ((Config)this.getConfig()).minHealPercent) * (double)(n - 1) / (double)(((Config)this.getConfig()).maxLevel - 1)) + "%");
    }

    @EventHandler
    public void on(EntityDamageByEntityEvent entityDamageByEntityEvent) {
        Player player;
        Entity entity = entityDamageByEntityEvent.getDamager();
        if (entity instanceof Player && this.hasAdaptation(player = (Player)entity)) {
            if (this.isOnCooldown(player)) {
                return;
            }
            if (!this.healingWindow.containsKey(player)) {
                Adapt.verbose("Starting healing window for " + player.getName());
                this.startHealingWindow(player);
            }
            if (((Config)this.getConfig()).showParticles) {
                this.vfxParticleLine(player.getLocation(), entityDamageByEntityEvent.getEntity().getLocation(), 25, Particle.WHITE_ASH);
            }
            double d = ((Config)this.getConfig()).minHealPercent + (((Config)this.getConfig()).maxHealPercent - ((Config)this.getConfig()).minHealPercent) * (double)(this.getLevel(player) - 1) / (double)(((Config)this.getConfig()).maxLevel - 1);
            double d2 = entityDamageByEntityEvent.getDamage() * d;
            Adapt.verbose("Healing " + player.getName() + " for " + d2 + " (" + d * 100.0 + "% of " + entityDamageByEntityEvent.getDamage() + " damage)");
            player.setHealth(Math.min(player.getAttribute(Attribute.GENERIC_MAX_HEALTH).getValue(), player.getHealth() + d2));
        }
    }

    private boolean isOnCooldown(Player player) {
        return this.cooldowns.containsKey(player) && this.cooldowns.get(player).compareTo(System.currentTimeMillis()) > 0;
    }

    private void startHealingWindow(Player player) {
        long l = System.currentTimeMillis();
        this.healingWindow.put(player, l + (long)((Config)this.getConfig()).windowDuration);
        Bukkit.getScheduler().runTaskLater((Plugin)Adapt.instance, () -> {
            this.healingWindow.remove(player);
            this.cooldowns.put(player, l + (long)((Config)this.getConfig()).windowDuration + (long)((Config)this.getConfig()).cooldownDuration);
        }, (long)(((Config)this.getConfig()).windowDuration / 50));
    }

    @Override
    public boolean isEnabled() {
        return ((Config)this.getConfig()).enabled;
    }

    @Override
    public void onTick() {
    }

    @Override
    public boolean isPermanent() {
        return ((Config)this.getConfig()).permanent;
    }

    static {
        IBootstrap.dasBoot();
    }

    protected static class Config {
        boolean permanent = false;
        boolean enabled = true;
        boolean showParticles = true;
        int baseCost = 5;
        int maxLevel = 5;
        int initialCost = 5;
        double costFactor = 1.1;
        double minHealPercent = 0.1;
        double maxHealPercent = 0.45;
        int cooldownDuration = 1000;
        int windowDuration = 3000;

        static {
            IBootstrap.dasBoot();
        }
    }
}

