/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.content.protector;

import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.world.World;
import com.sk89q.worldguard.LocalPlayer;
import com.sk89q.worldguard.WorldGuard;
import com.sk89q.worldguard.bukkit.WorldGuardPlugin;
import com.sk89q.worldguard.protection.association.DelayedRegionOverlapAssociation;
import com.sk89q.worldguard.protection.association.RegionAssociable;
import com.sk89q.worldguard.protection.flags.Flags;
import com.sk89q.worldguard.protection.flags.StateFlag;
import com.sk89q.worldguard.protection.flags.registry.FlagRegistry;
import com.sk89q.worldguard.protection.regions.RegionContainer;
import com.sk89q.worldguard.protection.regions.RegionQuery;
import com.volmit.adapt.AdaptConfig;
import com.volmit.adapt.api.adaptation.Adaptation;
import com.volmit.adapt.api.protection.Protector;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import java.lang.reflect.Field;
import java.util.concurrent.ConcurrentMap;
import org.bukkit.Location;
import org.bukkit.entity.Player;

public class WorldGuardProtector
implements Protector {
    private final RegionContainer container = WorldGuard.getInstance().getPlatform().getRegionContainer();
    private final StateFlag flag = new StateFlag("use-adaptations", false);

    public WorldGuardProtector() {
        FlagRegistry flagRegistry = WorldGuard.getInstance().getFlagRegistry();
        try {
            Field field = flagRegistry.getClass().getDeclaredField("flags");
            field.setAccessible(true);
            ConcurrentMap concurrentMap = (ConcurrentMap)field.get(flagRegistry);
            concurrentMap.put(this.flag.getName().toLowerCase(), this.flag);
        }
        catch (IllegalAccessException | NoSuchFieldException reflectiveOperationException) {
            reflectiveOperationException.printStackTrace();
        }
    }

    @Override
    public boolean checkRegion(Player player, Location location, Adaptation<?> adaptation) {
        return this.checkPerm(player, location, this.flag);
    }

    @Override
    public boolean canBlockBreak(Player player, Location location, Adaptation<?> adaptation) {
        return this.checkRegion(player, location, adaptation) && this.checkPerm(location, Flags.BLOCK_BREAK);
    }

    @Override
    public boolean canBlockPlace(Player player, Location location, Adaptation<?> adaptation) {
        return this.checkRegion(player, location, adaptation) && this.checkPerm(location, Flags.BLOCK_PLACE);
    }

    @Override
    public boolean canPVP(Player player, Location location, Adaptation<?> adaptation) {
        return this.checkRegion(player, location, adaptation) && this.checkPerm(location, Flags.PVP);
    }

    @Override
    public boolean canPVE(Player player, Location location, Adaptation<?> adaptation) {
        return this.checkRegion(player, location, adaptation) && this.checkPerm(location, Flags.DAMAGE_ANIMALS);
    }

    @Override
    public boolean canInteract(Player player, Location location, Adaptation<?> adaptation) {
        return this.checkRegion(player, location, adaptation) && this.checkPerm(location, Flags.INTERACT);
    }

    @Override
    public boolean canAccessChest(Player player, Location location, Adaptation<?> adaptation) {
        return this.checkRegion(player, location, adaptation) && this.checkPerm(location, Flags.CHEST_ACCESS);
    }

    private boolean checkPerm(Location location, StateFlag stateFlag) {
        return this.checkPerm(null, location, stateFlag);
    }

    private boolean checkPerm(Player player, Location location, StateFlag stateFlag) {
        RegionQuery regionQuery = this.container.createQuery();
        com.sk89q.worldedit.util.Location location2 = BukkitAdapter.adapt((Location)location);
        if (player == null) {
            return regionQuery.queryState(location2, (RegionAssociable)new DelayedRegionOverlapAssociation(regionQuery, location2), new StateFlag[]{stateFlag}) != StateFlag.State.DENY;
        }
        if (!this.hasBypass(player, location)) {
            return regionQuery.queryState(location2, WorldGuardPlugin.inst().wrapPlayer(player), new StateFlag[]{stateFlag}) != StateFlag.State.DENY;
        }
        return true;
    }

    @Override
    public String getName() {
        return "WorldGuard";
    }

    @Override
    public boolean isEnabledByDefault() {
        return AdaptConfig.get().getProtectorSupport().isWorldguard();
    }

    private boolean hasBypass(Player player, Location location) {
        LocalPlayer localPlayer = WorldGuardPlugin.inst().wrapPlayer(player);
        World world = BukkitAdapter.adapt((org.bukkit.World)location.getWorld());
        return WorldGuard.getInstance().getPlatform().getSessionManager().hasBypass(localPlayer, world);
    }

    static {
        IBootstrap.dasBoot();
    }
}

