/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.content.skill;

import com.volmit.adapt.Adapt;
import com.volmit.adapt.AdaptConfig;
import com.volmit.adapt.api.skill.SimpleSkill;
import com.volmit.adapt.api.world.AdaptPlayer;
import com.volmit.adapt.api.world.PlayerAdaptation;
import com.volmit.adapt.api.world.PlayerSkillLine;
import com.volmit.adapt.content.adaptation.tragoul.TragoulGlobe;
import com.volmit.adapt.content.adaptation.tragoul.TragoulHealing;
import com.volmit.adapt.content.adaptation.tragoul.TragoulLance;
import com.volmit.adapt.content.adaptation.tragoul.TragoulThorns;
import com.volmit.adapt.util.C;
import com.volmit.adapt.util.Localizer;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import de.slikey.effectlib.effect.CloudEffect;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.PlayerDeathEvent;

public class SkillTragOul
extends SimpleSkill<Config> {
    private final Map<Player, Long> cooldowns;

    public SkillTragOul() {
        super("tragoul", Localizer.dLocalize("skill", "tragoul", "icon"));
        this.registerConfiguration(Config.class);
        this.setColor(C.AQUA);
        this.setDescription(Localizer.dLocalize("skill", "tragoul", "description"));
        this.setDisplayName(Localizer.dLocalize("skill", "tragoul", "name"));
        this.setInterval(2755L);
        this.setIcon(Material.CRIMSON_ROOTS);
        this.cooldowns = new HashMap<Player, Long>();
        this.registerAdaptation(new TragoulThorns());
        this.registerAdaptation(new TragoulGlobe());
        this.registerAdaptation(new TragoulHealing());
        this.registerAdaptation(new TragoulLance());
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void on(EntityDamageByEntityEvent entityDamageByEntityEvent) {
        Entity entity = entityDamageByEntityEvent.getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        this.shouldReturnForPlayer(player, (Cancellable)entityDamageByEntityEvent, () -> {
            if (entityDamageByEntityEvent.getEntity().isDead() || entityDamageByEntityEvent.getEntity().isInvulnerable() || player.isInvulnerable() || player.isBlocking() || !this.checkValidEntity(entityDamageByEntityEvent.getEntity().getType())) {
                return;
            }
            AdaptPlayer adaptPlayer = this.getPlayer(player);
            adaptPlayer.getData().addStat("trag.hitsrecieved", 1.0);
            adaptPlayer.getData().addStat("trag.damage", entityDamageByEntityEvent.getDamage());
            if (this.cooldowns.containsKey(player)) {
                if (this.cooldowns.get(player) + ((Config)this.getConfig()).cooldownDelay > System.currentTimeMillis()) {
                    return;
                }
                this.cooldowns.remove(player);
            }
            this.cooldowns.put(player, System.currentTimeMillis());
            this.xp(adaptPlayer.getPlayer(), ((Config)this.getConfig()).damageReceivedXpMultiplier * entityDamageByEntityEvent.getDamage());
        });
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void on(PlayerDeathEvent playerDeathEvent) {
        Player player = playerDeathEvent.getEntity();
        this.shouldReturnForPlayer(player, () -> {
            AdaptPlayer adaptPlayer = this.getPlayer(player);
            if (AdaptConfig.get().isHardcoreResetOnPlayerDeath()) {
                Adapt.info("Resetting " + player.getName() + "'s skills due to death");
                adaptPlayer.delete(player.getUniqueId());
                return;
            }
            if (((Config)this.getConfig()).takeAwaySkillsOnDeath) {
                Object object;
                if (((Config)this.getConfig()).showParticles) {
                    object = new CloudEffect(Adapt.instance.adaptEffectManager);
                    ((CloudEffect)object).mainParticle = Particle.ASH;
                    ((CloudEffect)object).cloudParticle = Particle.REDSTONE;
                    ((CloudEffect)object).duration = 10000;
                    ((CloudEffect)object).iterations = 1000;
                    object.setEntity((Entity)player);
                    object.start();
                }
                if (this.hasBlacklistPermission(player, this)) {
                    return;
                }
                player.playSound(player.getLocation(), Sound.ENTITY_BLAZE_DEATH, 1.0f, 1.0f);
                object = adaptPlayer.getData().getSkillLines().get("tragoul");
                if (object != null) {
                    double d = ((PlayerSkillLine)object).getXp();
                    if (d > ((Config)this.getConfig()).deathXpLoss) {
                        this.xp(player, ((Config)this.getConfig()).deathXpLoss);
                    } else {
                        ((PlayerSkillLine)object).setXp(0.0);
                    }
                    ((PlayerSkillLine)object).setLastXP(d);
                    for (PlayerAdaptation playerAdaptation : ((PlayerSkillLine)object).getAdaptations().values()) {
                        playerAdaptation.setLevel(Math.max(playerAdaptation.getLevel() - 1, 0));
                    }
                    this.recalcTotalExp(player);
                }
            }
        });
    }

    @Override
    public void onTick() {
        if (!this.isEnabled()) {
            return;
        }
        for (Player player : Bukkit.getOnlinePlayers()) {
            this.shouldReturnForPlayer(player, () -> {
                AdaptPlayer adaptPlayer = this.getPlayer(player);
                this.checkStatTrackers(adaptPlayer);
            });
        }
    }

    @Override
    public boolean isEnabled() {
        return ((Config)this.getConfig()).enabled;
    }

    static {
        IBootstrap.dasBoot();
    }

    protected static class Config {
        public double deathXpLoss = -750.0;
        boolean takeAwaySkillsOnDeath = false;
        boolean enabled = true;
        boolean showParticles = true;
        long cooldownDelay = 1000L;
        double damageReceivedXpMultiplier = 2.26;

        static {
            IBootstrap.dasBoot();
        }
    }
}

