/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.util;

import com.volmit.adapt.util.Cuboid;
import com.volmit.adapt.util.extensions.java.util.List.XList;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Random;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;

public class Area {
    private Location location;
    private Double radius;

    public Area(Location location, Double d) {
        this.location = location;
        this.radius = d;
    }

    public Area(Location location, Integer n) {
        this.location = location;
        this.radius = (double)n;
    }

    public static boolean within(Location location, Location location2, double d) {
        return new Area(location, d).isWithin(location2);
    }

    public Cuboid toCuboid() {
        return new Cuboid(this.location.clone().add(this.radius.doubleValue(), this.radius.doubleValue(), this.radius.doubleValue()), this.location.clone().subtract(this.radius.doubleValue(), this.radius.doubleValue(), this.radius.doubleValue()));
    }

    public Double distance(Location location) {
        double d;
        double d2 = d = this.location.distanceSquared(location);
        for (int i = 0; i < 3; ++i) {
            d2 = (d / d2 + d2) / 2.0;
        }
        return d2;
    }

    public Double slowDistance(Location location) {
        return this.location.distance(location);
    }

    public boolean isWithin(Location location) {
        return this.location.distance(location) <= this.radius * this.radius;
    }

    public boolean hasEntities() {
        return this.getNearbyEntities().length > 0;
    }

    public Entity[] getNearbyEntities(EntityType entityType) {
        ArrayList arrayList = new ArrayList();
        XList.add(arrayList, this.getNearbyEntities());
        for (Entity entity : XList.copy(arrayList)) {
            if (entity.getType().equals((Object)entityType)) continue;
            arrayList.remove(entity);
        }
        return arrayList.toArray(new Entity[arrayList.size()]);
    }

    public Entity[] getNearbyEntities(Class<? extends Entity> clazz) {
        ArrayList arrayList = new ArrayList();
        XList.add(arrayList, this.getNearbyEntities());
        for (Entity entity : XList.copy(arrayList)) {
            if (entity.getClass().isAssignableFrom(clazz)) continue;
            arrayList.remove(entity);
        }
        return arrayList.toArray(new Entity[0]);
    }

    public Entity[] getNearbyEntities() {
        try {
            int n = (int)(this.radius < 16.0 ? 1.0 : (this.radius - this.radius % 16.0) / 16.0);
            HashSet<Entity> hashSet = new HashSet<Entity>();
            for (int i = 0 - n; i <= n; ++i) {
                for (int j = 0 - n; j <= n; ++j) {
                    int n2 = (int)this.location.getX();
                    int n3 = (int)this.location.getY();
                    int n4 = (int)this.location.getZ();
                    for (Entity entity : new Location(this.location.getWorld(), (double)(n2 + i * 16), (double)n3, (double)(n4 + j * 16)).getChunk().getEntities()) {
                        if (!(entity.getLocation().distanceSquared(this.location) <= this.radius * this.radius) || entity.getLocation().getBlock() == this.location.getBlock()) continue;
                        hashSet.add(entity);
                    }
                }
            }
            return hashSet.toArray(new Entity[hashSet.size()]);
        }
        catch (Exception exception) {
            return new ArrayList().toArray(new Entity[0]);
        }
    }

    public Player[] getNearbyPlayers() {
        ArrayList<Player> arrayList = new ArrayList<Player>();
        for (Entity entity : this.getNearbyEntities()) {
            if (!entity.getType().equals((Object)EntityType.PLAYER)) continue;
            arrayList.add((Player)entity);
        }
        return arrayList.toArray(new Player[0]);
    }

    public Location getLocation() {
        return this.location;
    }

    public void setLocation(Location location) {
        this.location = location;
    }

    public Double getRadius() {
        return this.radius;
    }

    public void setRadius(Double d) {
        this.radius = d;
    }

    public Location random() {
        Random random = new Random();
        double d = this.radius * ((random.nextDouble() - 0.5) * 2.0);
        double d2 = this.radius * ((random.nextDouble() - 0.5) * 2.0);
        double d3 = this.radius * ((random.nextDouble() - 0.5) * 2.0);
        return this.location.clone().add(d, d2, d3);
    }

    static {
        IBootstrap.dasBoot();
    }
}

