/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.util;

import com.volmit.adapt.util.Board;
import com.volmit.adapt.util.BoardSettings;
import com.volmit.adapt.util.BoardUpdateTask;
import com.volmit.adapt.util.DontObfuscate;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitTask;

@DontObfuscate
public class BoardManager {
    @DontObfuscate
    private final JavaPlugin plugin;
    @DontObfuscate
    private final Map<UUID, Board> scoreboards;
    @DontObfuscate
    private final BukkitTask updateTask;
    @DontObfuscate
    private BoardSettings boardSettings;

    @DontObfuscate
    public BoardManager(JavaPlugin javaPlugin, BoardSettings boardSettings) {
        this.plugin = javaPlugin;
        this.boardSettings = boardSettings;
        this.scoreboards = new ConcurrentHashMap<UUID, Board>();
        this.updateTask = new BoardUpdateTask(this).runTaskTimer((Plugin)javaPlugin, 2L, 2L);
        javaPlugin.getServer().getOnlinePlayers().forEach(this::setup);
    }

    @DontObfuscate
    public void setBoardSettings(BoardSettings boardSettings) {
        this.boardSettings = boardSettings;
        this.scoreboards.values().forEach(board -> board.setBoardSettings(boardSettings));
    }

    @DontObfuscate
    public boolean hasBoard(Player player) {
        return this.scoreboards.containsKey(player.getUniqueId());
    }

    @DontObfuscate
    public Optional<Board> getBoard(Player player) {
        return Optional.ofNullable(this.scoreboards.get(player.getUniqueId()));
    }

    @DontObfuscate
    public void setup(Player player) {
        Optional.ofNullable(this.scoreboards.remove(player.getUniqueId())).ifPresent(Board::resetScoreboard);
        if (player.getScoreboard().equals(Bukkit.getScoreboardManager() != null && player.getScoreboard().equals(Bukkit.getScoreboardManager().getMainScoreboard()))) {
            player.setScoreboard(Bukkit.getScoreboardManager().getNewScoreboard());
        }
        this.scoreboards.put(player.getUniqueId(), new Board(player, this.boardSettings));
    }

    @DontObfuscate
    public void remove(Player player) {
        Optional.ofNullable(this.scoreboards.remove(player.getUniqueId())).ifPresent(Board::remove);
    }

    @DontObfuscate
    public Map<UUID, Board> getScoreboards() {
        return Collections.unmodifiableMap(this.scoreboards);
    }

    @DontObfuscate
    public void onDisable() {
        this.updateTask.cancel();
        this.plugin.getServer().getOnlinePlayers().forEach(this::remove);
        this.scoreboards.clear();
    }

    static {
        IBootstrap.dasBoot();
    }
}

