/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.util;

import com.volmit.adapt.util.Area;
import com.volmit.adapt.util.VectorMath;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.util.Vector;

public class Impulse {
    private final List<Entity> ignore = new ArrayList<Entity>();
    private double radius;
    private double forceMax;
    private double forceMin;
    private double damageMin;
    private double damageMax;

    public Impulse(double d) {
        this.radius = d;
        this.forceMax = 1.0;
        this.forceMin = 0.0;
        this.damageMax = 1.0;
        this.damageMin = 0.0;
    }

    public Impulse radius(double d) {
        this.radius = d;
        return this;
    }

    public Impulse force(double d) {
        this.forceMax = d;
        return this;
    }

    public Impulse force(double d, double d2) {
        this.forceMax = d;
        this.forceMin = d2;
        return this;
    }

    public Impulse damage(double d) {
        this.damageMax = d;
        return this;
    }

    public Impulse damage(double d, double d2) {
        this.damageMax = d;
        this.damageMin = d2;
        return this;
    }

    public void punch(Location location) {
        Area area = new Area(location, this.radius);
        for (Entity entity : area.getNearbyEntities()) {
            if (this.ignore.contains(entity)) continue;
            Vector vector = VectorMath.direction(location, entity.getLocation());
            double d = 0.0;
            double d2 = entity.getLocation().distance(location);
            if (this.forceMin < this.forceMax) {
                vector.clone().multiply((1.0 - d2 / this.radius) * (this.forceMax - this.forceMin) + this.forceMin);
            }
            if (this.damageMin < this.damageMax) {
                d = (1.0 - d2 / this.radius) * (this.damageMax - this.damageMin) + this.damageMin;
            }
            try {
                if (entity instanceof LivingEntity && d > 0.0) {
                    ((LivingEntity)entity).damage(d);
                }
                entity.setVelocity(entity.getVelocity().add(vector));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public Impulse ignore(Entity entity) {
        this.ignore.add(entity);
        return this;
    }

    static {
        IBootstrap.dasBoot();
    }
}

