/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.util;

import com.volmit.adapt.util.JSONException;
import com.volmit.adapt.util.JSONObject;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import java.io.IOException;
import java.io.Writer;

public class JSONWriter {
    private static final int maxdepth = 200;
    private final JSONObject[] stack;
    protected char mode = (char)105;
    protected Writer writer;
    private boolean comma = false;
    private int top = 0;

    public JSONWriter(Writer writer) {
        this.stack = new JSONObject[200];
        this.writer = writer;
    }

    private JSONWriter append(String string) {
        if (string == null) {
            throw new JSONException("Null pointer");
        }
        if (this.mode == 'o' || this.mode == 'a') {
            try {
                if (this.comma && this.mode == 'a') {
                    this.writer.write(44);
                }
                this.writer.write(string);
            }
            catch (IOException iOException) {
                throw new JSONException(iOException);
            }
            if (this.mode == 'o') {
                this.mode = (char)107;
            }
            this.comma = true;
            return this;
        }
        throw new JSONException("Value out of sequence.");
    }

    public JSONWriter array() {
        if (this.mode == 'i' || this.mode == 'o' || this.mode == 'a') {
            this.push(null);
            this.append("[");
            this.comma = false;
            return this;
        }
        throw new JSONException("Misplaced array.");
    }

    private JSONWriter end(char c, char c2) {
        if (this.mode != c) {
            throw new JSONException(c == 'a' ? "Misplaced endArray." : "Misplaced endObject.");
        }
        this.pop(c);
        try {
            this.writer.write(c2);
        }
        catch (IOException iOException) {
            throw new JSONException(iOException);
        }
        this.comma = true;
        return this;
    }

    public JSONWriter endArray() {
        return this.end('a', ']');
    }

    public JSONWriter endObject() {
        return this.end('k', '}');
    }

    public JSONWriter key(String string) {
        if (string == null) {
            throw new JSONException("Null key.");
        }
        if (this.mode == 'k') {
            try {
                this.stack[this.top - 1].putOnce(string, Boolean.TRUE);
                if (this.comma) {
                    this.writer.write(44);
                }
                this.writer.write(JSONObject.quote(string));
                this.writer.write(58);
                this.comma = false;
                this.mode = (char)111;
                return this;
            }
            catch (IOException iOException) {
                throw new JSONException(iOException);
            }
        }
        throw new JSONException("Misplaced key.");
    }

    public JSONWriter object() {
        if (this.mode == 'i') {
            this.mode = (char)111;
        }
        if (this.mode == 'o' || this.mode == 'a') {
            this.append("{");
            this.push(new JSONObject());
            this.comma = false;
            return this;
        }
        throw new JSONException("Misplaced object.");
    }

    private void pop(char c) {
        char c2;
        if (this.top <= 0) {
            throw new JSONException("Nesting error.");
        }
        char c3 = c2 = this.stack[this.top - 1] == null ? (char)'a' : 'k';
        if (c2 != c) {
            throw new JSONException("Nesting error.");
        }
        --this.top;
        this.mode = (char)(this.top == 0 ? 100 : (this.stack[this.top - 1] == null ? 97 : 107));
    }

    private void push(JSONObject jSONObject) {
        if (this.top >= 200) {
            throw new JSONException("Nesting too deep.");
        }
        this.stack[this.top] = jSONObject;
        this.mode = (char)(jSONObject == null ? 97 : 107);
        ++this.top;
    }

    public JSONWriter value(boolean bl) {
        return this.append(bl ? "true" : "false");
    }

    public JSONWriter value(double d) {
        return this.value((Object)d);
    }

    public JSONWriter value(long l) {
        return this.append(Long.toString(l));
    }

    public JSONWriter value(Object object) {
        return this.append(JSONObject.valueToString(object));
    }

    static {
        IBootstrap.dasBoot();
    }
}

